#include <mail/so/spamstop/tools/so-common/kfunc.h>
#include "tcomplshinglerenv.h"

//*************************************************************************************************************************
//                                                TCntComplShingle
//*************************************************************************************************************************

TCntComplShingle::TCntComplShingle() {
    m_shingle = 0;
    m_type = 0;
    m_shingle_str = "";
}

TCntComplShingle::TCntComplShingle(ui64 shingleA, ui8 typeA) {
    char buff[32];

    m_shingle = shingleA;
    m_type = typeA;
    memset(buff, 0, sizeof(buff));
    snprintf(buff, sizeof(buff) - 1, "%016" PRIx64, m_shingle);
    m_shingle_str = TString(buff);
}

//*************************************************************************************************************************
//                                                  TCntComplShingleRequest
//*************************************************************************************************************************

TCntComplShingleRequest::TCntComplShingleRequest() {
    m_is_abuse = false;
    m_is_count = false;
    m_uniq_sd_spam = 0;
    m_uniq_sd_ham = 0;
    m_ham = 0;
    m_spam = 0;
    m_malic = 0;
    m_persham = 0;
    m_persspam = 0;
    m_shingle = TCntComplShingle();
    m_res_shingles_source = "";
    ResClear();
}

TCntComplShingleRequest::TCntComplShingleRequest(ui64 shingleA, ui8 typeA) {
    m_is_abuse = false;
    m_is_count = false;
    m_uniq_sd_spam = 0;
    m_uniq_sd_ham = 0;
    m_ham = 0;
    m_spam = 0;
    m_malic = 0;
    m_persham = 0;
    m_persspam = 0;
    m_shingle = TCntComplShingle(shingleA, typeA);
    m_res_shingles_source = "";
    ResClear();
}

TCntComplShingleRequest::TCntComplShingleRequest(ui64 shingleA, ui8 typeA, const TString& shingle_source, ui32 uniq_sd_spam, ui32 uniq_sd_ham) {
    m_is_abuse = true;
    m_is_count = false;
    m_uniq_sd_spam = uniq_sd_spam;
    m_uniq_sd_ham = uniq_sd_ham;
    m_ham = 0;
    m_spam = 0;
    m_malic = 0;
    m_persham = 0;
    m_persspam = 0;
    m_shingle = TCntComplShingle(shingleA, typeA);
    m_res_shingles_source = shingle_source;
    ResClear();
}

TCntComplShingleRequest::TCntComplShingleRequest(ui64 shingleA, ui8 typeA, ui32 ham, ui32 spam, ui32 malic, ui32 persham, ui32 persspam) {
    m_is_abuse = false;
    m_is_count = true;
    m_uniq_sd_spam = 0;
    m_uniq_sd_ham = 0;
    m_ham = ham;
    m_spam = spam;
    m_malic = malic;
    m_persham = persham;
    m_persspam = persspam;
    m_shingle = TCntComplShingle(shingleA, typeA);
    m_res_shingles_source = "";
    ResClear();
}

TCntComplShingleRequest::~TCntComplShingleRequest() {
}

const char* TCntComplShingleRequest::sShingle() const {
    return m_shingle.Shingle_str().c_str();
}

void TCntComplShingleRequest::ResClear() {
    m_today_firsttime = 0;
    m_today_lasttime = 0;
    m_today_ham = 0;
    m_today_spam = 0;
    m_today_malic = 0;
    m_today_pers_ham = 0;
    m_today_pers_spam = 0;
    m_today_complaint_ham = 0;
    m_today_complaint_spam = 0;
    m_today_virus_count = 0;
    m_today_uniq_sd_spam = 0;
    m_today_uniq_sd_ham = 0;
    m_today_expert_spam = 0;
    m_today_expert_ham = 0;

    m_history_firsttime = kday_t((unsigned long)0);
    m_history_lasttime = kday_t((unsigned long)0);
    m_history_ham = 0;
    m_history_spam = 0;
    m_history_malic = 0;
    m_history_pers_ham = 0;
    m_history_pers_spam = 0;
    m_history_complaint_ham = 0;
    m_history_complaint_spam = 0;
    m_history_virus_count = 0;
    m_history_uniq_sd_spam = 0;
    m_history_uniq_sd_ham = 0;
    m_history_expert_spam = 0;
    m_history_expert_ham = 0;
    m_history_day_count_with_complaint = 0;
    m_history_day_count_with_virus = 0;
}

bool TCntComplShingleRequest::IsValid() const {
    bool res = false;

    if ((m_shingle.Shingle() != 0) && (m_shingle.Type() >= 0) && (m_shingle.Type() < 128))
        res = true;

    return res;
}

bool TCntComplShingleRequest::ResHistoryEmpty() const {
    bool res = false;

    if ((((ui32)m_history_firsttime) == 0) && (((ui32)m_history_lasttime) == 0))
        res = true;

    return res;
}

bool TCntComplShingleRequest::ResTodayEmpty() const {
    bool res = false;

    if ((m_today_firsttime == 0) && (m_today_lasttime == 0))
        res = true;

    return res;
}

void TCntComplShingleRequest::SetShingleSource(const TString& source) {
    m_res_shingles_source = source;
}

void TCntComplShingleRequest::SetTodayCounters(ui32 tv1, ui32 tv2, ui32 tv3, ui32 tv4, ui32 tv5, ui32 tv6, ui32 tv7, ui32 tv8, ui32 tv9, ui32 tv10, ui32 tv11, ui32 tv12, ui32 tv13, ui32 tv14) {
    m_today_firsttime = tv1;
    m_today_lasttime = tv2;
    m_today_ham = tv3;
    m_today_spam = tv4;
    m_today_malic = tv5;
    m_today_pers_ham = tv6;
    m_today_pers_spam = tv7;
    m_today_complaint_ham = tv8;
    m_today_complaint_spam = tv9;
    m_today_virus_count = tv10;
    m_today_uniq_sd_spam = tv11;
    m_today_uniq_sd_ham = tv12;
    m_today_expert_spam = tv13;
    m_today_expert_ham = tv14;
}

void TCntComplShingleRequest::SetHistoryCounters(ui32 hv1, ui32 hv2, ui32 hv3, ui32 hv4, ui32 hv5, ui32 hv6, ui32 hv7, ui32 hv8, ui32 hv9, ui32 hv10, ui32 hv11, ui32 hv12, ui32 hv13, ui32 hv14, ui32 hv15, ui32 hv16) {
    m_history_firsttime = kday_t((unsigned long)hv1);
    m_history_lasttime = kday_t((unsigned long)hv2);
    m_history_ham = hv3;
    m_history_spam = hv4;
    m_history_malic = hv5;
    m_history_pers_ham = hv6;
    m_history_pers_spam = hv7;
    m_history_complaint_ham = hv8;
    m_history_complaint_spam = hv9;
    m_history_virus_count = hv10;
    m_history_uniq_sd_spam = hv11;
    m_history_uniq_sd_ham = hv12;
    m_history_expert_spam = hv13;
    m_history_expert_ham = hv14;
    m_history_day_count_with_complaint = hv15;
    m_history_day_count_with_virus = hv16;
}

TString TCntComplShingleRequest::GetRequestGetCluster() {
    TString res = "";

    res = ShingleToStroka(Shingle()) + "-" + IntToStroka(Type()) + "=";

    return res;
}

TString TCntComplShingleRequest::GetRequestAddComplaint() {
    TString res = "";
    TString shingle_source_t = m_res_shingles_source;

    CGIEscape(shingle_source_t);
    res = ShingleToStroka(Shingle()) + "-" + IntToStroka(Type()) + "=" + IntToStroka(m_uniq_sd_spam) + "-" + IntToStroka(m_uniq_sd_ham) + "-" + shingle_source_t;

    return res;
}

TString TCntComplShingleRequest::GetRequestAddVirus() {
    return GetRequestGetCluster();
}

TString TCntComplShingleRequest::GetRequestAddCount() {
    TString res = "";

    res = ShingleToStroka(Shingle()) + "-" + IntToStroka(Type()) + "=" + IntToStroka(m_ham) + "-" + IntToStroka(m_spam) + "-" + IntToStroka(m_malic) + "-" + IntToStroka(m_persham) + "-" + IntToStroka(m_persspam);

    return res;
}

ui32 TCntComplShingleRequest::GetTodayFirsttimeElapsed() {
    ui32 res = 0;
    ui32 currenttime = 0;

    currenttime = time(nullptr);
    if (currenttime >= GetTodayFirsttime())
        res = currenttime - GetTodayFirsttime();

    return res;
}

ui32 TCntComplShingleRequest::GetTodayLasttimeElapsed() {
    ui32 res = 0;
    ui32 currenttime = 0;

    currenttime = time(nullptr);
    if (currenttime >= GetTodayLasttime())
        res = currenttime - GetTodayLasttime();

    return res;
}

ui32 TCntComplShingleRequest::GetHistoryFirsttimeElapsed() const {
    ui32 res = 0;
    ui32 currenttime = 0;

    currenttime = (ui32)(kday_t(time(nullptr)));
    if (currenttime >= (ui32)GetHistoryFirsttime())
        res = currenttime - (ui32)GetHistoryFirsttime();

    return res;
}

ui32 TCntComplShingleRequest::GetHistoryLasttimeElapsed() const {
    ui32 res = 0;
    ui32 currenttime = 0;

    currenttime = (ui32)(kday_t(time(nullptr)));
    if (currenttime >= (ui32)GetHistoryLasttime())
        res = currenttime - (ui32)GetHistoryLasttime();

    return res;
}
