#pragma once

/*
 * tdictshinglerenv.h
 *
 *  Created on: 20 янв. 2016 г.
 *      Author: luckybug
 */

#ifndef TDICTSHINGLERENV_H_
#define TDICTSHINGLERENV_H_

#include <util/generic/string.h>
#include <util/generic/hash.h>
#include <util/system/mutex.h>
#include <util/system/defaults.h>
#include <library/cpp/cgiparam/cgiparam.h>
#include <util/generic/set.h>
#include <util/generic/hash_set.h>

#include "dict/dictutil/dictutil.h"
#include <list>
#include <library/cpp/json/writer/json.h>
#include <mail/so/spamstop/tools/so-common/kfunc.h>
#include <mail/so/spamstop/tools/so-common/anyvalue.h>
#include <mail/so/spamstop/tools/so-common/sobase64.h>
#include "ktime.h"

#include "TDictRequest.h"

#define PERSB_DISABLE_CHECK_REQUEST 0x00000001
#define PERSB_DISABLE_WRITE_CHECK_REQUEST_EXTERROR 0x00000002
#define PERSB_WRITE_LOG_REQUEST 0x00000004
#define PERSB_WRITE_LOG_RESPONCE 0x00000008
#define PERSB_DISABLE_WRITE_TRACCERT 0x00000010
#define SET_PERSB_DISABLE_CHECK_REQUEST(flag) \
    { (flag) |= PERSB_DISABLE_CHECK_REQUEST; }
#define SET_PERSB_DISABLE_WRITE_CHECK_REQUEST_EXTERROR(flag) \
    { (flag) |= PERSB_DISABLE_WRITE_CHECK_REQUEST_EXTERROR; }
#define SET_PERSB_WRITE_LOG_REQUEST(flag) \
    { (flag) |= PERSB_WRITE_LOG_REQUEST; }
#define SET_PERSB_WRITE_LOG_RESPONCE(flag) \
    { (flag) |= PERSB_WRITE_LOG_RESPONCE; }
#define SET_PERSB_DISABLE_WRITE_TRACCERT(flag) \
    { (flag) |= PERSB_DISABLE_WRITE_TRACCERT; }
#define IS_PERSB_DISABLE_CHECK_REQUEST(flag) ((flag)&PERSB_DISABLE_CHECK_REQUEST)
#define IS_PERSB_DISABLE_WRITE_CHECK_REQUEST_EXTERROR(flag) ((flag)&PERSB_DISABLE_WRITE_CHECK_REQUEST_EXTERROR)
#define IS_PERSB_WRITE_LOG_REQUEST(flag) ((flag)&PERSB_WRITE_LOG_REQUEST)
#define IS_PERSB_WRITE_LOG_RESPONCE(flag) ((flag)&PERSB_WRITE_LOG_RESPONCE)
#define IS_PERSB_DISABLE_WRITE_TRACCERT(flag) ((flag)&PERSB_DISABLE_WRITE_TRACCERT)

#define PBSP_COLLISION 0x00000001      //find collision
#define PBSP_DUBLICAT 0x00000002       //find dublicat
#define PBSP_BADSPAMTYPE 0x00000004    //find bad spamtype
#define PBSP_NOTVALID 0x00000008       //find not valid shingle
#define PBSP_COMPRESS_ERROR 0x00000010 //compress error
#define SET_PBSP_COLLISION(flag) \
    { (flag) |= PBSP_COLLISION; }
#define SET_PBSP_DUBLICAT(flag) \
    { (flag) |= PBSP_DUBLICAT; }
#define SET_PBSP_BADSPAMTYPE(flag) \
    { (flag) |= PBSP_BADSPAMTYPE; }
#define SET_PBSP_NOTVALID(flag) \
    { (flag) |= PBSP_NOTVALID; }
#define SET_PBSP_COMPRESS_ERROR(flag) \
    { (flag) |= PBSP_COMPRESS_ERROR; }
#define IS_PBSP_COLLISION(flag) ((flag)&PBSP_COLLISION)
#define IS_PBSP_DUBLICAT(flag) ((flag)&PBSP_DUBLICAT)
#define IS_PBSP_BADSPAMTYPE(flag) ((flag)&PBSP_BADSPAMTYPE)
#define IS_PBSP_NOTVALID(flag) ((flag)&PBSP_NOTVALID)
#define IS_PBSP_COMPRESS_ERROR(flag) ((flag)&PBSP_COMPRESS_ERROR)

namespace DictionaryShingler {
    struct TWordAndCount {
        TString word;
        ui32 count;

        TWordAndCount() {
            Clear();
        }

        TWordAndCount(const TString& wordA, ui32 countA) {
            word = wordA;
            count = countA;
        }

        void Clear() {
            word = "";
            count = 0;
        }
    };
    typedef std::list<Request> request_list_t;
    typedef request_list_t::iterator request_list_it_t;

    typedef TVector<Request> request_vector_t;

    typedef THashMap<ui64, Request> request_hash_t;
    typedef request_hash_t::iterator request_hash_it_t;

    struct CheckINListStruct {
        bool empty;
        TString rasdelitel;
        TString error_res;
        ui32 allcount;
        ui32 dublicat_count;
        ui32 collision_count;
        ui32 bad_spamtype_count;
        ui32 not_valid_count;
        bool compress_error;
        TString compress_request_data;
        ui32 traccert_checkrequest_tick;
        ui32 traccert_createrequest_tick;
        ui32 traccert_packrequest_tick;
        ui32 traccert_post_tick;
        ui32 traccert_unpackresponce_tick;
        ui32 traccert_parseresponce_tick;
        ui32 traccert_fillresponcedata_tick;

        CheckINListStruct() {
            rasdelitel = "; ";
            Clear();
        }

        CheckINListStruct(const TString& rasdelitelA) {
            rasdelitel = rasdelitelA;
            Clear();
        }

        void Clear() {
            empty = false;
            error_res = "";
            allcount = 0;
            dublicat_count = 0;
            collision_count = 0;
            bad_spamtype_count = 0;
            not_valid_count = 0;
            compress_error = false;
            compress_request_data = "";
            traccert_checkrequest_tick = 0;
            traccert_createrequest_tick = 0;
            traccert_packrequest_tick = 0;
            traccert_post_tick = 0;
            traccert_unpackresponce_tick = 0;
            traccert_parseresponce_tick = 0;
            traccert_fillresponcedata_tick = 0;
        }

        bool CheckOK() {
            bool res = false;

            if ((dublicat_count == 0) && (collision_count == 0) && (bad_spamtype_count == 0) && (error_res.empty()))
                res = true;

            return res;
        }

        int GetError() {
            int res = 0;

            if (collision_count > 0)
                SET_PBSP_COLLISION(res);

            if (dublicat_count > 0)
                SET_PBSP_DUBLICAT(res);

            if (bad_spamtype_count > 0)
                SET_PBSP_BADSPAMTYPE(res);

            if (not_valid_count > 0)
                SET_PBSP_NOTVALID(res);

            if (compress_error)
                SET_PBSP_COMPRESS_ERROR(res);

            return res;
        }

        TString GetErrorS() {
            TString res = "";

            if (empty) {
                if (!res.empty())
                    res = res + "+EMPTY";
                else
                    res = res + "EMPTY";
            }

            if (collision_count > 0) {
                if (!res.empty())
                    res = res + "+COLLISION";
                else
                    res = res + "COLLISION";
            }

            if (dublicat_count > 0) {
                if (!res.empty())
                    res = res + "+DUBLICAT";
                else
                    res = res + "DUBLICAT";
            }

            if (bad_spamtype_count > 0) {
                if (!res.empty())
                    res = res + "+BADSPAMTYPE";
                else
                    res = res + "BADSPAMTYPE";
            }

            if (not_valid_count > 0) {
                if (!res.empty())
                    res = res + "+NOTVALID";
                else
                    res = res + "NOTVALID";
            }

            if (compress_error) {
                if (!res.empty())
                    res = res + "+COMPRESSERROR";
                else
                    res = res + "COMPRESSERROR";
            }

            return res;
        }

        TString GetTrace() {
            char buff[128];

            snprintf(buff, sizeof(buff), "%u-%u-%u,%u,%u-%u-%u", traccert_checkrequest_tick, traccert_createrequest_tick, traccert_packrequest_tick, traccert_post_tick, traccert_unpackresponce_tick, traccert_parseresponce_tick, traccert_fillresponcedata_tick);

            return TString(buff);
        }
    };

    class Parser {
#define TODAY_TAG "tod"
#define YESTERDAY_TAG "yes"
#define HISTORY_TAG "his"
#define FLAGS_TAG "fla"

        typedef THashMap<TString, TString> TSuidHashRqst;
        typedef TSuidHashRqst::iterator TSuidHashRqstIt;

        typedef THashMap<TString, TWordAndCount> TSuidHash;
        typedef TSuidHash::iterator TSuidHashIt;

        typedef THashMap<ui32, TSuidHash> TTypeHash;
        typedef TTypeHash::iterator TTypeHashIt;

        typedef THashMap<ui64, TTypeHash> TShingleHash;
        typedef TShingleHash::iterator TShingleHashIt;

    public:
        static bool CreateRequestData(const request_vector_t& shingle_list, RequestType rqst_type, CheckINListStruct& check_res, ui32 priznak);
        static bool ParseResponceData(const TString& compress_responce, request_hash_t& shingle_hash, ui32& err, CheckINListStruct& check_res);

    private:
        static void checkRequest(const request_vector_t& shingle_list, RequestType rqst_type, ui32 priznak, CheckINListStruct& check_res);
        static bool ParseShinglesData(const TString& responce, request_hash_t& shingle_hash);
        static bool ParseShingle(const TString& responce, request_hash_t& shingle_hash);

        static bool ParseStat(const char* src, Stat& stat);

        template <Stat::Time>
        static bool ParseCounter(const char* src, Counters& c);
        static bool ParseFlags(const char* src, ui64& flag);
    };
}

NJsonWriter::TBuf& PrintJson(const DictionaryShingler::request_vector_t& request, NJsonWriter::TBuf &json);

#endif /* TDICTSHINGLERENV_H_ */
