#pragma once

#include "freemail.h"

#include <util/generic/list.h>
#include <util/generic/hash.h>
#include "util/generic/string.h"


//****************************************************************************************************
//                                     TSenderRequest
//****************************************************************************************************

#define SNDR_DL_FBR 0x00000001        //DL_FBR
#define SNDR_FIXED_SOURCE 0x00000002  //FIXED_SOURCE
#define SNDR_SOURCE_LEVEL1 0x00000004 //SOURCE_LEVEL1
#define SNDR_WEBMASTER 0x00000008     //WEBMASTER
#define SNDR_MALIC 0x00000010         //MALIC

#define SET_SNDR_DL_FBR(flag) \
    { (flag) |= SNDR_DL_FBR; }
#define SET_SNDR_FIXED_SOURCE(flag) \
    { (flag) |= SNDR_FIXED_SOURCE; }
#define SET_SNDR_SOURCE_LEVEL1(flag) \
    { (flag) |= SNDR_SOURCE_LEVEL1; }
#define SET_SNDR_WEBMASTER(flag) \
    { (flag) |= SNDR_WEBMASTER; }

#define IS_SNDR_DL_FBR(flag) ((flag)&SNDR_DL_FBR)
#define IS_SNDR_FIXED_SOURCE(flag) ((flag)&SNDR_FIXED_SOURCE)
#define IS_SNDR_SOURCE_LEVEL1(flag) ((flag)&SNDR_SOURCE_LEVEL1)
#define IS_SNDR_WEBMASTER(flag) ((flag)&SNDR_WEBMASTER)
#define IS_SNDR_MALIC(flag) ((flag)&SNDR_MALIC)

