#pragma once

#ifndef turlstat_H
#define turlstat_H

#include <util/generic/hash.h>
#include <util/generic/string.h>
#include <util/generic/vector.h>

#include <library/cpp/charset/doccodes.h>

enum EUrlStaticticSource : ui8 {
    SENDER = 1,
    RCVDS = 2,
    BODY = 4
};

struct TUrlCounters {
    ui32 ham = 0;
    ui32 spam = 0;
    ui32 complaint_ham = 0;
    ui32 complaint_spam = 0;
};

struct TUrlInfo {
    bool virus = false;
    ui8 phishing_mask = 0;
    ui8 server_surbl = 0;

    ui32 first_date = 0;
    ui32 last_date = 0;
    ui32 current_date = 0;

    ui64 shingle_url = 0;
    ui64 shingle_host = 0;

    TString url;
    TString host;

    TUrlCounters today;
    TUrlCounters history;
    THashMap<TString, ui8> aliases;

    void CalcUrlShingle();
    void CalcHostShingle();
    void SetPhishingVDirect();
    void SetPhishingCBB();

    bool NoData() const;

    ui32 FirstTimeElapsed() const;
    ui32 LastTimeElapsed() const;

    TString Virus() const;

    bool IsPhishing() const;
    bool IsPhishingCBB() const;
    bool IsPhishingVDirect() const;
    TString Phishing() const;
};

class TUrlStatistic {
public:
    TUrlInfo checkUrl;
    TUrlInfo longUrl;
    bool isLink = false;
    bool isSpam = false;
    bool noAddStorage = false;
    ui32 flags = 0;
    TVector<TString> aliases;

public:
    TUrlStatistic() = default;
    TUrlStatistic(const TStringBuf& url, ECharset charset, bool link, bool spam, bool noaddstorage, TVector<TString> aliases, ui32 flags);
    TUrlStatistic(const TStringBuf& url, ECharset charset, bool link, bool spam);

    void AddLongUrl(const TStringBuf& url, ECharset charset);
};

using TUrlStatisticVector = TVector<TUrlStatistic>;

#endif
