#include <mail/so/spamstop/tools/so-clients/functional_clients/BBShClient.h>
#include <library/cpp/testing/unittest/registar.h>


Y_UNIT_TEST_SUITE(BB) {

    Y_UNIT_TEST(ParseResponse) {

        const TStringBuf text = R"(<?xml version="1.0" encoding="UTF-8"?>
<doc>
<uid hosted="1" domid="2615364" domain="zadelo.pro" mx="1" domain_ena="1" catch_all="0">1130000025093725</uid>
<login>art@zadelo.pro</login>
<have_password>1</have_password>
<have_hint>1</have_hint>
<karma confirmed="0">0</karma>
<karma_status>0</karma_status>
<dbfield id="subscription.suid.2">1130000042296671</dbfield>
<dbfield id="userinfo.country.uid">by</dbfield>
<dbfield id="userinfo.reg_date.uid">2017-10-23 12:42:56</dbfield>
<attributes>
<attribute type="36">8900</attribute>
</attributes>
</doc>
)";

        const auto response = NBlackbox2::InfoResponse(text);

        UNIT_ASSERT_EQUAL(NFuncClient::CBB::GetSuidFromBBResponse(*response), "1130000042296671");
        UNIT_ASSERT_EQUAL(NBlackbox2::TLoginInfo(response.Get()).Login(), "art@zadelo.pro");
        UNIT_ASSERT_EQUAL(NFuncClient::CBB::GetCountryFromBBResponse(*response), "by");
        UNIT_ASSERT_EQUAL(NBlackbox2::TKarmaInfo(response.Get()).Karma(), "0");
        UNIT_ASSERT_EQUAL(NBlackbox2::TKarmaInfo(response.Get()).KarmaStatus(), "0");
        UNIT_ASSERT_EQUAL(NBlackbox2::TUid(response.Get()).Uid(), "1130000025093725");
        UNIT_ASSERT_EQUAL(NFuncClient::CBB::GetRegDateFromBBResponse(*response), TInstant::ParseIso8601("2017-10-23T12:42:56.000000Z"));
        UNIT_ASSERT_EQUAL(NFuncClient::CBB::GetPhoneFromBBResponse(*response), "8900");
    }
}
