#include <library/cpp/testing/unittest/registar.h>
#include <library/cpp/coroutine/engine/impl.h>
#include <mail/so/libs/curl/storage.h>

#include "server.h"

Y_UNIT_TEST_SUITE(CurlStorage) {
    void Run(TCont* cont) {
        THandlerServer server;

        const size_t count = 13;
        TVector<NCurl::TRequestContext> requests;
        for (size_t i = 0; i < count; ++i) {
            requests.emplace_back()
                .SetHost("127.0.0.1")
                .SetPort(ut_port)
                .SetContentType("text/html")
                .SetPostData("message #" + ToString(i));
        }

        NCurl::TOptions options;
        NCurl::TPoolTraits traits(options);
        NCurl::TStorage storage(TPoolParams(17, TDuration::Seconds(1)));

        auto art = storage.Process(std::move(NCurl::TRequestContext().SetHost("127.0.0.1")
                                           .SetPort(ut_port)
                                           .SetContentType("text/html")
                                           .SetPostData("message #0")), traits, TDuration::Seconds(1).ToDeadLine(), cont);
        UNIT_ASSERT_EQUAL(art.body.Str(), "message #0");

        auto artifacts = storage.Process(std::move(requests), traits, TDuration::Seconds(1).ToDeadLine(), cont);
        for (size_t i = 0; i < count; ++i) {
            UNIT_ASSERT_EQUAL(artifacts[i].body.Str(), "message #" + ToString(i));
        }
    }

    Y_UNIT_TEST(Storage) {
        Run(nullptr);
    }

#if !defined(_asan_enabled_)
    Y_UNIT_TEST(Coroutine) {
        TContExecutor contExecutor(320000);
        auto functor = [](TCont* cont) { Run(cont); };
        contExecutor.Create(functor, "coroutine");
        contExecutor.Execute();
    }
#endif
};
