#include "ktime.h"
#include "freemail.h"
#include <util/string/split.h>
#include <library/cpp/testing/unittest/registar.h>

Y_UNIT_TEST_SUITE(RcptItem) {
    void RcptItemTest(const NFreeMail::TRecepientInfo& item, const TString& address, ui32 send, ui32 recv)
    {
        UNIT_ASSERT_EQUAL(item.address, address);
        UNIT_ASSERT_EQUAL(item.send, send);
        UNIT_ASSERT_EQUAL(item.recieve, recv);
    }

    Y_UNIT_TEST(Constructor) {
        RcptItemTest(NFreeMail::TRecepientInfo(), nullptr, 0, 0);
        RcptItemTest(NFreeMail::TRecepientInfo("address"), "address",  0, 0);
        RcptItemTest(NFreeMail::TRecepientInfo("address", 13, 17), "address", 13, 17);
    }
}

Y_UNIT_TEST_SUITE(Type) {
    Y_UNIT_TEST(Info) {
        NFreeMail::TInfo info;
        UNIT_ASSERT_EQUAL(info.get_time, 0);
        UNIT_ASSERT_EQUAL(info.create_time, 0);
        UNIT_ASSERT_EQUAL(info.update_time, 0);
        UNIT_ASSERT_EQUAL(info.unique_geo_zone, 0);
        UNIT_ASSERT_EQUAL(info.active_days, 0);
        UNIT_ASSERT_EQUAL(info.max_recipients_count, 0);

        UNIT_ASSERT_EQUAL(info.send.ham, 0);
        UNIT_ASSERT_EQUAL(info.send.spam, 0);
        UNIT_ASSERT_EQUAL(info.receive.ham, 0);
        UNIT_ASSERT_EQUAL(info.receive.spam, 0);
        UNIT_ASSERT_EQUAL(info.complaint.ham, 0);
        UNIT_ASSERT_EQUAL(info.complaint.spam, 0);
        UNIT_ASSERT_EQUAL(info.unique_complaint_user.ham, 0);
        UNIT_ASSERT_EQUAL(info.unique_complaint_user.spam, 0);
    }

    Y_UNIT_TEST(PDD) {
        NFreeMail::TPDDInfo info;

        UNIT_ASSERT_EQUAL(info.karma, 0);
        UNIT_ASSERT_EQUAL(info.first_time, 0);
        UNIT_ASSERT_EQUAL(info.mailbox_count, 0);

        UNIT_ASSERT_EQUAL(info.bounce.today, 0);
        UNIT_ASSERT_EQUAL(info.bounce.total, 0);

        UNIT_ASSERT_EQUAL(info.admin_uid.empty(), true);
        UNIT_ASSERT_EQUAL(info.host.empty(), true);
        UNIT_ASSERT_EQUAL(info.ip.Undefined(), true);
    }

    Y_UNIT_TEST(Bounce) {
        NFreeMail::TBounceInfo info;

        UNIT_ASSERT_EQUAL(info.spam.today, 0);
        UNIT_ASSERT_EQUAL(info.spam.total, 0);
        UNIT_ASSERT_EQUAL(info.unknown.today, 0);
        UNIT_ASSERT_EQUAL(info.unknown.total, 0);

        UNIT_ASSERT_EQUAL(info.last_type, 0);
        UNIT_ASSERT_EQUAL(info.last_date, 0);
        UNIT_ASSERT_EQUAL(info.get_date, 0);
    }

    Y_UNIT_TEST(EmailInfo) {
        NFreeMail::TEmailInfo yandex(NFreeMail::TEmailInfo::UUID("23")), other(NFreeMail::TEmailInfo::External("23")), null(NFreeMail::TEmailInfo::UUID(nullptr));

        UNIT_ASSERT_EQUAL(yandex.GetUUID(), 23);
        UNIT_ASSERT_EQUAL(yandex.GetShingle(), 0x08329607b4eb8784);
        UNIT_ASSERT_EQUAL(yandex.IsYandex(), true);
        UNIT_ASSERT_EQUAL(other.IsYandex(), false);

        UNIT_ASSERT_EQUAL(yandex.GetHash(), 0x08329607b4eb8784);
        UNIT_ASSERT_EQUAL(other.GetHash() , 0x2807aa42047041dd);

        UNIT_ASSERT_EQUAL(yandex.Empty(), false);
        UNIT_ASSERT_EQUAL(other.Empty(), false);
        UNIT_ASSERT_EQUAL(null.Empty(), true);
    }

    Y_UNIT_TEST(Create) {
        auto yandex = NFreeMail::TEmailInfo::Create("ID", "ID", true);
        auto other = NFreeMail::TEmailInfo::Create("ID", "ID", false);

        UNIT_ASSERT_EQUAL(yandex.IsYandex(), true);
        UNIT_ASSERT_EQUAL(other.IsYandex(), false);

        UNIT_ASSERT_EQUAL(yandex.GetHash(), 0x08323f07b4eaf3a6);
        UNIT_ASSERT_EQUAL(other.GetHash() , 0x28070342047135ff);
    }

    Y_UNIT_TEST(Stream) {
        NFreeMail::THamSpamInfo info(7, 13);
        NFreeMail::TDayCounter counter(23, 42);

        TStringStream stream;
        stream << info << " | " << counter << Endl;

        UNIT_ASSERT_EQUAL(stream.Str(), "7 13 | 23 42\n");
    }
}

Y_UNIT_TEST_SUITE(ElapsedTime) {
    Y_UNIT_TEST(Info) {
        NFreeMail::TInfo info(7, 13, 42, {}, {}, {}, {}, 0, 0, 0);
        NFreeMail::TInfo negate(42, 13, 7, {}, {}, {}, {}, 0, 0, 0);

        UNIT_ASSERT_EQUAL(negate.GetCreateElapsedTime(), 0);
        UNIT_ASSERT_EQUAL(negate.GetUpdateElapsedTime(), 0);

        UNIT_ASSERT_EQUAL(info.GetCreateElapsedTime(), 35);
        UNIT_ASSERT_EQUAL(info.GetUpdateElapsedTime(), 29);
    }

    Y_UNIT_TEST(Bounce) {
        NFreeMail::TBounceInfo info({}, {}, 7, 13, 42);
        NFreeMail::TBounceInfo negate({}, {}, 7, 42, 13);

        UNIT_ASSERT_EQUAL(negate.GetElapsedTime(), 0);
        UNIT_ASSERT_EQUAL(info.GetElapsedTime(), 29);
    }
}
