#include "freemailhost.h"
#include <util/system/tempfile.h>
#include <library/cpp/testing/unittest/registar.h>

Y_UNIT_TEST_SUITE(FreemailHosts) {
    Y_UNIT_TEST(GetSenderTypeByEmailExclude) {
        TFreeMailHosts hosts;

        UNIT_ASSERT_EQUAL(hosts.IsFreemailByEmail("test@Ya.rU"), true);
        UNIT_ASSERT_EQUAL(hosts.IsFreemailByEmail("maiLER-daemon  @ya.ru"), false);
    }

    static const TVector<TString> domenInfo = {
        "km.ru", "freemail.ru", "girlmail.ru", "bossmail.ru", "megabox.ru", "boymail.ru", "safebox.ru",
        "qip.ru", "pochta.ru", "fromru.com", "front.ru", "hotbox.ru", "hotmail.ru", "krovatka.su", "land.ru", "mail15.com", "mail333.com", "newmail.ru", "nightmail.ru", "nm.ru", "pisem.net", "pop3.ru", "rbcmail.ru", "smtp.ru", "5ballov.ru", "aeterna.ru", "ziza.ru", "memori.ru", "photofile.ru", "photoplenka.ru",
        "aol.com",
        "yahoo.com",
        "yandex.ru", "ya.ru", "narod.ru",
        "mail.ru", "inbox.ru", "bk.ru", "list.ru",
        "gmail.com",
        "rambler.ru",
        "hotmail.com", "live.ru", "outlook.com"
    };

    Y_UNIT_TEST(GetSenderTypeByEmailSmall) {
        TFreeMailHosts hosts;
        for (const auto& domen : domenInfo) {
            TString text = "test@" + domen;
            UNIT_ASSERT_EQUAL_C(hosts.IsFreemailByEmail(text), true, text);
        }
    }

    Y_UNIT_TEST(GetSenderTypeByEmailYahoo) {
        TFreeMailHosts hosts;
        UNIT_ASSERT_EQUAL(hosts.IsFreemailByEmail("test@yahoo.co"), true);
        UNIT_ASSERT_EQUAL(hosts.IsFreemailByEmail("test@some1.yahoo.com"), true);
        UNIT_ASSERT_EQUAL(hosts.IsFreemailByEmail("test@some.yahoo.co.ru"), true);
        UNIT_ASSERT_EQUAL(hosts.IsFreemailByEmail("test@some.yahoo.com.ua"), true);

        UNIT_ASSERT_EQUAL(hosts.IsFreemailByEmail("test@some.yahoo.coco.ru"), false);
        UNIT_ASSERT_EQUAL(hosts.IsFreemailByEmail("test@some.yahoo.comz.ua"), false);
        UNIT_ASSERT_EQUAL(hosts.IsFreemailByEmail("test@some.yahoo.com.kz.ru"), false);
        UNIT_ASSERT_EQUAL(hosts.IsFreemailByEmail("test@some.yahoo.co.net.ru"), false);
    }
}
