#pragma once

#include <library/cpp/http/server/http_ex.h>
#include <util/system/mutex.h>

static const ui16 ut_port = 10101;

class THandlerServer : private THttpServer::ICallBack, public THttpServer {
    class TRequest : public THttpClientRequestEx {
    public:
        TRequest(THandlerServer* server);

        bool Reply(void* /*tsr*/) override;

    private:
        bool Prepare();

        THandlerServer* server;
    };
public:
    THandlerServer();
    ~THandlerServer();

    void SetBody(const TString& data);
    TString GetBody() const;

    void SetHeader(const TString& key, const TString value);
    THashMap<TString, TString> GetHeaders() const;

private:
    TClientRequest* CreateClient() override;

    TString body;
    THashMap<TString, TString> headers;
    mutable TMutex mutex;
};
