#include "turlstat.h"
#include <library/cpp/testing/unittest/registar.h>

Y_UNIT_TEST_SUITE(UrlStat) {
    Y_UNIT_TEST(Empty) {
        TUrlInfo info;
        info.CalcUrlShingle();
        info.CalcHostShingle();

        UNIT_ASSERT_EQUAL(info.shingle_url, 0);
        UNIT_ASSERT_EQUAL(info.shingle_host, 0);

        UNIT_ASSERT_EQUAL(info.FirstTimeElapsed(), 0);
        UNIT_ASSERT_EQUAL(info.LastTimeElapsed(), 0);

        UNIT_ASSERT_EQUAL(info.IsPhishing(), false);
        UNIT_ASSERT_EQUAL(info.Phishing(), "");
        UNIT_ASSERT_EQUAL(info.Virus(), "");
    }

    Y_UNIT_TEST(Value) {
        TUrlInfo info;
        info.virus = true;
        info.phishing_mask = 3;
        info.first_date = 1;
        info.last_date = 3;
        info.current_date = 7;

        UNIT_ASSERT_EQUAL(info.FirstTimeElapsed(), 6);
        UNIT_ASSERT_EQUAL(info.LastTimeElapsed(), 4);

        UNIT_ASSERT_EQUAL(info.IsPhishing(), true);
        UNIT_ASSERT_EQUAL(info.Phishing(), "PHISH3");
        UNIT_ASSERT_EQUAL(info.Virus(), "VIR2");
    }
}
