#pragma once

/*
 * ArjReader.h
 *
 *  Created on: 17 июл. 2017 г.
 *      Author: luckybug
 */

#include <util/system/defaults.h>
#include <util/generic/deque.h>
#include <util/generic/vector.h>
#include <util/generic/string.h>

class IInputStream;

namespace NArj {
    struct TFileTraits {
        TFileTraits() = default;
        TString filename;
        ui32 size{};
        ui32 crc{};


    };

    typedef TDeque<TFileTraits> TTraitsList;

    /*
     * breath
     * Actually this functions only reads file info in the archive, not de/compress it
     * http://www.opennet.ru/docs/formats/arj.txt
     */
    bool ReadTraits(IInputStream & stream, TTraitsList& items);
    bool ReadTraits(const char* data, size_t size, TTraitsList& items);
} //    namespace NArj
