#pragma once

#include "AnyValue_v2.h"
#include <util/datetime/base.h>
#include <utility>

struct TUpdateShift{
    NAnyValue::TScalar newVal{};
    size_t size{};
    TUpdateShift() = default;
    TUpdateShift(NAnyValue::TScalar newVal, size_t size) : newVal(std::move(newVal)), size(size) {}
};

struct TUpdateData {
    NAnyValue::TScalarMap incrs;
    NAnyValue::TScalarMap sets;
    NAnyValue::TScalarMap setsOnInsert;
    NAnyValue::TScalarMap ors;
    THashMap<TString, std::pair<TString, TString>> fieldsMax;
};

struct TQueryData {

    size_t Hash() const {
        size_t res = NAnyValue::Hash(equals);

        res = CombineHashes(res, NAnyValue::Hash(gt));
        res = CombineHashes(res, NAnyValue::Hash(lt));
        res = CombineHashes(res, NAnyValue::Hash(in));

        for(const auto & v : ors)
            res = CombineHashes(res, v.Hash());

        return res;
    }

    bool empty() const {
        return equals.empty() &&
               gt.empty() &&
               lt.empty() &&
               ors.empty() &&
               in.empty();
    }

    NAnyValue::TScalarMap equals;
    NAnyValue::TScalarMap gt;
    NAnyValue::TScalarMap lt;

    NAnyValue::TScalarVectorMap in;

    using or_t = TVector<TQueryData>;
    or_t ors;

    TMaybe<size_t> shard;
};

struct TFindAction {
    TQueryData query;
};

struct TUpdateAction {
    TQueryData query{};
    TUpdateData update;
    bool upsert;
    TUpdateAction()
        : upsert(false)
    {
    }
};

Y_DECLARE_OUT_SPEC(inline, TQueryData, s, query) {
    s << "equals: " << query.equals << "; ";
    s << "lt: " << query.lt << "; ";
    s << "gt: " << query.gt << "; ";
    s << "in: " << query.in << "; ";

    s << "ors: ";

    for(const auto & o : query.ors)
        s << "[" << o << "]";
}


namespace NConfig{
    class TConfig;
}

using TActionSeries = TVector<TUpdateAction>;
using TFindResults = TVector<NAnyValue::TScalarMap >;

class TCont;
class TStorageBase {
public:
    virtual void SetReadTimeout(const TDuration& timeout) = 0;
    virtual TDuration GetReadTimeout() const = 0;
    virtual void SetWriteTimeout(const TDuration& timeout) = 0;
    virtual TDuration GetWriteTimeout() const = 0;

    virtual size_t Count(
        const TString& collectionName,
        const TFindAction& action) = 0;

    virtual size_t Remove(
        const TString& collectionName,
        const TFindAction& action) = 0;

    virtual size_t Update(
        const TString& collectionName,
        const TUpdateAction& action) = 0;

    virtual void UpdateSeries(
        const TString& collectionName,
        const TActionSeries & actions,
        bool ordered) = 0;

    virtual void UpdateBulk(
        const TString& collectionName,
        const TUpdateAction& action) = 0;

    virtual void Find(
        const TString& collectionName,
        const TFindAction& action,
        TFindResults& result) = 0;

    virtual void FindOne(
            const TString &collectionName,
            const TFindAction &action,
            NAnyValue::TScalarMap &result) = 0;

    class IFuture{
    public:
        virtual TFindResults Get(TCont*) = 0;
        virtual ~IFuture() = default;
    };

    virtual THolder<IFuture> FindNonblock(
            TInstant deadline,
            const TString& collectionName,
            const TFindAction& action) = 0;

    virtual void Connect(const TString& uri) = 0;
    virtual void Connect(const NConfig::TConfig & config) = 0;

    virtual ~TStorageBase() = default;;
};

