#pragma once

#include <algorithm>
#include <util/generic/yexception.h>

template<typename Function, typename Iterator, typename ... IteratorTypes>
inline void simultaneous_for_each(Function && f, Iterator begin, Iterator end, IteratorTypes ... other) {
    for (; begin != end; ++begin) {
        f(*begin, *other++ ...);
    }
}

template<typename Function, typename Container, typename ... ContainerTypes>
inline void simultaneous_for_each_container(Function&& f, Container && first, ContainerTypes&& ... other) {
    return simultaneous_for_each(std::forward<Function>(f), first.begin(), first.end(), other.begin() ...);
}

inline void check_containers_size(size_t) { }

template<typename T, typename ... ContainerTypes>
inline void check_containers_size(size_t size, T && v, ContainerTypes && ... other) {
    Y_ENSURE(size == v.size());
    check_containers_size(size, std::forward<ContainerTypes>(other) ...);
}

template<typename T, typename ... ContainerTypes>
inline void check_containers_size(T && v, ContainerTypes && ... other) {
    check_containers_size(v.size(), std::forward<ContainerTypes>(other) ...);
}

template<typename Function, typename ... ContainerTypes>
inline void simultaneous_for_each_container_with_check(Function&& f, ContainerTypes&& ... containers) {
    check_containers_size(containers ...);
    return simultaneous_for_each_container(std::forward<Function>(f), std::forward<ContainerTypes>(containers) ...);
}

template<class ForwardIt, class InputIt>
ForwardIt set_difference_in_place(ForwardIt first1, ForwardIt last1, InputIt first2, InputIt last2) {
    while (first1 != last1 && first2 != last2) {
        if (*first1 < *first2) {
            ++first1;
        }
        else {
            if (!(*first2 < *first1)) {
                auto output = first1++; ++first2;
                return std::set_difference(std::make_move_iterator(first1), std::make_move_iterator(last1), first2, last2, output);
            }
            ++first2;
        }
    }
    return last1;
}

template<class Container1, class Container2>
void set_difference_in_place_container(Container1& base, const Container2& v) {
    auto it = set_difference_in_place(base.begin(), base.end(), v.cbegin(), v.cend());
    base.erase(it, base.end());
}
