#pragma once

#include <util/generic/string.h>
#include <util/generic/vector.h>
#include <util/generic/map.h>
#include <library/cpp/cgiparam/cgiparam.h>
#include <library/cpp/string_utils/quote/quote.h>

#include "kfunc.h"

namespace nosql {
    class AnyValue;
    typedef TMap<TString, AnyValue> HashMap;

    class AnyValue {
    public:
        enum TYPE { NOTYPE,
                    INTEGER,
                    INTEGER64,
                    DOUBLE,
                    VECTOR,
                    STRING,
                    LIST,
                    HASH };

        AnyValue();
        AnyValue(double value);
        AnyValue(int value);
        AnyValue(ui32 value);
        AnyValue(i64 value);
        AnyValue(const TVector<char>& value);
        AnyValue(const TVector<AnyValue>& value);
        AnyValue(const HashMap& value);
        AnyValue(const TString& value);
        AnyValue(const char* value);

        AnyValue& operator=(double value);
        AnyValue& operator=(int value);
        AnyValue& operator=(ui32 value);
        AnyValue& operator=(i64 value);
        AnyValue& operator=(const TVector<char>& value);
        AnyValue& operator=(const TVector<AnyValue>& value);
        AnyValue& operator=(const HashMap& value);
        AnyValue& operator=(const TString& value);
        AnyValue& operator=(const char* value);

        bool operator==(const AnyValue& obj) const;

        double Double() const;
        ui32 Integer() const;
        i64 Long() const;
        const TVector<char>& Vector() const;
        const TVector<AnyValue>& List() const;
        const HashMap& Hash() const;
        const TString& String() const;

        TYPE Type() const;
        void Clear();

    private:
        double m_double;
        i64 m_int64;
        TVector<char> m_vector;
        TVector<AnyValue> m_list;
        HashMap m_hash;
        TString m_string;

        TYPE m_type;
    };

    struct TDataCounters {
        ui64 count_by_type[8];
        ui64 empty_data;

        TDataCounters();
        ~TDataCounters();

        void Clear();
        TString GetCountersByType();
    };

    TString AnyValueByTypeToStroka(HashMap::const_iterator& hit, TDataCounters& counters);
    TString HashMapToStroka(HashMap& hash, TDataCounters& counters, TString& id);

    TString HashMapToStrokaBase(const HashMap& hash);
    bool pStrokaToHashMapBase(const char* pdatastr, size_t pdatastrlen, nosql::HashMap& hash, TString& err_str);
    bool StrokaToHashMapBase(const TString& datastr, nosql::HashMap& hash, TString& err_str);
}
