#pragma once

#include <util/generic/ptr.h>
#include <util/generic/vector.h>
#include <util/generic/string.h>
#include <util/datetime/base.h>
#include <mail/so/libs/pool/pool.h>

class TCont;
struct ares_channeldata;
typedef struct ares_channeldata *ares_channel;

namespace NAres {
    struct TAresInit {
        TAresInit();
    };

    class TAres : TAresInit {
    public:
        TAres();
        TAres(const TDuration& timeout, size_t tries);
        TAres(const TDuration& timeout, size_t tries, const TString& server, ui16 port);

        TVector<TString> Resolve(const TString& host, const TInstant& deadline = TInstant::Max(), TCont* cont = nullptr);
        TVector<TVector<TString>> Resolve(const TVector<TString>& hosts, const TInstant& deadline = TInstant::Max(), TCont* cont = nullptr);

    private:
        struct TDestroyer { static void Destroy(ares_channel c); };
        THolder<ares_channeldata, TDestroyer> context;
    };

    using TPool = ::TPool<TAres>;
    using TPoolItemHolder = TPool::TItemHolder;

    class TPoolTraits : public TPool::TPoolItemTraits {
    public:
        THolder<TAres> create() const override;

        TPoolTraits();
        TPoolTraits(const TDuration& timeout, size_t tries);
        TPoolTraits(const TDuration& timeout, size_t tries, const TString& server, ui16 port);
        TPoolTraits(const TDuration& timeout, size_t tries, const TStringBuf& serverPort);
        TPoolTraits(TPoolTraits&&) noexcept = default;
        ~TPoolTraits() override = default;
    private:
        TDuration timeout;
        size_t tries;
        TString server;
        ui16 port;
        size_t h;
    };
}   //  namespace NCurl
