#pragma once

#include <util/generic/list.h>
#include <util/generic/string.h>

struct TCritRule
{
   TString RULENAME;
   ui16    Criterion{};
   ui16    Hour{};

   TCritRule(TString rulename, ui16 criterion, ui16 hour) : RULENAME(std::move(rulename)), Criterion(criterion), Hour(hour) {}
};

typedef TList<TCritRule>              TCritRuleList;
typedef TCritRuleList::iterator           TCritRuleListIt;
typedef TCritRuleList::reverse_iterator   TCritRuleListRIt;

