#include "exp_boxes.h"
#include <util/string/strip.h>
#include <util/string/split.h>

TExpBoxes::TExpBoxes(const std::string_view& rawExpBoxes)
: RawExpBoxes(StripString(rawExpBoxes)) {
    for(auto rawTriple : StringSplitter(RawExpBoxes).Split(';')) {
        uint64_t experimentId;
        int32_t unusedSlot;
        int32_t bucket;

        Split(rawTriple.Token(), ',', experimentId, unusedSlot, bucket);

        Experiments.emplace_back(TExperiment{experimentId, bucket});
    }
}
