#ifdef WIN32

#include <fcntl.h>
#include <stdio.h>
#include <string.h>
#include "find_files.h"


//-----------------------------------------------------------------------------
// Fnc: FindFiles::FindFirst
// For: Find first file by specified mask
// Get: mask - mask for files to search
// Ret: CERR_OK, if file was found
//-----------------------------------------------------------------------------
int FindFiles::FindFirst (char *mask)
    {
    int err = -1;

    if ((hFile = _findfirst (mask, &ffStruc)) != -1L)
        {
        ff.Attrib = ffStruc.attrib;
        ff.Size = ffStruc.size;
        strcpy (ff.Name, ffStruc.name);
        struct tm *pTm = localtime (&(ffStruc.time_write));
        if (pTm == NULL)
          {
          return -1;
          }
        ff.Time = *pTm;
        ff.Time.tm_mon++;
        ff.Time.tm_year += 1900;
        err = CERR_OK;
        }
    return err;
    }
int FindFiles::FindFileNext (void)
{
    int err = -1;
    while (((err = FindNext()) == CERR_OK) && ffStruc.attrib == 0x10);
    return err;
}
//-----------------------------------------------------------------------------
// Fnc: FindNext
// For: Find next file by early specified mask
// Get: None
// Ret: CERR_OK, if file was found
//-----------------------------------------------------------------------------
int FindFiles::FindNext (void)
    {
    int err = -1;

    if (_findnext (hFile, &ffStruc) == 0)
        {
        ff.Attrib = ffStruc.attrib;
        ff.Size = ffStruc.size;
        strcpy (ff.Name, ffStruc.name);
        struct tm *pTm = localtime (&(ffStruc.time_write));
        if (pTm == NULL)
          {
          return -1;
          }
        ff.Time = *pTm;
//        ff.Time = *localtime (&(ffStruc.time_write));
        ff.Time.tm_mon++;
        ff.Time.tm_year += 1900;
        err = CERR_OK;
        }
    return err;
    }


//-----------------------------------------------------------------------------
// Fnc: FindClose
// For: Close opened handles, used by Windows
// Get: None
// Ret: CERR_OK, if file was found
//-----------------------------------------------------------------------------
void FindFiles::FindClose (void)
    {
    if (hFile != -1)
        {
        _findclose (hFile);
        hFile = -1;
        }
    }

#endif // WIN32
