#include <util/system/yassert.h>
#include <util/generic/string.h>
#include <util/generic/hash.h>
#include <util/generic/singleton.h>
#include <util/datetime/systime.h>

#include "get_zone_time.h"


namespace {
    struct TNameAndOffset {
        const char* name;
        int offset;
    };

    TNameAndOffset tz_offsets[] = {
#include "timezone_offsets.inc"
    };

    struct TTzOffsetsHolder {
        TTzOffsetsHolder() {
            FillGeoOffsets();
            FillTzOffsets();
            FillCountryOffsets();
        }

        void FillCountryOffsets() {
            geo_offsets["AB Abkhasia"] = 4 * 3600;
            geo_offsets["AZ Shamkir Rayon"] = 4 * 3600;
            geo_offsets["AZ Zardab Rayon"] = 4 * 3600;
            geo_offsets["Africa"] = 7200;
            geo_offsets["Antilles"] = -5 * 3600;
            geo_offsets["Asia"] = 8 * 3600;
            geo_offsets["KZ Kazakhstan"] = 6 * 3600;
            geo_offsets["RU Far East"] = 8 * 3600;
            geo_offsets["RU North Kavkaz"] = 4 * 3600;
            geo_offsets["RU Northwest"] = 3 * 3600;
            geo_offsets["RU Russia"] = 6 * 3600;
            geo_offsets["RU Siberian"] = 8 * 3600;
            geo_offsets["RU Volga Region"] = 4 * 3600;
        }

        void FillTzOffsets() {
            geo_offsets["Africa/Abidjan"] = 0;
            geo_offsets["Africa/Accra"] = 0;
            geo_offsets["Africa/Addis_Ababa"] = 10800;
            geo_offsets["Africa/Algiers"] = 3600;
            geo_offsets["Africa/Asmera"] = 10800;
            geo_offsets["Africa/Bamako"] = 0;
            geo_offsets["Africa/Bangui"] = 3600;
            geo_offsets["Africa/Banjul"] = 0;
            geo_offsets["Africa/Bissau"] = 0;
            geo_offsets["Africa/Brazzaville"] = 3600;
            geo_offsets["Africa/Bujumbura"] = 7200;
            geo_offsets["Africa/Cairo"] = 7200;
            geo_offsets["Africa/Casablanca"] = 0;
            geo_offsets["Africa/Conakry"] = 0;
            geo_offsets["Africa/Dakar"] = 0;
            geo_offsets["Africa/Dar_es_Salaam"] = 10800;
            geo_offsets["Africa/Djibouti"] = 10800;
            geo_offsets["Africa/Douala"] = 3600;
            geo_offsets["Africa/El_Aaiun"] = 0;
            geo_offsets["Africa/Freetown"] = 0;
            geo_offsets["Africa/Gaborone"] = 7200;
            geo_offsets["Africa/Harare"] = 7200;
            geo_offsets["Africa/Johannesburg"] = 7200;
            geo_offsets["Africa/Kampala"] = 10800;
            geo_offsets["Africa/Khartoum"] = 10800;
            geo_offsets["Africa/Kigali"] = 7200;
            geo_offsets["Africa/Kinshasa"] = 3600;
            geo_offsets["Africa/Lagos"] = 3600;
            geo_offsets["Africa/Libreville"] = 3600;
            geo_offsets["Africa/Lome"] = 0;
            geo_offsets["Africa/Lusaka"] = 7200;
            geo_offsets["Africa/Malabo"] = 3600;
            geo_offsets["Africa/Maputo"] = 7200;
            geo_offsets["Africa/Maseru"] = 7200;
            geo_offsets["Africa/Mbabane"] = 7200;
            geo_offsets["Africa/Mogadishu"] = 10800;
            geo_offsets["Africa/Monrovia"] = 0;
            geo_offsets["Africa/Nairobi"] = 10800;
            geo_offsets["Africa/Ndjamena"] = 3600;
            geo_offsets["Africa/Niamey"] = 3600;
            geo_offsets["Africa/Nouakchott"] = 0;
            geo_offsets["Africa/Porto-Novo"] = 3600;
            geo_offsets["Africa/Sao_Tome"] = 0;
            geo_offsets["Africa/Tripoli"] = 7200;
            geo_offsets["Africa/Tunis"] = 3600;
            geo_offsets["Africa/Windhoek"] = 7200;
            geo_offsets["America/Anchorage"] = -28800;
            geo_offsets["America/Anguilla"] = -14400;
            geo_offsets["America/Antigua"] = -14400;
            geo_offsets["America/Argentina/Buenos_Aires"] = -10800;
            geo_offsets["America/Aruba"] = -14400;
            geo_offsets["America/Asuncion"] = -10800;
            geo_offsets["America/Atikokan"] = -18000;
            geo_offsets["America/Barbados"] = -14400;
            geo_offsets["America/Belem"] = -10800;
            geo_offsets["America/Belize"] = -21600;
            geo_offsets["America/Bogota"] = -18000;
            geo_offsets["America/Boise"] = -21600;
            geo_offsets["America/Campo_Grande"] = -14400;
            geo_offsets["America/Cancun"] = -21600;
            geo_offsets["America/Caracas"] = -16200;
            geo_offsets["America/Cayenne"] = -10800;
            geo_offsets["America/Cayman"] = -18000;
            geo_offsets["America/Chicago"] = -18000;
            geo_offsets["America/Chihuahua"] = -25200;
            geo_offsets["America/Costa_Rica"] = -21600;
            geo_offsets["America/Cuiaba"] = -14400;
            geo_offsets["America/Curacao"] = -14400;
            geo_offsets["America/Dawson"] = -25200;
            geo_offsets["America/Dawson_Creek"] = -25200;
            geo_offsets["America/Denver"] = -21600;
            geo_offsets["America/Detroit"] = -14400;
            geo_offsets["America/Dominica"] = -14400;
            geo_offsets["America/Edmonton"] = -21600;
            geo_offsets["America/Fortaleza"] = -10800;
            geo_offsets["America/Glace_Bay"] = -10800;
            geo_offsets["America/Godthab"] = -10800;
            geo_offsets["America/Goose_Bay"] = -10800;
            geo_offsets["America/Grand_Turk"] = -14400;
            geo_offsets["America/Grenada"] = -14400;
            geo_offsets["America/Guatemala"] = -21600;
            geo_offsets["America/Guyana"] = -14400;
            geo_offsets["America/Halifax"] = -10800;
            geo_offsets["America/Havana"] = -14400;
            geo_offsets["America/Hermosillo"] = -25200;
            geo_offsets["America/Indiana/Knox"] = -18000;
            geo_offsets["America/Indiana/Marengo"] = -14400;
            geo_offsets["America/Indianapolis"] = -14400;
            geo_offsets["America/Indiana/Vevay"] = -14400;
            geo_offsets["America/Iqaluit"] = -14400;
            geo_offsets["America/Jamaica"] = -18000;
            geo_offsets["America/Juneau"] = -28800;
            geo_offsets["America/Kentucky/Monticello"] = -14400;
            geo_offsets["America/La_Paz"] = -14400;
            geo_offsets["America/Lima"] = -18000;
            geo_offsets["America/Los_Angeles"] = -25200;
            geo_offsets["America/Louisville"] = -14400;
            geo_offsets["America/Maceio"] = -10800;
            geo_offsets["America/Managua"] = -21600;
            geo_offsets["America/Manaus"] = -14400;
            geo_offsets["America/Menominee"] = -18000;
            geo_offsets["America/Mexico_City"] = -21600;
            geo_offsets["America/Miquelon"] = -7200;
            geo_offsets["America/Monterrey"] = -21600;
            geo_offsets["America/Montevideo"] = -10800;
            geo_offsets["America/Montreal"] = -14400;
            geo_offsets["America/Montserrat"] = -14400;
            geo_offsets["America/Nassau"] = -14400;
            geo_offsets["America/New_York"] = -14400;
            geo_offsets["America/North_Dakota/Center"] = -18000;
            geo_offsets["America/Phoenix"] = -25200;
            geo_offsets["America/Port-au-Prince"] = -14400;
            geo_offsets["America/Port_of_Spain"] = -14400;
            geo_offsets["America/Porto_Velho"] = -14400;
            geo_offsets["America/Puerto_Rico"] = -14400;
            geo_offsets["America/Rankin_Inlet"] = -18000;
            geo_offsets["America/Recife"] = -10800;
            geo_offsets["America/Regina"] = -21600;
            geo_offsets["America/Santiago"] = -10800;
            geo_offsets["America/Santo_Domingo"] = -14400;
            geo_offsets["America/Sao_Paulo"] = -10800;
            geo_offsets["America/St_Johns"] = -9000;
            geo_offsets["America/St_Kitts"] = -14400;
            geo_offsets["America/St_Thomas"] = -14400;
            geo_offsets["America/St_Vincent"] = -14400;
            geo_offsets["America/Swift_Current"] = -21600;
            geo_offsets["America/Tegucigalpa"] = -21600;
            geo_offsets["America/Thunder_Bay"] = -14400;
            geo_offsets["America/Tijuana"] = -25200;
            geo_offsets["America/Toronto"] = -14400;
            geo_offsets["America/Tortola"] = -14400;
            geo_offsets["America/Vancouver"] = -25200;
            geo_offsets["America/Whitehorse"] = -25200;
            geo_offsets["America/Winnipeg"] = -18000;
            geo_offsets["America/Yellowknife"] = -21600;
            geo_offsets["Antarctica/South_Pole"] = 46800;
            geo_offsets["Asia/Aden"] = 10800;
            geo_offsets["Asia/Almaty"] = 21600;
            geo_offsets["Asia/Amman"] = 10800;
            geo_offsets["Asia/Aqtau"] = 18000;
            geo_offsets["Asia/Aqtobe"] = 18000;
            geo_offsets["Asia/Ashgabat"] = 18000;
            geo_offsets["Asia/Baghdad"] = 10800;
            geo_offsets["Asia/Bahrain"] = 10800;
            geo_offsets["Asia/Baku"] = 14400;
            geo_offsets["Asia/Bangkok"] = 25200;
            geo_offsets["Asia/Beirut"] = 7200;
            geo_offsets["Asia/Bishkek"] = 21600;
            geo_offsets["Asia/Brunei"] = 28800;
            geo_offsets["Asia/Colombo"] = 19800;
            geo_offsets["Asia/Damascus"] = 7200;
            geo_offsets["Asia/Dhaka"] = 21600;
            geo_offsets["Asia/Dili"] = 32400;
            geo_offsets["Asia/Dubai"] = 14400;
            geo_offsets["Asia/Dushanbe"] = 18000;
            geo_offsets["Asia/Gaza"] = 7200;
            geo_offsets["Asia/Harbin"] = 28800;
            geo_offsets["Asia/Irkutsk"] = 32400;
            geo_offsets["Asia/Jakarta"] = 25200;
            geo_offsets["Asia/Jayapura"] = 32400;
            geo_offsets["Asia/Jerusalem"] = 7200;
            geo_offsets["Asia/Kabul"] = 16200;
            geo_offsets["Asia/Kamchatka"] = 43200;
            geo_offsets["Asia/Karachi"] = 18000;
            geo_offsets["Asia/Kathmandu"] = 20700;
            geo_offsets["Asia/Kolkata"] = 19800;
            geo_offsets["Asia/Krasnoyarsk"] = 28800;
            geo_offsets["Asia/Kuala_Lumpur"] = 28800;
            geo_offsets["Asia/Kuwait"] = 10800;
            geo_offsets["Asia/Macau"] = 28800;
            geo_offsets["Asia/Magadan"] = 43200;
            geo_offsets["Asia/Makassar"] = 28800;
            geo_offsets["Asia/Manila"] = 28800;
            geo_offsets["Asia/Muscat"] = 14400;
            geo_offsets["Asia/Nicosia"] = 7200;
            geo_offsets["Asia/Novosibirsk"] = 25200;
            geo_offsets["Asia/Omsk"] = 25200;
            geo_offsets["Asia/Phnom_Penh"] = 25200;
            geo_offsets["Asia/Pyongyang"] = 32400;
            geo_offsets["Asia/Rangoon"] = 23400;
            geo_offsets["Asia/Riyadh"] = 10800;
            geo_offsets["Asia/Sakhalin"] = 39600;
            geo_offsets["Asia/Seoul"] = 32400;
            geo_offsets["Asia/Shanghai"] = 28800;
            geo_offsets["Asia/Singapore"] = 28800;
            geo_offsets["Asia/Taipei"] = 28800;
            geo_offsets["Asia/Tashkent"] = 18000;
            geo_offsets["Asia/Tbilisi"] = 14400;
            geo_offsets["Asia/Tehran"] = 12600;
            geo_offsets["Asia/Thimphu"] = 21600;
            geo_offsets["Asia/Tokyo"] = 32400;
            geo_offsets["Asia/Ulaanbaatar"] = 28800;
            geo_offsets["Asia/Urumqi"] = 28800;
            geo_offsets["Asia/Vientiane"] = 25200;
            geo_offsets["Asia/Vladivostok"] = 39600;
            geo_offsets["Asia/Yakutsk"] = 36000;
            geo_offsets["Asia/Yekaterinburg"] = 21600;
            geo_offsets["Asia/Yerevan"] = 14400;
            geo_offsets["Atlantic/Azores"] = -3600;
            geo_offsets["Atlantic/Bermuda"] = -10800;
            geo_offsets["Atlantic/Canary"] = 0;
            geo_offsets["Atlantic/Cape_Verde"] = -3600;
            geo_offsets["Atlantic/Faeroe"] = 0;
            geo_offsets["Atlantic/Reykjavik"] = 0;
            geo_offsets["Australia/Adelaide"] = 37800;
            geo_offsets["Australia/Brisbane"] = 36000;
            geo_offsets["Australia/Broken_Hill"] = 37800;
            geo_offsets["Australia/Darwin"] = 34200;
            geo_offsets["Australia/Hobart"] = 39600;
            geo_offsets["Australia/Melbourne"] = 39600;
            geo_offsets["Australia/Perth"] = 28800;
            geo_offsets["Australia/Sydney"] = 39600;
            geo_offsets["Europe/Amsterdam"] = 3600;
            geo_offsets["Europe/Andorra"] = 3600;
            geo_offsets["Europe/Athens"] = 7200;
            geo_offsets["Europe/Belgrade"] = 3600;
            geo_offsets["Europe/Berlin"] = 3600;
            geo_offsets["Europe/Bratislava"] = 3600;
            geo_offsets["Europe/Brussels"] = 3600;
            geo_offsets["Europe/Bucharest"] = 7200;
            geo_offsets["Europe/Budapest"] = 3600;
            geo_offsets["Europe/Copenhagen"] = 3600;
            geo_offsets["Europe/Dublin"] = 0;
            geo_offsets["Europe/Gibraltar"] = 3600;
            geo_offsets["Europe/Helsinki"] = 7200;
            geo_offsets["Europe/Kaliningrad"] = 10800;
            geo_offsets["Europe/Kiev"] = 7200;
            geo_offsets["Europe/Lisbon"] = 0;
            geo_offsets["Europe/Ljubljana"] = 3600;
            geo_offsets["Europe/London"] = 0;
            geo_offsets["Europe/Luxembourg"] = 3600;
            geo_offsets["Europe/Madrid"] = 3600;
            geo_offsets["Europe/Malta"] = 3600;
            geo_offsets["Europe/Minsk"] = 10800;
            geo_offsets["Europe/Monaco"] = 3600;
            geo_offsets["Europe/Moscow"] = 14400;
            geo_offsets["Europe/Oslo"] = 3600;
            geo_offsets["Europe/Paris"] = 3600;
            geo_offsets["Europe/Prague"] = 3600;
            geo_offsets["Europe/Riga"] = 7200;
            geo_offsets["Europe/Rome"] = 3600;
            geo_offsets["Europe/Samara"] = 14400;
            geo_offsets["Europe/San_Marino"] = 3600;
            geo_offsets["Europe/Sarajevo"] = 3600;
            geo_offsets["Europe/Skopje"] = 3600;
            geo_offsets["Europe/Sofia"] = 7200;
            geo_offsets["Europe/Stockholm"] = 3600;
            geo_offsets["Europe/Tallinn"] = 7200;
            geo_offsets["Europe/Tirane"] = 3600;
            geo_offsets["Europe/Vaduz"] = 3600;
            geo_offsets["Europe/Vatican"] = 3600;
            geo_offsets["Europe/Vienna"] = 3600;
            geo_offsets["Europe/Vilnius"] = 7200;
            geo_offsets["Europe/Warsaw"] = 3600;
            geo_offsets["Europe/Zagreb"] = 3600;
            geo_offsets["Europe/Zurich"] = 3600;
            geo_offsets["Indian/Antananarivo"] = 10800;
            geo_offsets["Indian/Cocos"] = 23400;
            geo_offsets["Indian/Comoro"] = 10800;
            geo_offsets["Indian/Maldives"] = 18000;
            geo_offsets["Indian/Mauritius"] = 14400;
            geo_offsets["Pacific/Apia"] = 50400;
            geo_offsets["Pacific/Auckland"] = 46800;
            geo_offsets["Pacific/Easter"] = -18000;
            geo_offsets["Pacific/Efate"] = 39600;
            geo_offsets["Pacific/Fiji"] = 43200;
            geo_offsets["Pacific/Funafuti"] = 43200;
            geo_offsets["Pacific/Guam"] = 36000;
            geo_offsets["Pacific/Honolulu"] = -36000;
            geo_offsets["Pacific/Majuro"] = 43200;
            geo_offsets["Pacific/Nauru"] = 43200;
            geo_offsets["Pacific/Niue"] = -39600;
            geo_offsets["Pacific/Norfolk"] = 41400;
            geo_offsets["Pacific/Noumea"] = 39600;
            geo_offsets["Pacific/Palau"] = 32400;
            geo_offsets["Pacific/Port_Moresby"] = 36000;
            geo_offsets["Pacific/Rarotonga"] = -36000;
            geo_offsets["Pacific/Tahiti"] = -36000;
            geo_offsets["Pacific/Tongatapu"] = 46800;
            geo_offsets["Pacific/Yap"] = 36000;
        }

        void FillGeoOffsets() {
            for (size_t i = 0; i < (sizeof(tz_offsets) / sizeof(TNameAndOffset)); ++i) {
                geo_offsets[tz_offsets[i].name] = tz_offsets[i].offset;
            }
        }

        THashMap<TString, int> geo_offsets;
    };
}

bool GetZoneTime(const TString& zone_name, time_t clock, TString* result, const char* format) {
    assert(result);
    tm time;
    bool success = GetZoneTm(zone_name, clock, &time);
    char time_str[512];
    strftime(time_str, sizeof(time_str), format, &time);
    result->assign(time_str);
    return success;
}

bool GetZoneTm(const TString& zone_name, time_t clock, tm* time) {
    assert(time);
    const THashMap<TString, int>& geo_offsets = Singleton<TTzOffsetsHolder>()->geo_offsets;
    THashMap<TString, int>::const_iterator it = geo_offsets.find(zone_name);
    bool success = (it != geo_offsets.end());
    int offset = (success ? it->second : 0);
    clock += offset;
    gmtime_r(&clock, time);
    return success;
}

TString NormalizeZoneName(const TString& zone_name) {
    TString res = "";
    res = Trim(zone_name);
    return res;
}

bool GetZoneTimeN(const TString& zone_name, time_t clock, TString* result, const char* format) {
    return GetZoneTime(NormalizeZoneName(zone_name), clock, result, format);
}

bool GetZoneTmN(const TString& zone_name, time_t clock, tm* time) {
    return GetZoneTm(NormalizeZoneName(zone_name), clock, time);
}

int GetTimeDiff(const TString& zone1, const TString& zone2) {
    const THashMap<TString, int>& geo_offsets = Singleton<TTzOffsetsHolder>()->geo_offsets;
    THashMap<TString, int>::const_iterator it_1 = geo_offsets.find(NormalizeZoneName(zone1));
    THashMap<TString, int>::const_iterator it_2 = geo_offsets.find(NormalizeZoneName(zone2));
    bool success = ((it_1 != geo_offsets.end()) && (it_2 != geo_offsets.end()));
    int time_diff = -1;
    if (success) {
        time_diff = abs(it_2->second - it_1->second);
    }
    return time_diff;
}

bool IsNight(const TString& zone_name, time_t clock) {
    bool res = false;
    tm t;

    if (GetZoneTmN(zone_name, clock, &t)) {
        if ((t.tm_hour >= 23) || (t.tm_hour <= 7))
            res = true;
    }

    return res;
}
