#pragma once

#include <util/generic/string.h>
#include <util/datetime/systime.h>

#include "kfunc.h"

bool GetZoneTimeN(const TString& zone_name, time_t clock, TString* result, const char* format = "%Y-%m-%d %H:%M:%S");
bool GetZoneTmN(const TString& zone_name, time_t clock, tm* result);

bool GetZoneTime(const TString& zone_name, time_t clock, TString* result, const char* format = "%Y-%m-%d %H:%M:%S");
bool GetZoneTm(const TString& zone_name, time_t clock, tm* result);

//returns time diff in seconds, -1 if one of zones is not found
int GetTimeDiff(const TString& zone1, const TString& zone2);

bool IsNight(const TString& zone_name, time_t clock);
