#pragma once

#include <util/generic/string.h>

#include <string>
#include <sys/types.h>
#ifdef _MSC_VER
#include <winsock2.h>
#include <ws2tcpip.h>
#else
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#endif

class TIpAddr;
class TKIPv6;

class TIpAddr {
public:
    static bool BelongsToNetWithMask(const TIpAddr& addr, const TIpAddr& net, size_t maskSize);

    bool operator==(const TIpAddr& addr) const;
    bool operator!=(const TIpAddr& addr) const;
    TIpAddr operator&(const TIpAddr& addr) const;
    TIpAddr& operator&=(const TIpAddr& addr);
    TIpAddr operator|(const TIpAddr& addr) const;
    TIpAddr& operator|=(const TIpAddr& addr);

    TString ToString() const;
    TString ToDNSBLString() const;
    TKIPv6 ToTKIPv6() const;
    TString GetSourceString() const;
    void FromString(const TString& str);
    void MakeMask(int len, bool is_ipv6);
    bool IsIpv6() const;
    bool IsValid() const;
    const sockaddr* GetAddr() const;
    size_t GetAddrSize() const;
    const in6_addr* GetIn6Addr() const;
    const in_addr* GetInAddr() const;

    TIpAddr(const TString& str);
    TIpAddr();
    ~TIpAddr();

private:
    bool is_valid;
    bool is_ipv6;
    socklen_t socklen;
    sockaddr_storage addr_storage;
    TString sSourceString;
};
