#pragma once

#include <library/cpp/json/json_writer.h>

struct TEndObject {
};

#define PRINT_JSON_HELPER(type, func) \
    inline NJsonWriter::TBuf& PrintJson(const type &value, NJsonWriter::TBuf &json) { \
        json.func(value);  \
        return json;    \
    }

PRINT_JSON_HELPER(ui64, WriteULongLong)

PRINT_JSON_HELPER(ui32, WriteULongLong)

PRINT_JSON_HELPER(i32, WriteInt)

PRINT_JSON_HELPER(ui8, WriteInt)

PRINT_JSON_HELPER(float, WriteFloat)

PRINT_JSON_HELPER(TString, WriteString)

PRINT_JSON_HELPER(TStringBuf, WriteString)

inline NJsonWriter::TBuf &PrintJson(TEndObject, NJsonWriter::TBuf &json) {
    return json.EndObject();
}

template<template<class...> class TContainer, class ...TArgs>
decltype(auto) PrintJson(const TContainer<TArgs...> &container, NJsonWriter::TBuf &json) {
    json.BeginList();
    for (const auto &v: container) {
        PrintJson(v, json);
    }
    json.EndList();
    return json;
}

template<class ...T>
decltype(auto) operator<<(NJsonWriter::TBuf &json, T &&...args) {
    return PrintJson(std::forward<T>(args)..., json);
}

#undef PRINT_JSON_HELPER

template<template<class ... TArgs> class T, class ... TArgs>
NJson::TJsonValue Vec2Json(const T<TArgs...>& vec) {
    NJson::TJsonValue json;
    for(const auto& val : vec) {
        json.AppendValue(val);
    }
    return json;
}

template<template<class ... TArgs> class T, class ... TArgs>
NJson::TJsonValue Map2Json(const T<TArgs...>& vec) {
    NJson::TJsonValue json;
    for(const auto& [key, value] : vec) {
        json[key] = value;
    }
    return json;
}
