#include "kfunc.h"

#include <util/folder/dirut.h>
#include <util/string/reverse.h>
#include <util/string/strip.h>

#include <library/cpp/charset/codepage.h>
#include <library/cpp/charset/recyr.hh>
#include <util/string/printf.h>
#include <util/stream/str.h>
#include <util/string/split.h>

void to_lower_k(TString& value) {
    if (!value.empty())
        ToLower(value.begin(), value.size(), *CodePageByCharset(CODES_WIN));
}
void to_upper_k(TString& value) {
    if (!value.empty())
        ToUpper(value.begin(), value.size(), *CodePageByCharset(CODES_WIN));
}

TString IntToStroka(int value) {
    TString res = "";
    char BUFF[25];

    memset(BUFF, 0, sizeof(BUFF));
    snprintf(BUFF, sizeof(BUFF) - 1, "%u", value);
    res.assign(BUFF);

    return res;
}

TString IntToStrokaDash(int value) {
    TString res = "";
    char BUFF[25];

    if (value < 0) {
        res = "-";
    } else {
        memset(BUFF, 0, sizeof(BUFF));
        snprintf(BUFF, sizeof(BUFF) - 1, "%d", value);
        res.assign(BUFF);
    }

    return res;
}

TString IntToStrokaDash2(int value) {
    TString res = "";
    char BUFF[25];

    if (value <= 0) {
        res = "-";
    } else {
        memset(BUFF, 0, sizeof(BUFF));
        snprintf(BUFF, sizeof(BUFF) - 1, "%d", value);
        res.assign(BUFF);
    }

    return res;
}

TString IntToStrokaLimited(int value) {
    TString res = "";
    char BUFF[25];

    if (value == 0)
        res = "unlimited";
    else {
        memset(BUFF, 0, sizeof(BUFF));
        snprintf(BUFF, sizeof(BUFF) - 1, "%u", value);
        res.assign(BUFF);
    }

    return res;
}

TString IntToStrokaWithProbel(int value, size_t ProbelCount) {
    TString mask = "% " + IntToStroka(ProbelCount) + "u";
    return Sprintf(mask.c_str(), value);
}

TString IntToStrokaS(int value) {
    TString res = "";
    char BUFF[25];

    memset(BUFF, 0, sizeof(BUFF));
    snprintf(BUFF, sizeof(BUFF) - 1, "%d", value);
    res.assign(BUFF);

    return res;
}

TString IntToStroka2(int value) {
    TString res = "";
    char BUFF[25];

    memset(BUFF, 0, sizeof(BUFF));
    snprintf(BUFF, sizeof(BUFF) - 1, "%02u", value);
    res.assign(BUFF);

    return res;
}

//TString IntToStroka2o(int value) {
//    TString res;
//    char BUFF[25];
//
//    memset(BUFF, 0, sizeof(BUFF));
//    snprintf(BUFF, sizeof(BUFF) - 1, "% 2u", value);
//    res.assign(BUFF);
//
//    return res;
//}

TString IntToStroka3(int value) {
    TString res = "";
    char BUFF[25];

    memset(BUFF, 0, sizeof(BUFF));
    snprintf(BUFF, sizeof(BUFF) - 1, "%03u", value);
    res.assign(BUFF);

    return res;
}

TString IntToStrokaNum(int value) {
    TString res = "";
    char BUFF[25];
    int n2 = 0, n3 = sizeof(BUFF);
    int in = 0;

    memset(BUFF, 0, sizeof(BUFF));
    snprintf(BUFF, sizeof(BUFF) - 1, "%u", value);
    res.assign(BUFF);
    n2 = (int)res.length() % 3;
    memset(BUFF, 0, sizeof(BUFF));
    in = 0;
    for (unsigned int i = 0; i < res.length(); i++) {
        if (in >= n3)
            break;
        if (n2 > 0) {
            BUFF[in] = res[i];
            in++;
            n2--;
        } else {
            BUFF[in] = ' ';
            in++;
            if (in < n3) {
                BUFF[in] = res[i];
                in++;
            }
            n2 = 2;
        }
    }
    res = TString(BUFF);

    return res;
}

TString IntToStroka4D(int value) {
    TString res = "";
    char BUFF[25];

    memset(BUFF, 0, sizeof(BUFF));
    snprintf(BUFF, sizeof(BUFF) - 1, "%4u", value);
    res.assign(BUFF);

    return res;
}

TString IntToStroka4(int value) {
    TString res = "";
    char BUFF[25];

    memset(BUFF, 0, sizeof(BUFF));
    snprintf(BUFF, sizeof(BUFF) - 1, "%7u", value);
    res.assign(BUFF);

    return res;
}

TString I64ToStroka(i64 value) {
    TString res = "";
    char BUFF[25];

    memset(BUFF, 0, sizeof(BUFF));
    snprintf(BUFF, sizeof(BUFF) - 1, "%" PRIi64, value);
    res.assign(BUFF);

    return res;
}

TString UI64ToStroka(ui64 value) {
    char BUFF[25] = {};

    snprintf(BUFF, sizeof(BUFF) - 1, "%" PRIu64, value);

    return BUFF;
}

TString UI64ToStrokaNum(ui64 value) {
    TString res = "";
    char BUFF[64];
    int n2 = 0, n3 = sizeof(BUFF);
    int in = 0;

    memset(BUFF, 0, sizeof(BUFF));
    snprintf(BUFF, sizeof(BUFF) - 1, "%" PRIu64, value);
    res.assign(BUFF);

    n2 = (int)res.length() % 3;
    memset(BUFF, 0, sizeof(BUFF));
    in = 0;
    for (unsigned int i = 0; i < res.length(); i++) {
        if (in >= n3)
            break;
        if (n2 > 0) {
            BUFF[in] = res[i];
            in++;
            n2--;
        } else {
            BUFF[in] = ' ';
            in++;
            if (in < n3) {
                BUFF[in] = res[i];
                in++;
            }
            n2 = 2;
        }
    }
    res = TString(BUFF);

    return res;
}

TString UI64ToStroka2(ui64 value) {
    TString res = "";
    char BUFF[25];

    memset(BUFF, 0, sizeof(BUFF));
    snprintf(BUFF, sizeof(BUFF) - 1, "%020" PRIu64, value);
    res.assign(BUFF);

    return res;
}

TString ShingleToStroka(ui64 value) {
    TString res = "";
    char BUFF[25];

    memset(BUFF, 0, sizeof(BUFF));
    snprintf(BUFF, sizeof(BUFF) - 1, "%016" PRIx64, value);
    res.assign(BUFF);

    return res;
}

TString ShingleToStroka24(ui64 value) {
    TString res = "";
    char BUFF[32];

    memset(BUFF, 0, sizeof(BUFF));
    snprintf(BUFF, sizeof(BUFF) - 1, "%024" PRIx64, value);
    res.assign(BUFF);

    return res;
}

TString ShingleToStroka0x(ui64 value) {
    TString res = "";
    char BUFF[25];

    memset(BUFF, 0, sizeof(BUFF));
    snprintf(BUFF, sizeof(BUFF) - 1, "0x%" PRIx64, value);
    res.assign(BUFF);

    return res;
}

TString ShingleToStroka2(ui64 value) {
    TString res = "";
    char BUFF[25];

    if (value == 0)
        res = "-";
    else {
        memset(BUFF, 0, sizeof(BUFF));
        snprintf(BUFF, sizeof(BUFF) - 1, "%016" PRIx64, value);
        res.assign(BUFF);
    }

    return res;
}

TString ShingleToStroka3(ui64 value) {
    TString res = "";
    char BUFF[25];

    if (value == 0)
        res = "-";
    else {
        memset(BUFF, 0, sizeof(BUFF));
        snprintf(BUFF, sizeof(BUFF) - 1, "%" PRIx64, value);
        res.assign(BUFF);
    }

    return res;
}

TString ShingleToStroka8(ui64 value) {
    TString res = "";
    char BUFF[25];

    if (value == 0)
        res = "-";
    else {
        memset(BUFF, 0, sizeof(BUFF));
        snprintf(BUFF, sizeof(BUFF) - 1, "%08" PRIX64, value);
        res.assign(BUFF);
    }

    return res;
}

TString BoolToStroka(bool value) {
    TString res = "";

    if (value)
        res = "1";
    else
        res = "0";

    return res;
}

TString BoolToStroka2(bool value) {
    TString res = "";

    if (value)
        res = "yes";
    else
        res = "no";

    return res;
}

TString BoolToStroka3(bool value) {
    TString res = "";

    if (value)
        res = "ok";
    else
        res = "failed";

    return res;
}

TString BoolToStroka4(bool value) {
    TString res = "";

    if (value)
        res = "true";
    else
        res = "false";

    return res;
}

TString BoolToStroka5(bool value) {
    TString res = "";

    if (value)
        res = "OK";
    else
        res = "NO";

    return res;
}

TString ui32ToStroka(ui32 value) {
    TString res = "";
    char BUFF[25];

    memset(BUFF, 0, sizeof(BUFF));
    snprintf(BUFF, sizeof(BUFF) - 1, "%07u", value);
    res.assign(BUFF);

    return res;
}

TString UI32ToStroka(ui32 value) {
    TString res = "";
    char BUFF[25];

    memset(BUFF, 0, sizeof(BUFF));
    snprintf(BUFF, sizeof(BUFF) - 1, "%u", value);
    res.assign(BUFF);

    return res;
}

TString ui32ToBinary(ui32 value) {
    TString res = "";
    ui32 tmp = 0;

    tmp = value;
    for (int i = 0; i < 32; i++) {
        if ((tmp & 0x01) > 0)
            res = res + "1";
        else
            res = res + "0";
        tmp = tmp >> 1;
    }
    ReverseInPlace(res);

    return res;
}

TString UI64ToBinary(const ui64 value) {
    TString res = "";
    ui64 tmp = 0;

    tmp = value;
    for (int i = 0; i < 64; i++) {
        if ((tmp & 0x01) > 0)
            res = res + "1";
        else
            res = res + "0";
        tmp = tmp >> 1;
    }
    ReverseInPlace(res);

    return res;
}

TString FilemaskToBinary(ui32 value) {
    TString res = "";
    ui32 tmp = 0;
    int a = 0;

    tmp = value;
    for (int i = 0; i < 12; i++) {
        if ((tmp & 0x01) > 0)
            res = res + "1";
        else
            res = res + "0";
        a++;
        if (a == 3) {
            res = res + " ";
            a = 0;
        }
        tmp = tmp >> 1;
    }
    ReverseInPlace(res);

    return res;
}

TString ui8ToBinary(ui8 value) {
    TString res = "";
    ui8 tmp = 0;

    tmp = value;
    for (int i = 0; i < 8; i++) {
        if ((tmp & 0x01) > 0)
            res = res + "1";
        else
            res = res + "0";
        tmp = tmp >> 1;
    }
    ReverseInPlace(res);

    return res;
}

TString UnPack64Compat(ui64 value) {
    TString res = "";
    char symb = 0;

    for (size_t i = 0; i < sizeof(value); i++) {
        symb = (char)((value >> (i * 8)) & 0xFF);
        res = res + IntToStroka(symb);
        if (i < (sizeof(value) - 1))
            res = res + ".";
        else
            break;
    }
    return res;
}

TString DoubleToStr(double value) {
    TString res = "";
    char BUFF[64];

    memset(BUFF, 0, sizeof(BUFF));
    snprintf(BUFF, sizeof(BUFF) - 1, "%1.10f", value);
    res.assign(BUFF);

    return res;
}

TString FloatToStr(float value) {
    TString res = "";
    char BUFF[25];

    memset(BUFF, 0, sizeof(BUFF));
    snprintf(BUFF, sizeof(BUFF) - 1, "%2.2f", value);
    res.assign(BUFF);

    return res;
}

TString FloatToStr0(float value) {
    TString res = "";
    char BUFF[25];
    ui32 uv = value;

    memset(BUFF, 0, sizeof(BUFF));
    snprintf(BUFF, sizeof(BUFF) - 1, "%u", uv);
    res.assign(BUFF);

    return res;
}

TString FloatToStr2(float value) {
    TString res = "";
    char BUFF[25];

    memset(BUFF, 0, sizeof(BUFF));
    snprintf(BUFF, sizeof(BUFF) - 1, "%5.2f", value);
    res.assign(BUFF);

    return res;
}

TString FloatToStr5(float value) {
    TString res = "";
    char BUFF[25];

    memset(BUFF, 0, sizeof(BUFF));
    snprintf(BUFF, sizeof(BUFF) - 1, "%2.5f", value);
    res.assign(BUFF);

    return res;
}

TString TimeToStr(time_t t) {
    TString res = "";
    tm tt;
    char BUFF[256];

    if (t != 0) {
        tt = *localtime(&t);
        memset(BUFF, 0, sizeof(BUFF));
        strftime(BUFF, sizeof(BUFF) - 1, "%Y.%m.%d %H:%M:%S", &tt);
        res.assign(BUFF);
    } else
        res = "-";

    return res;
}

TString TimeToStr2(time_t t) {
    TString res = "";
    tm tt;
    char BUFF[256];

    tt = *localtime(&t);
    memset(BUFF, 0, sizeof(BUFF));
    strftime(BUFF, sizeof(BUFF) - 1, "%d-%H:%M", &tt);
    res.assign(BUFF);

    return res;
}

TString TimeToStrNoProbel(time_t t) {
    TString res = "";
    tm tt;
    char BUFF[256];

    if (t != 0) {
        tt = *localtime(&t);
        memset(BUFF, 0, sizeof(BUFF));
        strftime(BUFF, sizeof(BUFF) - 1, "%Y.%m.%d_%H:%M:%S", &tt);
        res.assign(BUFF);
    } else
        res = "-";

    return res;
}

TStringBuf Trim(TStringBuf s) {
    auto isBadSymbol = [](const char* ptr) { return (*ptr > 0 && *ptr <= ' '); };
    return StripString(s, isBadSymbol);
}

TString UnPack32(ui32 value) {
    TString res = "";
    char symb = 0;

    for (size_t i = 0; i < sizeof(value); i++) {
        symb = (char)((value >> (i * 8)) & 0xFF);
        res = res + IntToStroka3(symb);
        if (i < (sizeof(value) - 1))
            res = res + ".";
    }
    return res;
}

TString UnPack64(ui64 value) {
    TString res = "";
    char symb = 0;

    for (size_t i = 0; i < sizeof(value); i++) {
        symb = (char)((value >> (i * 8)) & 0xFF);
        res = res + IntToStroka3(symb);
        if (i < (sizeof(value) - 3))
            res = res + ".";
        else
            break;
    }
    return res;
}

/*ui32 Pack32_str(TString &s){
    ui32   res;
    TString srab, stemp;
    ui32   perem;
    ui8    bytecounter;

    res = 0;
    srab = s;
    stemp = "";
    bytecounter = 0;
    if (srab.length() > 0){
        for (int i = 0; i <= srab.length(); i++){
             if ((srab[i] == '.') || (i == srab.length())){
                if (stemp.length() > 0)
                    perem = atoi(stemp.c_str());
                else
                    perem = 0;
                perem = perem << (bytecounter * 8);
                res = res | perem;
                stemp = "";
                bytecounter++;
                if (bytecounter > 3)
                    break;
                continue;
            }
            stemp = stemp + srab[i];
        }

    }
    return res;
}

ui64 Pack64_str(TString &s){
    ui64   res;
    TString srab, stemp;
    ui64   perem;
    ui8    bytecounter;

    res = 0;
    srab = s;
    stemp = "";
    bytecounter = 0;
    if (srab.length() > 0){
        for (int i = 0; i <= srab.length(); i++){
             if ((srab[i] == '.') || (i == srab.length())){
                 if (stemp.length() > 0)
                     perem = atoi(stemp.c_str());
                 else
                     perem = 0;
                 perem = perem << (bytecounter * 8);
                 res = res | perem;
                 stemp = "";
                 bytecounter++;
                 if (bytecounter > 7)
                     break;
                 continue;
             }
             stemp = stemp + srab[i];
        }

    }
    return res;
}*/

ui64 PackToStr(const TString& s, int dig) {
    ui64 res;
    TString srab = "";
    TString stemp = "";
    ui64 perem;
    ui8 bytecounter;
    TString::const_iterator it;

    res = 0;
    srab = s;
    stemp = "";
    bytecounter = 0;
    if (srab.length() > 0) {
        it = srab.begin();
        while (it != srab.end()) {
            if ((*it) == '.') {
                perem = (!stemp.empty()) ? atoi(stemp.c_str()) : 0;
                perem = perem << (bytecounter * 8);
                res = res | perem;
                stemp = "";
                bytecounter++;
                if (bytecounter > dig)
                    break;
            } else
                stemp = stemp + (*it);

            ++it;
        }
        if (bytecounter <= dig) {
            perem = (!stemp.empty()) ? atoi(stemp.c_str()) : 0;
            perem = perem << (bytecounter * 8);
            res = res | perem;
        }
    }
    return res;
}

ui32 Pack32_str2(const TString& s) {
    ui32 res = 0;

    res = (ui32)(PackToStr(s, 3) & 0xFFFFFFFF);

    return res;
}

ui64 Pack64_str2(const TString& s) {
    return PackToStr(s, 7);
}

ui8 GetVowelsCount(const TString& s) {
    ui8 res;

    res = 0;
    for (unsigned int i = 0; i < s.length(); i++) {
        switch (s[i]) {
            case 'a':
            case 'o':
            case 'u':
            case 'i':
            case 'e':
            case 'y':
                res++;
                break;
        }
    }
    return res;
}


ui16 GetConstanantsSerialCountExt(const TString& s) {
    ui16 res = 0, tek = 0;
    bool flag = false;
    unsigned char uc = 0;
    char symb = 0;

    res = 0;
    tek = 0;
    for (unsigned int i = 0; i < s.length(); i++) {
        symb = s[i];
        memcpy(&uc, &symb, sizeof(uc));

        flag = false;
        if ((uc >= 'A') && (uc <= 'Z'))
            flag = true;
        if ((uc >= 'a') && (uc <= 'z'))
            flag = true;
        if ((uc >= 192) && (uc <= 223)) //А .. Я (без "Ё")
            flag = true;
        if ((uc >= 224) && (uc <= 255)) //а .. я (без "ё")
            flag = true;

        if (flag) {
            switch (uc) {
                case 'a':
                case 'o':
                case 'u':
                case 'i':
                case 'e':
                case 'y':
                case 'A':
                case 'O':
                case 'U':
                case 'I':
                case 'E':
                case 'Y':
                case 168: //Ё - 168
                case 192: //А - 192
                case 197: //Е - 197
                case 200: //И - 200
                case 206: //О - 206
                case 211: //У - 211
                case 219: //Ы - 219
                case 221: //Э - 221
                case 222: //Ю - 222
                case 223: //Я - 223
                case 184: //ё - 184
                case 224: //а - 224
                case 229: //е - 229
                case 232: //и - 232
                case 238: //о - 238
                case 243: //у - 243
                case 251: //ы - 251
                case 253: //э - 253
                case 254: //ю - 254
                case 255: //я - 255
                    flag = false;
                    break;
            }
        }
        if (flag) {
            tek++;
            if (tek > res)
                res = tek;
        } else {
            if (tek > res)
                res = tek;
            tek = 0;
        }
    }
    return res;
}

ui16 GetConstanantsDigitsSerialCount(const TString& s) {
    ui16 res, tek;
    bool flag;

    res = 0;
    tek = 0;
    for (unsigned int i = 0; i < s.length(); i++) {
        flag = false;
        if ((s[i] >= 'A') && (s[i] <= 'Z'))
            flag = true;
        if ((s[i] >= 'a') && (s[i] <= 'z'))
            flag = true;
        if ((s[i] >= '0') && (s[i] <= '9'))
            flag = true;
        if (flag) {
            switch (s[i]) {
                case 'a':
                case 'o':
                case 'u':
                case 'i':
                case 'e':
                case 'y':
                case 'A':
                case 'O':
                case 'U':
                case 'I':
                case 'E':
                case 'Y':
                    flag = false;
                    break;
            }
        }
        if (flag) {
            tek++;
            if (tek > res)
                res = tek;
        } else {
            if (tek > res)
                res = tek;
            tek = 0;
        }
    }
    return res;
}

ui16 GetVowelsSerialCount(TString s) {
    ui16 res, tek;
    bool flag;

    res = 0;
    tek = 0;
    for (unsigned int i = 0; i < s.length(); i++) {
        switch (s[i]) {
            case 'a':
            case 'o':
            case 'u':
            case 'i':
            case 'e':
            case 'y':
            case 'A':
            case 'O':
            case 'U':
            case 'I':
            case 'E':
            case 'Y':
                flag = true;
                break;
            default:
                flag = false;
        }
        if (flag) {
            tek++;
            if (tek > res)
                res = tek;
        } else {
            if (tek > res)
                res = tek;
            tek = 0;
        }
    }
    return res;
}

ui16 GetVowelsSerialCountExt(const TString& s) {
    ui16 res = 0, tek = 0;
    bool flag = false;
    unsigned char uc = 0;
    char symb = 0;

    res = 0;
    tek = 0;
    for (unsigned int i = 0; i < s.length(); i++) {
        symb = s[i];
        memcpy(&uc, &symb, sizeof(uc));
        switch (uc) {
            case 'a':
            case 'o':
            case 'u':
            case 'i':
            case 'e':
            case 'y':
            case 'A':
            case 'O':
            case 'U':
            case 'I':
            case 'E':
            case 'Y':
            case 168: //Ё - 168
            case 192: //А - 192
            case 197: //Е - 197
            case 200: //И - 200
            case 206: //О - 206
            case 211: //У - 211
            case 219: //Ы - 219
            case 221: //Э - 221
            case 222: //Ю - 222
            case 223: //Я - 223
            case 184: //ё - 184
            case 224: //а - 224
            case 229: //е - 229
            case 232: //и - 232
            case 238: //о - 238
            case 243: //у - 243
            case 251: //ы - 251
            case 253: //э - 253
            case 254: //ю - 254
            case 255: //я - 255
                flag = true;
                break;
            default:
                flag = false;
        }
        if (flag) {
            tek++;
            if (tek > res)
                res = tek;
        } else {
            if (tek > res)
                res = tek;
            tek = 0;
        }
    }
    return res;
}

TStringBuf GetLoginPrefix(const TStringBuf& s) {
    const auto n = s.find_first_of("0123456789.-", 0);
    return s.substr(0, n);
}

size_t GetDigitsLoginCount(const TStringBuf& s) {
    size_t res{};
    for(const auto c : s) {
        if ((c >= '0') && (c <= '9'))
            res++;
    }
    return res;
}

bool GetOtherSymbols(TString s) {
    bool res = false;
    unsigned int digits_count = 0, all_size = 0;

    digits_count = GetDigitsLoginCount(s);
    all_size = (unsigned int)s.size();
    if ((all_size - digits_count) > 0)
        res = true;

    return res;
}

float CompareLogin(TString login1, TString login2) {
    float res, koef;
    int rasn = 0, pr1 = 0, pr2 = 0, rasn2 = 0;
    unsigned int max = 0, min = 0;
    //bool  b1, b2;
    ui8 flag = 0;

    res = 0;
    max = (unsigned int)login1.size();
    min = max;
    if (login2.size() > max)
        max = (unsigned int)login2.size();
    if (login2.size() < min)
        min = (unsigned int)login2.size();
    if (max > 0) {
        koef = (float)((float)1 / (float)max);
        for (unsigned int i = 0; i < max; i++) {
            if (i >= min)
                break;
            pr1 = login1[i];
            pr2 = login2[i];
            flag = 0;
            if (((pr1 == 48) && (pr2 == 57)) || ((pr1 == 57) && (pr2 == 48))) {
                flag = 1;
                if (i >= 1) {
                    rasn2 = login1[i - 1] - login2[i - 1];
                    if (rasn2 < 0)
                        rasn2 = rasn2 * -1;
                    if (rasn2 == 1)
                        flag = 2;
                }
            }
            rasn = pr1 - pr2;
            if (rasn < 0)
                rasn = rasn * -1;
            if (rasn == 0) {
                res = res + koef * (float)1;
            } else if (flag == 1) {
                res = res + koef * (float)0.5;
            } else if (flag == 2) {
                res = res + koef * (float)1;
            } else if ((rasn > 0) && (rasn <= 3)) {
                res = res + koef * (float)0.5;
            }
        }
    }
    return res;
}

bool IsConstanantsK(char symb) {
    bool flag = false;

    if ((symb >= 'A') && (symb <= 'Z'))
        flag = true;
    if ((symb >= 'a') && (symb <= 'z'))
        flag = true;
    if (flag) {
        switch (symb) {
            case 'a':
            case 'o':
            case 'u':
            case 'i':
            case 'e':
            case 'y':
            case 'A':
            case 'O':
            case 'U':
            case 'I':
            case 'E':
            case 'Y':
                flag = false;
                break;
        }
    }
    return flag;
}

bool IsVowelsK(char symb) {
    bool flag = false;

    switch (symb) {
        case 'a':
        case 'o':
        case 'u':
        case 'i':
        case 'e':
        case 'y':
        case 'A':
        case 'O':
        case 'U':
        case 'I':
        case 'E':
        case 'Y':
            flag = true;
            break;
    }
    return flag;
}

bool IsDigitsK(char symb) {
    bool flag = false;

    if ((symb >= '0') && (symb <= '9'))
        flag = true;

    return flag;
}

ui8 GetPairConstanantsVowels(TString login) {
    ui8 res = 0, res1 = 0, res2 = 0;
    char symb1 = 0, symb2 = 0;

    for (unsigned int i = 1; i < login.size(); i++) {
        symb1 = login[i - 1];
        symb2 = login[i];
        if (IsConstanantsK(symb1) && IsVowelsK(symb2)) {
            res1++;
            i++;
        }
    }
    for (unsigned int i = 1; i < login.size(); i++) {
        symb1 = login[i - 1];
        symb2 = login[i];
        if (IsVowelsK(symb1) && IsConstanantsK(symb2)) {
            res2++;
            i++;
        }
    }
    if (res1 > res2)
        res = res1;
    else
        res = res2;

    return res;
}

bool Is1251Symbol(char symbi) {
    bool res = false;
    unsigned char symb = 0;

    memcpy(&symb, &symbi, sizeof(symb));
    if ((symb >= 0xC0) && (symb <= 0xDF)) //А .. Я
        res = true;
    else if (symb == 0xA8) //Ё
        res = true;
    else if ((symb >= 0xE0) && (symb <= 0xFF)) //а .. я
        res = true;
    else if (symb == 0xB8) //ё
        res = true;
    else if ((symb >= 'A') && (symb <= 'Z')) //A .. Z
        res = true;
    else if ((symb >= 'a') && (symb <= 'z')) //a .. z
        res = true;

    return res;
}

TString GetOnlySymbols1251(TString str) {
    TString res = "";

    for (unsigned int i = 0; i < str.size(); i++)
        if (Is1251Symbol(str[i]))
            res = res + str[i];

    return res;
}

TString ModifyHint(TString hint) {
    for(char& c : hint) {
        if(c != '0' && c != '.') {
            c = '1';
        }
    }

    return hint;
}

bool Upper_rus1251_symbol(unsigned char symb) {
    bool res = false;

    if ((symb >= 0xC0) && (symb <= 0xDF)) //А .. Я
        res = true;
    else if (symb == 0xA8) //Ё
        res = true;

    return res;
}

bool Lower_rus1251_symbol(unsigned char symb) {
    bool res = false;

    if ((symb >= 0xE0) && (symb <= 0xFF)) //а .. я
        res = true;
    else if (symb == 0xB8) //ё
        res = true;

    return res;
}

bool Upper_eng_symbol(unsigned char symb) {
    bool res = false;

    if ((symb >= 'A') && (symb <= 'Z')) //A .. Z
        res = true;

    return res;
}

bool Lower_eng_symbol(unsigned char symb) {
    bool res = false;

    if ((symb >= 'a') && (symb <= 'z')) //a .. z
        res = true;

    return res;
}

ui8 GetTypeName1251(TString name) {
    ui8 res = 0;
    bool first_upper_rus1251 = true;
    bool first_lower_rus1251 = true;
    bool first_upper_eng = true;
    bool first_lower_eng = true;
    bool upper_rus1251 = true;
    bool lower_rus1251 = true;
    bool upper_eng = true;
    bool lower_eng = true;
    unsigned char symb = 0;
    char symbs = 0;

    for (unsigned int i = 0; i < name.size(); i++) {
        symbs = name[i];
        memcpy(&symb, &symbs, sizeof(symb));
        if (i == 0) //first symbol
        {
            if (!Upper_rus1251_symbol(symb))
                first_upper_rus1251 = false;
            if (!Lower_rus1251_symbol(symb))
                first_lower_rus1251 = false;
            if (!Upper_eng_symbol(symb))
                first_upper_eng = false;
            if (!Lower_eng_symbol(symb))
                first_lower_eng = false;
        } else // next symbols
        {
            if (!Upper_rus1251_symbol(symb))
                upper_rus1251 = false;
            if (!Lower_rus1251_symbol(symb))
                lower_rus1251 = false;
            if (!Upper_eng_symbol(symb))
                upper_eng = false;
            if (!Lower_eng_symbol(symb))
                lower_eng = false;
        }
    }

    if (first_upper_rus1251 && lower_rus1251)
        res = 1;
    else if (first_lower_rus1251 && lower_rus1251)
        res = 2;
    else if (first_upper_rus1251 && upper_rus1251)
        res = 3;
    else if (first_upper_eng && lower_eng)
        res = 4;
    else if (first_lower_eng && lower_eng)
        res = 5;
    else if (first_upper_eng && upper_eng)
        res = 6;

    return res;
}

ui8 GetOtnGigitsToSize(TString s) {
    ui8 res = 0;
    float otn = 0;
    ui8 digcount = 0;

    digcount = GetDigitsLoginCount(s);
    if (s.size() > 0)
        otn = (float)digcount / (float)s.size();
    if (otn == 0)
        res = 0;
    else if ((otn > 0) && (otn < 0.33))
        res = 1;
    else if ((otn >= 0.33) && (otn < 0.66))
        res = 2;
    else if (otn >= 0.66)
        res = 3;

    return res;
}

ui8 GetTypeExt(TString s) {
    ui8 res = 0;
    ui8 type = 0;

    type = GetTypeName1251(s);

    if ((type == 4) || (type == 5) || (type == 6))
        res = 1;
    else if ((type == 1) || (type == 2) || (type == 3))
        res = 2;
    else
        res = 0;

    return res;
}

TString CompareTranslitRU(const TString& s1, const TString& s2, unsigned int count, bool& res) {
    typedef TList<TString> TListType;
    typedef TListType::iterator TListIt;

    TString sres = "";

    res = false;
    if (!s1.empty() && !s2.empty()) {
        char symb = 0, symb2 = 0;
        ui8 usymb = 0, usymb2 = 0;
        TString sw1 = s1, sw2 = s2;
        TString token[5];
        ui8 tokencount = 0;
        TListType mainlist;
        TListIt mit, tit;
        TString sprefix = "", s = "";
        unsigned int scount = 0;

        //if (strpbrk(sw1.c_str(), "0123456789") != nullptr)
        //   return sres;

        to_lower_k(sw1);
        to_lower_k(sw2);
        if (sw1.size() > count)
            scount = count;
        else
            scount = (unsigned int)sw1.size();

        for (unsigned int i = 0; i < scount; i++) {
            symb = sw1[i];
            memcpy(&usymb, &symb, sizeof(symb));
            tokencount = 0;
            if ((usymb >= 0x61) && (usymb <= 0x7A)) //a .. z
            {
                token[0] = TString(symb);
                tokencount = 1;
            } else { //а .. я
                switch (usymb) {
                    case 0xE0: //а
                        token[0] = "a";
                        tokencount = 1;
                        break;
                    case 0xE1: //б
                        token[0] = "b";
                        tokencount = 1;
                        break;
                    case 0xE2: //в
                        token[0] = "v";
                        tokencount = 1;
                        break;
                    case 0xE3: //г
                        token[0] = "g";
                        tokencount = 1;
                        break;
                    case 0xE4: //д
                        token[0] = "d";
                        tokencount = 1;
                        break;
                    case 0xE5: //е
                        token[0] = "e";
                        tokencount = 1;
                        break;
                    case 0xE6: //ж
                        token[0] = "zh";
                        token[1] = "j";
                        token[2] = "g";
                        tokencount = 3;
                        break;
                    case 0xE7: //з
                        token[0] = "z";
                        tokencount = 1;
                        break;
                    case 0xE8: //и
                        token[0] = "i";
                        tokencount = 1;
                        break;
                    case 0xE9: //й
                        token[0] = "y";
                        token[1] = "j";
                        tokencount = 2;
                        break;
                    case 0xEA: //к
                        token[0] = "k";
                        tokencount = 1;
                        if ((i + 1) < scount) {
                            symb2 = sw1[i + 1];
                            memcpy(&usymb2, &symb2, sizeof(symb2));
                            if (usymb2 == 0xF1) //с
                            {
                                token[0] = "x";
                                token[1] = "ks";
                                tokencount = 2;
                                i++;
                                if (scount < sw1.size())
                                    scount++;
                            }
                        }
                        break;
                    case 0xEB: //л
                        token[0] = "l";
                        tokencount = 1;
                        break;
                    case 0xEC: //м
                        token[0] = "m";
                        tokencount = 1;
                        break;
                    case 0xED: //н
                        token[0] = "n";
                        tokencount = 1;
                        break;
                    case 0xEE: //о
                        token[0] = "o";
                        tokencount = 1;
                        break;
                    case 0xEF: //п
                        token[0] = "p";
                        tokencount = 1;
                        break;
                    case 0xF0: //р
                        token[0] = "r";
                        tokencount = 1;
                        break;
                    case 0xF1: //с
                        token[0] = "s";
                        tokencount = 1;
                        break;
                    case 0xF2: //т
                        token[0] = "t";
                        tokencount = 1;
                        break;
                    case 0xF3: //у
                        token[0] = "u";
                        tokencount = 1;
                        break;
                    case 0xF4: //ф
                        token[0] = "f";
                        tokencount = 1;
                        break;
                    case 0xF5: //х
                        token[0] = "kh";
                        token[1] = "h";
                        token[2] = "x";
                        tokencount = 3;
                        break;
                    case 0xF6: //ц
                        token[0] = "ts";
                        token[1] = "c";
                        tokencount = 2;
                        break;
                    case 0xF7: //ч
                        token[0] = "ch";
                        token[1] = "4";
                        tokencount = 2;
                        break;
                    case 0xF8: //ш
                        token[0] = "sh";
                        tokencount = 1;
                        break;
                    case 0xF9: //щ
                        token[0] = "shch";
                        token[1] = "sch";
                        tokencount = 2;
                        break;
                    case 0xFB: //ы
                        token[0] = "y";
                        token[1] = "i";
                        tokencount = 2;
                        break;
                    case 0xFD: //э
                        token[0] = "e";
                        tokencount = 1;
                        break;
                    case 0xFE: //ю
                        token[0] = "yu";
                        token[1] = "ju";
                        tokencount = 2;
                        break;
                    case 0xFF: //я
                        token[0] = "ya";
                        token[1] = "ja";
                        tokencount = 2;
                        break;
                    case 0xB8: //ё
                        token[0] = "e";
                        token[1] = "jo";
                        token[2] = "yo";
                        tokencount = 3;
                        break;
                    case 0xFA: //ъ
                    case 0xFC: //ь
                    default:
                        if (scount < sw1.size())
                            scount++;
                        continue;
                };
            }

            TListType templist = {};
            if (!mainlist) {
                for (int i = 0; i < tokencount; i++)
                    templist.push_back(token[i]);
            } else {
                mit = mainlist.begin();
                while (mit != mainlist.end()) {
                    sprefix = *mit;
                    for (int i = 0; i < tokencount; i++) {
                        s = sprefix + token[i];
                        templist.push_back(s);
                    }
                    ++mit;
                }
            }
            mainlist = std::move(templist);
        }

        if (mainlist && (s2.size() >= count)) {
            mit = mainlist.begin();
            while (mit != mainlist.end()) {
                s = *mit;
                if (s.size() < count) {
                    ++mit;
                    continue;
                } else if (s.size() > count) {
                    s = s.substr(0, count);
                }
                if (strstr((char*)sw2.c_str(), (char*)s.c_str())) {
                    res = true;
                    sres = s;
                    break;
                }
                ++mit;
            }
        }
        mainlist = {};
    }

    return sres;
}

TString CompareTranslitKZ(const TString& s1, const TString& s2, unsigned int count, bool& res) {
    typedef std::list<TString> TListType;
    typedef TListType::iterator TListIt;

    TString sres = "";

    res = false;
    if (!s1.empty() && !s2.empty()) {
        char symb = 0, symb2 = 0;
        ui8 usymb = 0, usymb2 = 0;
        TString sw1 = s1, sw2 = s2;
        TString token[5];
        ui8 tokencount = 0;
        TListType *mainlist = nullptr, *templist = nullptr;
        TListIt mit, tit;
        TString sprefix = "", s = "";
        unsigned int scount = 0;

        if (strpbrk(sw1.c_str(), "0123456789") != nullptr)
            return sres;

        to_lower_k(sw1);
        to_lower_k(sw2);
        if (sw1.size() > count)
            scount = count;
        else
            scount = (unsigned int)sw1.size();

        for (unsigned int i = 0; i < scount; i++) {
            symb = sw1[i];
            memcpy(&usymb, &symb, sizeof(symb));
            tokencount = 0;
            if ((usymb >= 0x61) && (usymb <= 0x7A)) //a .. z
            {
                token[0] = TString(symb);
                tokencount = 1;
            } else { //а .. я
                switch (usymb) {
                    case 0xBD:
                        token[0] = "a";
                        tokencount = 1;
                        break;
                    case 0x81:
                        token[0] = "f";
                        tokencount = 1;
                        break;
                    case 0x8D:
                        token[0] = "k";
                        tokencount = 1;
                        break;
                    case 0x8C:
                        token[0] = "n";
                        tokencount = 1;
                        break;
                    case 0x8A:
                        token[0] = "o";
                        tokencount = 1;
                        break;
                    case 0x80:
                        token[0] = "j";
                        tokencount = 1;
                        break;
                    case 0x8F:
                        token[0] = "u";
                        tokencount = 1;
                        break;
                    case 0x8E:
                        token[0] = "h";
                        tokencount = 1;
                        break;
                    case 0xB2:
                        token[0] = "j";
                        tokencount = 1;
                        break;
                    case 0xBE:
                        token[0] = "a";
                        tokencount = 1;
                        break;
                    case 0x83:
                        token[0] = "f";
                        tokencount = 1;
                        break;
                    case 0x9D:
                        token[0] = "k";
                        tokencount = 1;
                        break;
                    case 0x9C:
                        token[0] = "n";
                        tokencount = 1;
                        break;
                    case 0x9A:
                        token[0] = "o";
                        tokencount = 1;
                        break;
                    case 0x90:
                        token[0] = "j";
                        tokencount = 1;
                        break;
                    case 0x9F:
                        token[0] = "u";
                        tokencount = 1;
                        break;
                    case 0x9E:
                        token[0] = "h";
                        tokencount = 1;
                        break;
                    case 0xB3:
                        token[0] = "j";
                        tokencount = 1;
                        break;
                    case 0xE0: //а
                        token[0] = "a";
                        tokencount = 1;
                        break;
                    case 0xE1: //б
                        token[0] = "b";
                        tokencount = 1;
                        break;
                    case 0xE2: //в
                        token[0] = "v";
                        tokencount = 1;
                        break;
                    case 0xE3: //г
                        token[0] = "g";
                        tokencount = 1;
                        break;
                    case 0xE4: //д
                        token[0] = "d";
                        tokencount = 1;
                        break;
                    case 0xE5: //е
                        token[0] = "e";
                        tokencount = 1;
                        break;
                    case 0xE6: //ж
                        token[0] = "zh";
                        token[1] = "j";
                        token[2] = "g";
                        tokencount = 3;
                        break;
                    case 0xE7: //з
                        token[0] = "z";
                        tokencount = 1;
                        break;
                    case 0xE8: //и
                        token[0] = "i";
                        tokencount = 1;
                        break;
                    case 0xE9: //й
                        token[0] = "y";
                        token[1] = "j";
                        tokencount = 2;
                        break;
                    case 0xEA: //к
                        token[0] = "k";
                        tokencount = 1;
                        if ((i + 1) < scount) {
                            symb2 = sw1[i + 1];
                            memcpy(&usymb2, &symb2, sizeof(symb2));
                            if (usymb2 == 0xF1) //с
                            {
                                token[0] = "x";
                                token[1] = "ks";
                                tokencount = 2;
                                i++;
                                if ((scount + 1) <= sw1.size())
                                    scount++;
                            }
                        }
                        break;
                    case 0xEB: //л
                        token[0] = "l";
                        tokencount = 1;
                        break;
                    case 0xEC: //м
                        token[0] = "m";
                        tokencount = 1;
                        break;
                    case 0xED: //н
                        token[0] = "n";
                        tokencount = 1;
                        break;
                    case 0xEE: //о
                        token[0] = "o";
                        tokencount = 1;
                        break;
                    case 0xEF: //п
                        token[0] = "p";
                        tokencount = 1;
                        break;
                    case 0xF0: //р
                        token[0] = "r";
                        tokencount = 1;
                        break;
                    case 0xF1: //с
                        token[0] = "s";
                        tokencount = 1;
                        break;
                    case 0xF2: //т
                        token[0] = "t";
                        tokencount = 1;
                        break;
                    case 0xF3: //у
                        token[0] = "u";
                        tokencount = 1;
                        break;
                    case 0xF4: //ф
                        token[0] = "f";
                        tokencount = 1;
                        break;
                    case 0xF5: //х
                        token[0] = "kh";
                        token[1] = "h";
                        token[2] = "x";
                        tokencount = 3;
                        break;
                    case 0xF6: //ц
                        token[0] = "ts";
                        token[1] = "c";
                        tokencount = 2;
                        break;
                    case 0xF7: //ч
                        token[0] = "ch";
                        token[1] = "4";
                        tokencount = 2;
                        break;
                    case 0xF8: //ш
                        token[0] = "sh";
                        tokencount = 1;
                        break;
                    case 0xF9: //щ
                        token[0] = "shch";
                        token[1] = "sch";
                        tokencount = 2;
                        break;
                    case 0xFB: //ы
                        token[0] = "y";
                        token[1] = "i";
                        tokencount = 2;
                        break;
                    case 0xFD: //э
                        token[0] = "e";
                        tokencount = 1;
                        break;
                    case 0xFE: //ю
                        token[0] = "yu";
                        token[1] = "ju";
                        tokencount = 2;
                        break;
                    case 0xFF: //я
                        token[0] = "ya";
                        token[1] = "ja";
                        tokencount = 2;
                        break;
                    case 0xB8: //ё
                        token[0] = "e";
                        token[1] = "jo";
                        token[2] = "yo";
                        tokencount = 3;
                        break;
                    case 0xFA: //ъ
                    case 0xFC: //ь
                    default:
                        if (scount < sw1.size())
                            scount++;
                        continue;
                };
            }

            templist = new TListType();
            if (mainlist == nullptr) {
                for (int i = 0; i < tokencount; i++)
                    templist->push_back(token[i]);
            } else {
                mit = mainlist->begin();
                while (mit != mainlist->end()) {
                    sprefix = *mit;
                    for (int i = 0; i < tokencount; i++) {
                        s = sprefix + token[i];
                        templist->push_back(s);
                    }
                    ++mit;
                }
            }
            if (mainlist != nullptr) {
                mainlist->clear();
                delete mainlist;
                mainlist = nullptr;
            }
            mainlist = templist;
            templist = nullptr;
        }

        if ((mainlist != nullptr) && (s2.size() >= count)) {
            mit = mainlist->begin();
            while (mit != mainlist->end()) {
                s = *mit;
                if (s.size() < count) {
                    ++mit;
                    continue;
                } else if (s.size() > count) {
                    s = s.substr(0, count);
                }
                if (strstr((char*)sw2.c_str(), (char*)s.c_str())) {
                    res = true;
                    sres = s;
                    break;
                }
                ++mit;
            }

            mainlist->clear();
            delete mainlist;
            mainlist = nullptr;
        }
        if (mainlist != nullptr) {
            mainlist->clear();
            delete mainlist;
            mainlist = nullptr;
        }
    }

    return sres;
}

/*TString CompareTranslit(TString s1, TString s2, int count, bool &res)
{
   typedef list<TString>    TListType;
   typedef TListType::iterator TListIt;

   TString  sres  = "";
   char    symb  = 0, symb2 = 0;
   ui8     usymb = 0, usymb2 = 0;
   TString  sw1 = s1, sw2 = s2;
   TString  token[5];
   ui8     tokencount = 0;
   TListType   *mainlist = nullptr, *templist = nullptr;
   TListIt mit, tit;
   TString  sprefix = "", s = "";
   int     scount = 0;

   res = false;
   if (strpbrk(sw1.c_str(), "0123456789") != nullptr)
      return sres;

   sw1.to_lower(0, sw1.size(), *CodePageByName("cp1251"));
   sw2.to_lower(0, sw2.size(), *CodePageByName("cp1251"));
   if (sw1.size() > count)
      scount = count;
   else
      scount = sw1.size();

   for (int i = 0; i < scount; i++)
   {
      symb = sw1[i];
      memcpy(&usymb, &symb, sizeof(symb));
      tokencount = 0;
      if ((usymb >= 0x61) && (usymb <= 0x7A)) //a .. z
      {
         token[0] = TString(symb);
         tokencount = 1;
      } else
      {                                       //а .. я
         switch (usymb)
         {
            case 0xE0: //а
                        token[0] = "a";
                        tokencount = 1;
                        break;
            case 0xE1: //б
                     token[0] = "b";
                     tokencount = 1;
                     break;
            case 0xE2: //в
                     token[0] = "v";
                     tokencount = 1;
                     break;
            case 0xE3: //г
                     token[0] = "g";
                     tokencount = 1;
                     break;
            case 0xE4: //д
                     token[0] = "d";
                     tokencount = 1;
                     break;
            case 0xE5: //е
                     token[0] = "e";
                     tokencount = 1;
                     break;
            case 0xE6: //ж
                     token[0] = "zh";
                     token[1] = "j";
                     token[2] = "g";
                     tokencount = 3;
                     break;
            case 0xE7: //з
                     token[0] = "z";
                     tokencount = 1;
                     break;
            case 0xE8: //и
                     token[0] = "i";
                     tokencount = 1;
                     break;
            case 0xE9: //й
                     token[0] = "y";
                     token[1] = "j";
                     tokencount = 2;
                     break;
            case 0xEA: //к
                     token[0] = "k";
                     tokencount = 1;
                     if ((i + 1) < scount)
                     {
                        symb2 = sw1[i + 1];
                        memcpy(&usymb2, &symb2, sizeof(symb2));
                        if (usymb2 == 0xF1) //с
                        {
                           token[0] = "x";
                           token[1] = "ks";
                           tokencount = 2;
                           i++;
                           if ((scount + 1) <= sw1.size())
                              scount++;
                        }
                     }
                     break;
            case 0xEB: //л
                     token[0] = "l";
                     tokencount = 1;
                     break;
            case 0xEC: //м
                     token[0] = "m";
                     tokencount = 1;
                     break;
            case 0xED: //н
                     token[0] = "n";
                     tokencount = 1;
                     break;
            case 0xEE: //о
                     token[0] = "o";
                     tokencount = 1;
                     break;
            case 0xEF: //п
                     token[0] = "p";
                     tokencount = 1;
                     break;
            case 0xF0: //р
                     token[0] = "r";
                     tokencount = 1;
                     break;
            case 0xF1: //с
                     token[0] = "s";
                     tokencount = 1;
                     break;
            case 0xF2: //т
                     token[0] = "t";
                     tokencount = 1;
                     break;
            case 0xF3: //у
                     token[0] = "u";
                     tokencount = 1;
                     break;
            case 0xF4: //ф
                     token[0] = "f";
                     tokencount = 1;
                     break;
            case 0xF5: //х
                     token[0] = "kh";
                     token[1] = "h";
                     token[2] = "x";
                     tokencount = 3;
                     break;
            case 0xF6: //ц
                     token[0] = "ts";
                     token[1] = "c";
                     tokencount = 2;
                     break;
            case 0xF7: //ч
                     token[0] = "ch";
                     token[1] = "4";
                     tokencount = 2;
                     break;
            case 0xF8: //ш
                     token[0] = "sh";
                     tokencount = 1;
                     break;
            case 0xF9: //щ
                     token[0] = "shch";
                     token[1] = "sch";
                     tokencount = 2;
                     break;
            case 0xFB: //ы
                     token[0] = "y";
                     token[1] = "i";
                     tokencount = 2;
                     break;
            case 0xFD: //э
                     token[0] = "e";
                     tokencount = 1;
                     break;
            case 0xFE: //ю
                     token[0] = "yu";
                     token[1] = "ju";
                     tokencount = 2;
                     break;
            case 0xFF: //я
                     token[0] = "ya";
                     token[1] = "ja";
                     tokencount = 2;
                     break;
            case 0xB8: //ё
                     token[0] = "e";
                     token[1] = "jo";
                     token[2] = "yo";
                     tokencount = 3;
                     break;
            case 0xFA: //ъ
            case 0xFC: //ь
            default:
                     if ((scount + 1) <= sw1.size())
                        scount++;
                     continue;

         };
      }

      templist = new TListType();
      if (mainlist == nullptr)
      {
         for (int i = 0; i < tokencount; i++)
            templist->push_back(token[i]);
      } else
      {
         mit = mainlist->begin();
         while (mit != mainlist->end())
         {
            sprefix = *mit;
            for (int i = 0; i < tokencount; i++)
            {
               s = sprefix + token[i];
               templist->push_back(s);
            }
            ++mit;
         }
      }
      if (mainlist != nullptr)
      {
         mainlist->clear();
         delete mainlist;
         mainlist = nullptr;
      }
      mainlist = templist;
      templist = nullptr;
   }

   if ((mainlist != nullptr) && (s2.size() >= count))
   {
      mit = mainlist->begin();
      while (mit != mainlist->end())
      {
         s = *mit;
         if (s.size() < count)
         {
            ++mit;
            continue;
         } else if (s.size() > count)
         {
            s = s.substr(0, count);
         }
         if (strstr((char *)sw2.c_str(), (char *)s.c_str()))
         {
            res = true;
            sres = s;
            break;
         }
         ++mit;
      }

      int n = mainlist->size();

      mainlist->clear();
      delete mainlist;
      mainlist = nullptr;
   }
   if (mainlist != nullptr)
   {
      mainlist->clear();
      delete mainlist;
      mainlist = nullptr;
   }

   return sres;
}*/

TString RemoveCR(const TString& s) {
    TString res = s;
    TString::iterator it;

    it = res.begin();
    while (it != res.end()) {
        if ((*it) == 0x0D)
            (*it) = ' ';
        else if ((*it) == 0x0A)
            (*it) = ' ';
        ++it;
    }

    return res;
}

ui64 GetShingle(const TString& text) {
    if (!text.empty()) {
        return FnvHash<ui64>(text.c_str(), (int)text.size());
    }

    return 0;
}

TString EncodeToHTML(const TString& text) {
    TString res = "";

    for (unsigned int i = 0; i < text.size(); i++) {
        switch (text[i]) {
            case '&':
                res = res + "&amp;";
                break;
            case '<':
                res = res + "&lt;";
                break;
            case '>':
                res = res + "&gt;";
                break;
            case '"':
                res = res + "&quot;";
                break;
            default:
                res = res + text[i];
        };
    }

    return res;
}

struct TWStroka {
    TString key;
    TString value;

    TWStroka() {
        key = "";
        value = "";
    }
    TWStroka(TString keyA, TString valueA) {
        key = keyA;
        value = valueA;
    }
};

typedef std::list<TWStroka> TWStrokaList;
typedef TWStrokaList::iterator TWStrokaListIt;

bool IsHTML(TWStrokaList& wlist, const char* p) {
    bool res = false;
    const char* pfind = nullptr;
    TWStrokaListIt slistit;

    slistit = wlist.begin();
    while (slistit != wlist.end()) {
        pfind = strstr(p, (*slistit).key.c_str());
        if (pfind != nullptr) {
            res = true;
            break;
        }
        ++slistit;
    }

    return res;
}

TString DecodeFromHTML(const TString& text) {
    TString res = "";
    const char* p = nullptr;
    const char* pfind = nullptr;
    TWStrokaList slist;
    TWStrokaListIt slistit;
    bool exists = false;

    slist.push_back(TWStroka("&quot;", "\""));
    slist.push_back(TWStroka("&lt;", "<"));
    slist.push_back(TWStroka("&gt;", ">"));
    slist.push_back(TWStroka("&#39;", "\'"));
    slist.push_back(TWStroka("&amp;", "&"));
    slist.push_back(TWStroka("&nbsp;", " "));
    slist.push_back(TWStroka("&ndash;", "-"));

    p = text.c_str();
    if (IsHTML(slist, p)) {
        while ((*p) != 0x00) {
            if ((*p) == '&') {
                exists = false;
                slistit = slist.begin();
                while (slistit != slist.end()) {
                    if (strlen(p) >= (*slistit).key.length()) {
                        pfind = strstr(p, (*slistit).key.c_str());
                        if (p == pfind) {
                            res += (*slistit).value;
                            p += (*slistit).key.length();
                            exists = true;
                            break;
                        }
                    }
                    ++slistit;
                }
                if (exists)
                    continue;
            }
            res += (*p);

            p++;
        }
    } else {
        res = text;
    }
    slist.clear();

    return res;
}

bool TransToProbel(char symb) {
    bool res = false;
    unsigned char uc = 0;

    memcpy(&uc, &symb, sizeof(uc));
    if ((symb > 0) && (symb <= 32))
        res = true;
    else {
        switch (symb) {
            case '.':
            case ',':
            case ':':
            case ';':
            case '=':
            case '/':
            case '\'':
            case '\\':
            case '+':
            case ')':
            case '(':
            case '>':
            case '<':
            case '}':
            case '{':
            case ']':
            case '[':
            case '|':
            case '\"':
                res = true;
                break;
        };
    }

    return res;
}

ui32 GetCountWord(TString& text) {
    ui32 res = 0;
    bool predprobel = true;

    for (unsigned int i = 0; i < text.size(); i++) {
        if (!TransToProbel(text[i]) && predprobel) {
            res++;
            predprobel = false;
        }
        if (TransToProbel(text[i]))
            predprobel = true;
    }

    return res;
}

#ifndef _win_
bool ForceDirectories(const TString& dir) try {
    const size_t delimeter = dir.find(':');
    MakePathIfNotExist(dir.substr(0, delimeter).c_str());
    return true;
} catch (const yexception&) {
    return false;
}
#endif

TString GetRID(ui64 NumbRequest) {
    TString res = "";

    if (NumbRequest > 0)
        res = "##" + UI64ToStroka2(NumbRequest);
    else
        res = "-";

    return res;
}

bool IsHexSymbol(unsigned char uc) {
    bool res = false;

    if (((uc >= '0') && (uc <= '9')) || ((uc >= 'A') && (uc <= 'F')) || ((uc >= 'a') && (uc <= 'f')))
        res = true;

    return res;
}

TString ConvertTime(time_t t) {
    tm tmo;
    char BUFF[512];

    memset(BUFF, 0, sizeof(BUFF));
    tmo = *localtime(&t);
    strftime(BUFF, sizeof(BUFF) - 1, "%Y.%m.%d %H:%M:%S", &tmo);

    return TString(BUFF);
}

TString ConvertTime3(time_t t) {
    TString res = "";
    tm tmo;
    char BUFF[512];

    if (t != 0) {
        memset(BUFF, 0, sizeof(BUFF));
        tmo = *localtime(&t);
        strftime(BUFF, sizeof(BUFF) - 1, "%b %d %H:%M:%S", &tmo);

        res = TString(BUFF);
    } else {
        res = "-";
    }
    return res;
}

TString ConvertTimeExt(time_t t) {
    tm tmo;
    char BUFF[512];

    memset(BUFF, 0, sizeof(BUFF));
    tmo = *localtime(&t);
    strftime(BUFF, sizeof(BUFF) - 1, "(%Y-%m-%d-%H-%M-%S)", &tmo);

    return TString(BUFF);
}

TString ConvertData(time_t t) {
    tm tmo;
    char BUFF[512];

    memset(BUFF, 0, sizeof(BUFF));
    tmo = *localtime(&t);
    strftime(BUFF, sizeof(BUFF) - 1, "_%Y-%m-%d", &tmo);

    return TString(BUFF);
}

TString ConvertTime2(time_t t) {
    tm tmo;
    char BUFF[512];

    memset(BUFF, 0, sizeof(BUFF));
    tmo = *localtime(&t);
    strftime(BUFF, sizeof(BUFF) - 1, "%b %d %H:%M:%S", &tmo);

    return TString(BUFF);
}

TString IntToHourMinSec(ui32 value) {
    TString res = "";
    char BUFF[25];
    ui32 hour = 0, min = 0, sec = 0, tmp = 0;

    memset(BUFF, 0, sizeof(BUFF));
    if (value < 60) {
        snprintf(BUFF, sizeof(BUFF) - 1, "%u sec", value);
        res.assign(BUFF);
    } else if (value < 3600) {
        min = value / 60;
        sec = value % 60;
        snprintf(BUFF, sizeof(BUFF) - 1, "%u min %02u sec", min, sec);
        res.assign(BUFF);
    } else {
        hour = value / 3600;
        tmp = value % 3600;
        min = tmp / 60;
        sec = tmp % 60;
        snprintf(BUFF, sizeof(BUFF) - 1, "%02u:%02u:%02u", hour, min, sec);
        res.assign(BUFF);
    }

    return res;
}

TString GetTimePeriod(ui32 period) {
    TString res = "";
    ui32 day = 0, hour = 0, min = 0, sec = 0, temp = 0;

    if (period < 60) {
        res = IntToStroka(period) + " sec";

    } else if ((period >= 60) && (period < 3600)) {
        min = period / 60;
        sec = period % 60;
        res = IntToStroka2(min) + ":" + IntToStroka2(sec);

    } else if ((period >= 3600) && (period < 86400)) {
        hour = period / 3600;
        temp = period % 3600;
        min = temp / 60;
        sec = temp % 60;
        res = IntToStroka2(hour) + ":" + IntToStroka2(min) + ":" + IntToStroka2(sec);

    } else if (period >= 86400) {
        day = period / 86400;
        temp = period % 86400;
        hour = temp / 3600;
        temp = temp % 3600;
        min = temp / 60;
        sec = temp % 60;
        res = IntToStroka(day) + " " + IntToStroka2(hour) + ":" + IntToStroka2(min) + ":" + IntToStroka2(sec);
    }

    return res;
}

TString FormatHTMLPrint(char* mess, ui32 /*messsize*/) {
    TString res = "";
    char *pb = nullptr, *pe = nullptr;
    TString st = "", st1 = "";
    const char* p = nullptr;

    pb = mess;
    if (pb != nullptr) {
        pe = strstr(pb, "\n");
        while (pe != nullptr) {
            st = TString(pb, pe - pb);

            st1 = "";
            for (unsigned int i = 0; i < st.size(); i++) {
                switch (st[i]) {
                    case '&':
                        st1 = st1 + "&amp;";
                        break;
                    case '<':
                        st1 = st1 + "&lt;";
                        break;
                    case '>':
                        st1 = st1 + "&gt;";
                        break;
                    case '"':
                        st1 = st1 + "&quot;";
                        break;
                    default:
                        st1 = st1 + st[i];
                };
            }

            p = strstr(st1.c_str(), "MESSAGEID:");
            if (p != nullptr)
                st1 = "<font color='green'><b>" + st1 + "</b></font>";

            p = strstr(st1.c_str(), "subj:");
            if (p != nullptr)
                st1 = "<b>" + st1 + "</b>";

            res = res + st1 + "<br>";
            pb = pe + 1;
            pe = strstr(pb, "\n");
        }

        st = TString(pb);
        if (!st.empty()) {
            st1 = "";
            for (unsigned int i = 0; i < st.size(); i++) {
                switch (st[i]) {
                    case '&':
                        st1 = st1 + "&amp;";
                        break;
                    case '<':
                        st1 = st1 + "&lt;";
                        break;
                    case '>':
                        st1 = st1 + "&gt;";
                        break;
                    case '"':
                        st1 = st1 + "&quot;";
                        break;
                    default:
                        st1 = st1 + st[i];
                };
            }
            res = res + st1 + "<br>";
        }
    }

    return res;
}

TString GetIP(const TString& ip) {
    TString res = "";
    TString::const_iterator it;

    it = ip.begin();
    while (it != ip.end()) {
        if ((((*it) >= '0') && ((*it) <= '9')) || ((*it) == '.') || ((*it) == '\\') || ((*it) == '/'))
            res += (*it);

        ++it;
    }

    return res;
}

TString IntToHourMinSec2(ui32 value) {
    TString res = "";
    char BUFF[25];
    ui32 hour = 0, min = 0, sec = 0, tmp = 0;

    memset(BUFF, 0, sizeof(BUFF));
    if (value <= 99) {
        snprintf(BUFF, sizeof(BUFF) - 1, "%u", value);
        res.assign(BUFF);
    } else if (value < 3600) {
        min = value / 60;
        sec = value % 60;
        snprintf(BUFF, sizeof(BUFF) - 1, "%um", min);
        res.assign(BUFF);
    } else {
        hour = value / 3600;
        tmp = value % 3600;
        min = tmp / 60;
        sec = tmp % 60;
        snprintf(BUFF, sizeof(BUFF) - 1, "%uh", hour);
        res.assign(BUFF);
    }

    return res;
}

TString IntToIp(ui32 ip) {
    TString res = "";
    char buff[64];
    ui32 oct[4];

    memset(buff, 0, sizeof(buff));
    oct[0] = (ip >> 24) & 0xFF;
    oct[1] = (ip >> 16) & 0xFF;
    oct[2] = (ip >> 8) & 0xFF;
    oct[3] = ip & 0xFF;
    snprintf(buff, sizeof(buff) - 1, "%u.%u.%u.%u", oct[0], oct[1], oct[2], oct[3]);
    res = TString(buff);

    return res;
}

ui8 IncMax8(const ui8 value, const ui8 step) {
    ui8 res = 0;
    ui8 count = 0;
    ui8 stepn = 0;

    switch (step) {
        case 0:
            res = value;
            break;
        case 1:
            res = (value < 0xFF) ? (value + 1) : 0xFF;
            break;
        default:
            count = 0xFF - value;
            if (count > 0) {
                stepn = (step > count) ? count : step;
                res = value + stepn;
            } else
                res = value;
    };

    return res;
}

ui16 IncMax16(const ui16 value, const ui16 step) {
    ui16 res = 0;
    ui16 count = 0;
    ui16 stepn = 0;

    switch (step) {
        case 0:
            res = value;
            break;
        case 1:
            res = (value < 0xFFFF) ? (value + 1) : 0xFFFF;
            break;
        default:
            count = 0xFFFF - value;
            if (count > 0) {
                stepn = (step > count) ? count : step;
                res = value + stepn;
            } else
                res = value;
    };

    return res;
}

ui32 IncMax32(const ui32 value, const ui32 step) {
    ui32 res = 0;
    ui32 count = 0;
    ui32 stepn = 0;

    switch (step) {
        case 0:
            res = value;
            break;
        case 1:
            res = (value < 0xFFFFFFFF) ? (value + 1) : 0xFFFFFFFF;
            break;
        default:
            count = 0xFFFFFFFF - value;
            if (count > 0) {
                stepn = (step > count) ? count : step;
                res = value + stepn;
            } else
                res = value;
    };

    return res;
}

ui64 IncMax64(const ui64 value, const ui64 step) {
    ui64 res = 0;
    ui64 count = 0;
    ui64 stepn = 0;
    ui64 max_value = -1;

    switch (step) {
        case 0:
            res = value;
            break;
        case 1:
            //res = (value < 0xFFFFFFFFFFFFFFFF) ? (value + 1) : 0xFFFFFFFFFFFFFFFF;
            res = (value < max_value) ? (value + 1) : max_value;
            break;
        default:
            //count = 0xFFFFFFFFFFFFFFFF - value;
            count = max_value - value;
            if (count > 0) {
                stepn = (step > count) ? count : step;
                res = value + stepn;
            } else
                res = value;
    };

    return res;
}

ui32 Minus32(const ui32 value, const ui32 step) {
    ui32 res = 0;

    if (step >= value)
        res = 0;
    else
        res = value - step;

    return res;
}

ui64 Minus64(const ui64 value, const ui64 step) {
    ui64 res = 0;

    if (step >= value)
        res = 0;
    else
        res = value - step;

    return res;
}

i16 IncMax16_i(const i16 value, const i16 step) {
    i16 res = 0;
    ui16 count = 0;
    ui16 stepn = 0;
    i16 max_value = std::numeric_limits<i16>::max();
    i16 min_value = std::numeric_limits<i16>::min() + 1;

    //суммируем
    switch (step) {
        case 0:
            res = value;
            break;
        case 1:
            res = (value < max_value) ? (value + 1) : max_value;
            break;
        case -1:
            res = (value > min_value) ? (value - 1) : min_value;
            break;
        default:
            if (step > 0) {
                count = max_value - value;
                if (count > 0) {
                    stepn = (step > count) ? count : step;
                    res = value + stepn;
                } else
                    res = value;
            } else {
                count = value - min_value;
                if (count > 0) {
                    i16 step_t = -1 * step;

                    stepn = (step_t > count) ? count : step_t;
                    res = value - stepn;
                } else
                    res = value;
            }
    };

    return res;
}

i64 IncMax64_i(const i64 value, const i64 step) {
    i64 res = 0;
    i64 count = 0;
    ui64 stepn = 0;
    i64 max_value = std::numeric_limits<i64>::max();
    i64 min_value = std::numeric_limits<i64>::min() + 1;

    //суммируем
    switch (step) {
        case 0:
            res = value;
            break;
        case 1:
            res = (value < max_value) ? (value + 1) : max_value;
            break;
        case -1:
            res = (value > min_value) ? (value - 1) : min_value;
            break;
        default:
            if (step > 0) {
                count = max_value - value;
                if (count > 0) {
                    stepn = (step > count) ? count : step;
                    res = value + stepn;
                } else
                    res = value;
            } else {
                count = value - min_value;
                if (count > 0) {
                    i64 step_t = -1 * step;

                    stepn = (step_t > count) ? count : step_t;
                    res = value - stepn;
                } else
                    res = value;
            }
    };

    return res;
}

//multi-language function

enum TKLangType { KLANG_RU,
                  KLANG_KZ,
                  KLANG_UA,
                  KLANG_BG,
                  KLANG_UNKNOWN };

TKLangType GetLanguageType(TString lang) {
    TKLangType res = KLANG_UNKNOWN;

    if (lang == "RU")
        res = KLANG_RU;
    else if (lang == "KZ")
        res = KLANG_KZ;
    else if (lang == "UA")
        res = KLANG_UA;
    else if (lang == "BG")
        res = KLANG_BG;

    return res;
}

float CompareLoginEng(const TString& login1, const TString& login2) {
    size_t min = login1.size();
    size_t max = login2.size();
    if(max < min)
        std::swap(min, max);

    if(min == 0)
        return 0;

    int res{};
    for (size_t i = 0; i < min; i++) {
        const int pr1 = login1[i];
        const int pr2 = login2[i];
        const int rasn = std::abs(pr1 - pr2);
        ui8 flag = 0;

        if (((pr1 == 48) && (pr2 == 57)) || ((pr1 == 57) && (pr2 == 48))) {
            flag = 1;
            if (i >= 1) {
                const int rasn2 = login1[i - 1] - login2[i - 1];
                if (rasn2 == 1 || rasn2 == -1)
                    flag = 2;
            }
        }

        if (rasn == 0) {
            res += 2;
        } else if (flag == 1) {
            res += 1;
        } else if (flag == 2) {
            res += 2;
        } else if ((rasn > 0) && (rasn <= 3)) {
            res += 1;
        }
    }
    return float(res) / ( 2 * max);
}

TString GetOnlySymbols1251RU(TString str) {
    TString res = "";

    for (unsigned int i = 0; i < str.size(); i++)
        if (Is1251SymbolRU(str[i]))
            res = res + str[i];

    return res;
}

bool GetOtherSymbolsEng(TString s) {
    bool res = false;
    int digits_count = 0, all_size = 0;

    digits_count = GetDigitsLoginCountEng(s);
    all_size = (unsigned int)s.size();
    if ((all_size - digits_count) > 0)
        res = true;

    return res;
}

ui8 GetOtnGigitsToSizeEng(TString s) {
    ui8 res = 0;
    float otn = 0;
    ui8 digcount = 0;

    digcount = GetDigitsLoginCountEng(s);
    if (s.size() > 0)
        otn = (float)digcount / (float)s.size();
    if (otn == 0)
        res = 0;
    else if ((otn > 0) && (otn < 0.33))
        res = 1;
    else if ((otn >= 0.33) && (otn < 0.66))
        res = 2;
    else if (otn >= 0.66)
        res = 3;

    return res;
}

bool IsConstanantsKEng(char symb) {
    bool flag = false;

    if ((symb >= 'A') && (symb <= 'Z'))
        flag = true;
    if ((symb >= 'a') && (symb <= 'z'))
        flag = true;
    if (flag) {
        switch (symb) {
            case 'a':
            case 'o':
            case 'u':
            case 'i':
            case 'e':
            case 'y':
            case 'A':
            case 'O':
            case 'U':
            case 'I':
            case 'E':
            case 'Y':
                flag = false;
                break;
        }
    }
    return flag;
}

bool IsVowelsKEng(char symb) {
    bool flag = false;

    switch (symb) {
        case 'a':
        case 'o':
        case 'u':
        case 'i':
        case 'e':
        case 'y':
        case 'A':
        case 'O':
        case 'U':
        case 'I':
        case 'E':
        case 'Y':
            flag = true;
            break;
    }
    return flag;
}

ui8 GetPairConstanantsVowelsEng(TString login) {
    ui8 res = 0, res1 = 0, res2 = 0;
    char symb1 = 0, symb2 = 0;

    for (unsigned int i = 1; i < login.size(); i++) {
        symb1 = login[i - 1];
        symb2 = login[i];
        if (IsConstanantsKEng(symb1) && IsVowelsKEng(symb2)) {
            res1++;
            i++;
        }
    }
    for (unsigned int i = 1; i < login.size(); i++) {
        symb1 = login[i - 1];
        symb2 = login[i];
        if (IsVowelsKEng(symb1) && IsConstanantsKEng(symb2)) {
            res2++;
            i++;
        }
    }
    if (res1 > res2)
        res = res1;
    else
        res = res2;

    return res;
}

ui16 GetConstanantsDigitsSerialCountEng(TString s) {
    ui16 res, tek;
    bool flag;

    res = 0;
    tek = 0;
    for (unsigned int i = 0; i < s.length(); i++) {
        flag = false;
        if ((s[i] >= 'A') && (s[i] <= 'Z'))
            flag = true;
        if ((s[i] >= 'a') && (s[i] <= 'z'))
            flag = true;
        if ((s[i] >= '0') && (s[i] <= '9'))
            flag = true;
        if (flag) {
            switch (s[i]) {
                case 'a':
                case 'o':
                case 'u':
                case 'i':
                case 'e':
                case 'y':
                case 'A':
                case 'O':
                case 'U':
                case 'I':
                case 'E':
                case 'Y':
                    flag = false;
                    break;
            }
        }
        if (flag) {
            tek++;
            if (tek > res)
                res = tek;
        } else {
            if (tek > res)
                res = tek;
            tek = 0;
        }
    }
    return res;
}

ui8 GetDigitsLoginCountEng(TString s) {
    ui8 res;

    res = 0;
    for (unsigned int i = 0; i < s.length(); i++) {
        if ((s[i] >= '0') && (s[i] <= '9'))
            res++;
    }
    return res;
}

ui8 GetTypeExtRU(TString s) {
    ui8 res = 0;
    ui8 type = 0;

    type = GetTypeName1251RU(s);

    if ((type == 4) || (type == 5) || (type == 6))
        res = 1;
    else if ((type == 1) || (type == 2) || (type == 3))
        res = 2;
    else
        res = 0;

    return res;
}

ui8 GetTypeName1251RU(TString name) {
    ui8 res = 0;
    bool first_upper_rus1251 = true;
    bool first_lower_rus1251 = true;
    bool first_upper_eng = true;
    bool first_lower_eng = true;
    bool upper_rus1251 = true;
    bool lower_rus1251 = true;
    bool upper_eng = true;
    bool lower_eng = true;
    unsigned char symb = 0;
    char symbs = 0;

    for (unsigned int i = 0; i < name.size(); i++) {
        symbs = name[i];
        memcpy(&symb, &symbs, sizeof(symb));
        if (i == 0) //first symbol
        {
            if (!Upper_rus1251_symbol(symb))
                first_upper_rus1251 = false;
            if (!Lower_rus1251_symbol(symb))
                first_lower_rus1251 = false;
            if (!Upper_eng_symbol(symb))
                first_upper_eng = false;
            if (!Lower_eng_symbol(symb))
                first_lower_eng = false;
        } else // next symbols
        {
            if (!Upper_rus1251_symbol(symb))
                upper_rus1251 = false;
            if (!Lower_rus1251_symbol(symb))
                lower_rus1251 = false;
            if (!Upper_eng_symbol(symb))
                upper_eng = false;
            if (!Lower_eng_symbol(symb))
                lower_eng = false;
        }
    }

    if (first_upper_rus1251 && lower_rus1251)
        res = 1;
    else if (first_lower_rus1251 && lower_rus1251)
        res = 2;
    else if (first_upper_rus1251 && upper_rus1251)
        res = 3;
    else if (first_upper_eng && lower_eng)
        res = 4;
    else if (first_lower_eng && lower_eng)
        res = 5;
    else if (first_upper_eng && upper_eng)
        res = 6;

    return res;
}

ui16 GetVowelsSerialCountEng(TString s) {
    ui16 res, tek;
    bool flag;

    res = 0;
    tek = 0;
    for (unsigned int i = 0; i < s.length(); i++) {
        switch (s[i]) {
            case 'a':
            case 'o':
            case 'u':
            case 'i':
            case 'e':
            case 'y':
            case 'A':
            case 'O':
            case 'U':
            case 'I':
            case 'E':
            case 'Y':
                flag = true;
                break;
            default:
                flag = false;
        }
        if (flag) {
            tek++;
            if (tek > res)
                res = tek;
        } else {
            if (tek > res)
                res = tek;
            tek = 0;
        }
    }
    return res;
}

bool Is1251SymbolRU(char symbi) {
    bool res = false;
    unsigned char symb = 0;

    memcpy(&symb, &symbi, sizeof(symb));
    if ((symb >= 0xC0) && (symb <= 0xDF)) //А .. Я
        res = true;
    else if (symb == 0xA8) //Ё
        res = true;
    else if ((symb >= 0xE0) && (symb <= 0xFF)) //а .. я
        res = true;
    else if (symb == 0xB8) //ё
        res = true;
    else if ((symb >= 'A') && (symb <= 'Z')) //A .. Z
        res = true;
    else if ((symb >= 'a') && (symb <= 'z')) //a .. z
        res = true;

    return res;
}

ui16 GetConstanantsSerialCountEng(TString s) {
    ui16 res, tek;
    bool flag;

    res = 0;
    tek = 0;
    for (unsigned int i = 0; i < s.length(); i++) {
        flag = false;
        if ((s[i] >= 'A') && (s[i] <= 'Z'))
            flag = true;
        if ((s[i] >= 'a') && (s[i] <= 'z'))
            flag = true;

        if (flag) {
            switch (s[i]) {
                case 'a':
                case 'o':
                case 'u':
                case 'i':
                case 'e':
                case 'y':
                case 'A':
                case 'O':
                case 'U':
                case 'I':
                case 'E':
                case 'Y':
                    flag = false;
                    break;
            }
        }
        if (flag) {
            tek++;
            if (tek > res)
                res = tek;
        } else {
            if (tek > res)
                res = tek;
            tek = 0;
        }
    }
    return res;
}

TString CompareTranslit(TString s1, TString s2, int count, bool& res, TString lang) {
    TString sres = "";

    res = false;
    switch (GetLanguageType(lang)) {
        case KLANG_RU:
            sres = CompareTranslitRU(s1, s2, count, res);
            break;
        case KLANG_KZ:
            sres = CompareTranslitKZ(s1, s2, count, res);
            break;
        case KLANG_UA:
            sres = CompareTranslitRU(s1, s2, count, res);
            break;
        case KLANG_BG:
            sres = CompareTranslitRU(s1, s2, count, res);
            break;
        case KLANG_UNKNOWN:
            sres = CompareTranslitRU(s1, s2, count, res);
            break;
    };

    return sres;
}

//bool Is1251Symbol(char symbi, TString lang) {
//    bool res = false;
//
//    switch (GetLanguageType(lang)) {
//        case KLANG_RU:
//            res = Is1251Symbol(symbi, lang);
//            break;
//        case KLANG_KZ:
//            res = Is1251Symbol(symbi, lang);
//            break;
//        case KLANG_UA:
//            res = Is1251Symbol(symbi, lang);
//            break;
//        case KLANG_BG:
//            res = Is1251Symbol(symbi, lang);
//            break;
//        case KLANG_UNKNOWN:
//            res = Is1251Symbol(symbi, lang);
//            break;
//    };
//
//    return res;
//}

TString GetOnlySymbols1251(TString str, TString lang) {
    TString res = "";

    switch (GetLanguageType(lang)) {
        case KLANG_RU:
            res = GetOnlySymbols1251RU(str);
            break;
        case KLANG_KZ:
            res = GetOnlySymbols1251RU(str);
            break;
        case KLANG_UA:
            res = GetOnlySymbols1251RU(str);
            break;
        case KLANG_BG:
            res = GetOnlySymbols1251RU(str);
            break;
        case KLANG_UNKNOWN:
            res = GetOnlySymbols1251RU(str);
            break;
    };

    return res;
}

ui8 GetTypeName1251(TString name, TString lang) {
    ui8 res = 0;

    switch (GetLanguageType(lang)) {
        case KLANG_RU:
            res = GetTypeName1251RU(name);
            break;
        case KLANG_KZ:
            res = GetTypeName1251RU(name);
            break;
        case KLANG_UA:
            res = GetTypeName1251RU(name);
            break;
        case KLANG_BG:
            res = GetTypeName1251RU(name);
            break;
        case KLANG_UNKNOWN:
            res = GetTypeName1251RU(name);
            break;
    };

    return res;
}

ui8 GetTypeExt(TString s, TString lang) {
    ui8 res = 0;

    switch (GetLanguageType(lang)) {
        case KLANG_RU:
            res = GetTypeExtRU(s);
            break;
        case KLANG_KZ:
            res = GetTypeExtRU(s);
            break;
        case KLANG_UA:
            res = GetTypeExtRU(s);
            break;
        case KLANG_BG:
            res = GetTypeExtRU(s);
            break;
        case KLANG_UNKNOWN:
            res = GetTypeExtRU(s);
            break;
    };

    return res;
}

int CreateTranslitList(const TString& source, TKFuncStrokaList& reslist) {
    char symb = 0, symb2 = 0;
    ui8 usymb = 0, usymb2 = 0;
    TString sw1 = source;
    TString token[5];
    ui8 tokencount = 0;
    TKFuncStrokaList *mainlist = nullptr, *templist = nullptr;
    TKFuncStrokaListIt mit, tit, it;
    TString sprefix = "", s = "";
    unsigned int scount = 0;

    if (!sw1.empty()) {
        to_lower_k(sw1);
        scount = (unsigned int)sw1.size();

        for (unsigned int i = 0; i < scount; i++) {
            symb = sw1[i];
            memcpy(&usymb, &symb, sizeof(symb));
            tokencount = 0;
            if ((usymb >= 0x61) && (usymb <= 0x7A)) //a .. z
            {
                token[0] = TString(symb);
                tokencount = 1;
            } else { //а .. я
                switch (usymb) {
                    case 0xE0: //а
                        token[0] = "a";
                        tokencount = 1;
                        break;
                    case 0xE1: //б
                        token[0] = "b";
                        tokencount = 1;
                        break;
                    case 0xE2: //в
                        token[0] = "v";
                        tokencount = 1;
                        break;
                    case 0xE3: //г
                        token[0] = "g";
                        tokencount = 1;
                        break;
                    case 0xE4: //д
                        token[0] = "d";
                        tokencount = 1;
                        break;
                    case 0xE5: //е
                        token[0] = "e";
                        tokencount = 1;
                        break;
                    case 0xE6: //ж
                        token[0] = "zh";
                        token[1] = "j";
                        token[2] = "g";
                        tokencount = 3;
                        break;
                    case 0xE7: //з
                        token[0] = "z";
                        tokencount = 1;
                        break;
                    case 0xE8: //и
                        token[0] = "i";
                        tokencount = 1;
                        break;
                    case 0xE9: //й
                        token[0] = "y";
                        token[1] = "j";
                        tokencount = 2;
                        break;
                    case 0xEA: //к
                        token[0] = "k";
                        tokencount = 1;
                        if ((i + 1) < scount) {
                            symb2 = sw1[i + 1];
                            memcpy(&usymb2, &symb2, sizeof(symb2));
                            if (usymb2 == 0xF1) //с
                            {
                                token[0] = "x";
                                token[1] = "ks";
                                tokencount = 2;
                                i++;
                                if (scount < sw1.size())
                                    scount++;
                            }
                        }
                        break;
                    case 0xEB: //л
                        token[0] = "l";
                        tokencount = 1;
                        break;
                    case 0xEC: //м
                        token[0] = "m";
                        tokencount = 1;
                        break;
                    case 0xED: //н
                        token[0] = "n";
                        tokencount = 1;
                        break;
                    case 0xEE: //о
                        token[0] = "o";
                        tokencount = 1;
                        break;
                    case 0xEF: //п
                        token[0] = "p";
                        tokencount = 1;
                        break;
                    case 0xF0: //р
                        token[0] = "r";
                        tokencount = 1;
                        break;
                    case 0xF1: //с
                        token[0] = "s";
                        tokencount = 1;
                        break;
                    case 0xF2: //т
                        token[0] = "t";
                        tokencount = 1;
                        break;
                    case 0xF3: //у
                        token[0] = "u";
                        tokencount = 1;
                        break;
                    case 0xF4: //ф
                        token[0] = "f";
                        tokencount = 1;
                        break;
                    case 0xF5: //х
                        token[0] = "kh";
                        token[1] = "h";
                        token[2] = "x";
                        tokencount = 3;
                        break;
                    case 0xF6: //ц
                        token[0] = "ts";
                        token[1] = "c";
                        tokencount = 2;
                        break;
                    case 0xF7: //ч
                        token[0] = "ch";
                        token[1] = "4";
                        tokencount = 2;
                        break;
                    case 0xF8: //ш
                        token[0] = "sh";
                        tokencount = 1;
                        break;
                    case 0xF9: //щ
                        token[0] = "shch";
                        token[1] = "sch";
                        tokencount = 2;
                        break;
                    case 0xFB: //ы
                        token[0] = "y";
                        token[1] = "i";
                        tokencount = 2;
                        break;
                    case 0xFD: //э
                        token[0] = "e";
                        tokencount = 1;
                        break;
                    case 0xFE: //ю
                        token[0] = "yu";
                        token[1] = "ju";
                        tokencount = 2;
                        break;
                    case 0xFF: //я
                        token[0] = "ya";
                        token[1] = "ja";
                        tokencount = 2;
                        break;
                    case 0xB8: //ё
                        token[0] = "e";
                        token[1] = "jo";
                        token[2] = "yo";
                        tokencount = 3;
                        break;
                    case 0xFA: //ъ
                    case 0xFC: //ь
                    default:
                        if (scount < sw1.size())
                            scount++;
                        continue;
                };
            }

            templist = new TKFuncStrokaList();
            if (mainlist == nullptr) {
                for (int i = 0; i < tokencount; i++) {
                    templist->push_back(token[i]);
                }
            } else {
                mit = mainlist->begin();
                while (mit != mainlist->end()) {
                    sprefix = *mit;
                    for (int i = 0; i < tokencount; i++) {
                        s = sprefix + token[i];
                        templist->push_back(s);
                    }
                    ++mit;
                }
            }
            if (mainlist != nullptr) {
                mainlist->clear();
                delete mainlist;
                mainlist = nullptr;
            }
            mainlist = templist;
            templist = nullptr;

            if ((mainlist != nullptr) && (mainlist->size() >= 16))
                break;
        }

        if (mainlist != nullptr) {
            s = "";
            it = mainlist->begin();
            while (it != mainlist->end()) {
                s = s + (*it) + "\n";
                reslist.push_back((*it));

                ++it;
            }

            delete mainlist;
            mainlist = nullptr;
        }
    }

    return reslist.size();
}

TString GetDomen2level(const TString& host) {
    TString res = host;
    int point_count = 0;
    bool est = false;

    if (!res.empty()) {
        ReverseInPlace(res);
        for (size_t i = 0; i < res.length(); i++) {
            if (res[i] == '.') {
                point_count++;
                if (point_count == 2) {
                    res = res.substr(0, i);
                    est = true;
                    break;
                }
            }
        }
        ReverseInPlace(res);
    }

    if (!est) //если host уже является доменом второго уровня, то ничего не возвращаем
        res = "";

    return res;
}

TString GetDomen3level(const TString& host) {
    TString res = host;
    int point_count = 0;
    bool est = false;

    if (!res.empty()) {
        ReverseInPlace(res);
        for (size_t i = 0; i < res.length(); i++) {
            if (res[i] == '.') {
                point_count++;
                if (point_count == 3) {
                    res = res.substr(0, i);
                    est = true;
                    break;
                }
            }
        }
        ReverseInPlace(res);
    }
    if (!est) //если host уже является доменом третьего уровня, то ничего не возвращаем
        res = "";

    return res;
}

ui64 ShingleFromStroka(const TStringBuf& s) {
    return FnvHash<ui64>(s.data(), s.size());
}

ui64 ShingleFromStroka2(const char* ptr, size_t len) {
    if ((ptr != nullptr) && (len > 0)) {
        return FnvHash<ui64>(ptr, len);
    }

    return 0;
}
