#pragma once

#include <sys/stat.h>
#include <sys/types.h>
#include <time.h>
#include <list>
#include <limits>
#include <library/cpp/charset/doccodes.h>

#include "sputil.h"

typedef std::list<TString> TKFuncStrokaList;
typedef TKFuncStrokaList::iterator TKFuncStrokaListIt;

// check  use util/string/cast.h::ToString !
void to_lower_k(TString& value);
void to_upper_k(TString& value);
TString IntToStroka(int value);
TString IntToStrokaDash(int value);
TString IntToStrokaDash2(int value);
TString IntToStrokaLimited(int value);
TString IntToStrokaWithProbel(int value, size_t ProbelCount);
TString IntToStrokaS(int value);
TString IntToStroka2(int value);
//TString IntToStroka2o(int value);
TString IntToStroka3(int value);
TString IntToStrokaNum(int value);
TString IntToStroka4D(int value);
TString IntToStroka4(int value);
TString I64ToStroka(i64 value);
TString UI64ToStroka(ui64 value);
TString UI64ToStrokaNum(ui64 value);
TString UI64ToStroka2(ui64 value);
TString ShingleToStroka(ui64 value);
TString ShingleToStroka24(ui64 value);
TString ShingleToStroka0x(ui64 value);
TString ShingleToStroka2(ui64 value);
TString ShingleToStroka3(ui64 value);
TString ShingleToStroka8(ui64 value);
TString BoolToStroka(bool value);
TString BoolToStroka2(bool value);
TString BoolToStroka3(bool value);
TString BoolToStroka4(bool value);
TString BoolToStroka5(bool value);
TString ui32ToStroka(ui32 value);
TString UI32ToStroka(ui32 value);
TString ui32ToBinary(ui32 value);
TString UI64ToBinary(const ui64 value);
TString FilemaskToBinary(ui32 value);
TString ui8ToBinary(ui8 value);
TString UnPack32(ui32 value);
TString UnPack64(ui64 value);
TString UnPack64Compat(ui64 value);
TString DoubleToStr(double value);
TString FloatToStr(float value);
TString FloatToStr0(float value);
TString FloatToStr2(float value);
TString FloatToStr5(float value);
TString TimeToStr(time_t t);
TString TimeToStr2(time_t t);
TString TimeToStrNoProbel(time_t t);
TStringBuf Trim(TStringBuf s);
//ui32    Pack32_str(TString &s);                      //упаковка строки вида x.x.x.x в 32 битное значение
//ui64    Pack64_str(TString &s);                      //упаковка строки вида x.x.x.x.x.x.x.x в 64 битное значение
ui32 Pack32_str2(const TString& s);                     //упаковка строки вида x.x.x.x в 32 битное значение
ui64 Pack64_str2(const TString& s);                     //упаковка строки вида x.x.x.x.x.x.x.x в 64 битное значение
ui8 GetVowelsCount(const TString& s);                   //вернуть число гласных в строке
ui16 GetConstanantsSerialCountExt(const TString& s);    //вернуть макс.размер последовательности, состоящей из подряд идущих согласных (с русскими буквами)
ui16 GetConstanantsDigitsSerialCount(const TString& s); //вернуть макс.размер последовательности, состоящей из подряд идущих согласных и цифр
ui16 GetVowelsSerialCount(TString s);                   //вернуть макс.размер последовательности, состоящей из подряд идущих гласных
ui16 GetVowelsSerialCountExt(const TString& s);         //вернуть макс.размер последовательности, состоящей из подряд идущих гласных (с русскими буквами)
TStringBuf GetLoginPrefix(const TStringBuf& s);                      //вернуть префикс (часть строки до первого символа)
size_t GetDigitsLoginCount(const TStringBuf& s);                     //вернуть число цифр в строке
bool GetOtherSymbols(TString s);                        //(true - есть) наличие других символов (в том числе и пробела) за исключением цифр
float CompareLogin(TString login1, TString login2);     //сравнить две строки (возвращает степень похожести по хитрому алгоритму)
ui8 GetPairConstanantsVowels(TString login);            //вернуть число пар согласная/гласная или гласная/согласная - чего больше в строке
bool Is1251Symbol(char symbi);                          //возвращает true, если это символ кодировки 1251
TString GetOnlySymbols1251(TString str);                //вырезает из строки все символы, не принадлежащие символам кодировки 1251
TString ModifyHint(TString hint);                 //меняет хинт следующим образом 9.0.9.0 -> 1.0.1.0 или 0.5.0.5 -> 0.1.0.1
bool Upper_rus1251_symbol(unsigned char symb);          //true - прописной русский символ в кодировке 1251
bool Lower_rus1251_symbol(unsigned char symb);          //true - строчный русский символ в кодировке 1251
bool Upper_eng_symbol(unsigned char symb);              //true - прописной английский символ
bool Lower_eng_symbol(unsigned char symb);              //true - строчный английский символ
ui8 GetTypeName1251(TString name);                      //возвращает тип имени
ui8 GetOtnGigitsToSize(TString s);                      //отношение числа цифр к длине логина (0- 0, 1 - до 33%, 2 - 33-66%, 3 - 66-100%)
ui8 GetTypeExt(TString s);                              //тип имени(можно привязаться к  имеющимся типам  тогда типы 4,5,6 дадут 1; 1,2,3 -  2; а ни один из них - 0)

//TString  CompareTranslit(TString s1, TString s2, int count, bool &res); //сравнение первых count символов строки s1 со строкой s2 (если s1 - кириллица, используем транслит, приводим обе строки к нижнему регистру). Возвращает совпавшие строки
TString CompareTranslitRU(const TString& s1, const TString& s2, unsigned int count, bool& res); //сравнение первых count символов строки s1 со строкой s2 (если s1 - кириллица, используем транслит, приводим обе строки к нижнему регистру). Возвращает совпавшие строки

TString RemoveCR(const TString& s);

ui64 GetShingle(const TString& text);
TString EncodeToHTML(const TString& text);
TString DecodeFromHTML(const TString& text);
ui32 GetCountWord(TString& text);

#ifndef _win_
bool ForceDirectories(const TString& dir);
#endif

TString GetRID(ui64 NumbRequest);
bool IsHexSymbol(unsigned char uc); //true - символ лежит в пределах 0-9 или A-Z(a-z)

TString ConvertTime(time_t t);
TString ConvertTime3(time_t t);
TString ConvertTimeExt(time_t t);
TString ConvertData(time_t t);
TString ConvertTime2(time_t t);
TString IntToHourMinSec(ui32 value);
TString GetTimePeriod(ui32 period);

TString FormatHTMLPrint(char* mess, ui32 messsize);

TString GetIP(const TString& ip);
TString IntToHourMinSec2(ui32 value);
TString IntToIp(ui32 ip);

template <typename T, bool DisSigned>
struct TSafeOp;

template <typename T>
struct TSafeOp<T, false> {
    static void Inc(T& value, T step) {
        if (std::numeric_limits<T>::max() - value > step)
            value += step;
        else
            value = std::numeric_limits<T>::max();
    }
    static void Dec(T& value, T step) {
        if (std::numeric_limits<T>::min() + step < value)
            value -= step;
        else
            value = std::numeric_limits<T>::min();
    }
};

template <typename T>
void Inc(T& value, T step = T(1)) {
    return TSafeOp<T, std::numeric_limits<T>::is_signed>::Inc(value, step);
}
template <typename T>
void Dec(T& value, T step = T(1)) {
    return TSafeOp<T, std::numeric_limits<T>::is_signed>::Dec(value, step);
}

ui8 IncMax8(const ui8 value, const ui8 step);
ui16 IncMax16(const ui16 value, const ui16 step);
ui32 IncMax32(const ui32 value, const ui32 step);
ui64 IncMax64(const ui64 value, const ui64 step);
ui32 Minus32(const ui32 value, const ui32 step);
ui64 Minus64(const ui64 value, const ui64 step);
i16 IncMax16_i(const i16 value, const i16 step);
i64 IncMax64_i(const i64 value, const i64 step);

float CompareLoginEng(const TString& login1, const TString& login2); //сравнить две строки (возвращает степень похожести по хитрому алгоритму)
ui16 GetConstanantsDigitsSerialCountEng(TString s);                  //вернуть макс.размер последовательности, состоящей из подряд идущих согласных и цифр
ui8 GetDigitsLoginCountEng(TString s);                               //вернуть число цифр в строке
TString GetOnlySymbols1251RU(TString str);                           //вырезает из строки все символы, не принадлежащие символам кодировки 1251
bool GetOtherSymbolsEng(TString s);                                  //(true - есть) наличие других символов (в том числе и пробела) за исключением цифр
ui8 GetOtnGigitsToSizeEng(TString s);                                //отношение числа цифр к длине логина (0- 0, 1 - до 33%, 2 - 33-66%, 3 - 66-100%)
ui8 GetPairConstanantsVowelsEng(TString login);                      //вернуть число пар согласная/гласная или гласная/согласная - чего больше в строке
ui8 GetTypeExtRU(TString s);                                         //тип имени(можно привязаться к  имеющимся типам  тогда типы 4,5,6 дадут 1; 1,2,3 -  2; а ни один из них - 0)
ui16 GetConstanantsSerialCountEng(TString s);                        //вернуть макс.размер последовательности, состоящей из подряд идущих согласных
ui8 GetTypeName1251RU(TString name);                                 //возвращает тип имени
ui16 GetVowelsSerialCountEng(TString s);                             //вернуть макс.размер последовательности, состоящей из подряд идущих гласных
bool Is1251SymbolRU(char symbi);                                     //возвращает true, если это символ кодировки 1251

//multilanguage function
TString CompareTranslit(TString s1, TString s2, int count, bool& res, TString lang); //сравнение первых count символов строки s1 со строкой s2 (если s1 - кириллица, используем транслит, приводим обе строки к нижнему регистру). Возвращает совпавшие строки
TString GetOnlySymbols1251(TString str, TString lang); //вырезает из строки все символы, не принадлежащие символам кодировки 1251
ui8 GetTypeName1251(TString name, TString lang);       //возвращает тип имени
ui8 GetTypeExt(TString s, TString lang);               //тип имени(можно привязаться к  имеющимся типам  тогда типы 4,5,6 дадут 1; 1,2,3 -  2; а ни один из них - 0)

int CreateTranslitList(const TString& source, TKFuncStrokaList& reslist);

TString GetDomen2level(const TString& host);
TString GetDomen3level(const TString& host);

ui64 ShingleFromStroka(const TStringBuf& s);
ui64 ShingleFromStroka2(const char* ptr, size_t len);

