#include "multicounter.h"

bool TMultiCounter::Next() {
    size_t * previousCounter = nullptr;
    for (size_t i = 0; i < Size; i++) {
        const size_t limit = Limits[i];
        if (limit) {
            if (size_t *counter = &Counters[i]; *counter < limit - 1) {
                (*counter)++;
                if (previousCounter) {
                    *previousCounter = 0;
                }
                return true;
            } else {
                previousCounter = counter;
            }
        }
    }
    return false;
}

const TVector<size_t> &TMultiCounter::GetCounters() {
    return Counters;
}

TMultiCounter::TMultiCounter(TVector<size_t> limits)
        : Size(limits.size()), Counters(limits.size(), 0), Limits(std::move(limits)) {
}
