#pragma once

#include <util/generic/string.h>
#include <util/system/defaults.h>
#include <util/string/cast.h>
#include <library/cpp/json/json_value.h>


TStringBuf Parseout(TStringBuf sSource, const TStringBuf& sBegin, const TStringBuf& sEnd, size_t offset = 0);

void CheckForSelfSentMessage(const TString & mfrm, const TString & rcpt, bool* bSameEmail, bool* bSameDomain, int* rcptCnt = 0);

class TTextSplitter {
public:
    struct TSplitResult {
        TUtf16String word;

        bool has_digit{}, has_2_or_more_digits{};
        bool has_latin{}, has_cyrillic{};

    };

    TTextSplitter(const char* clear_utf8_text, size_t len, size_t maxWords);
    bool FindNextWord();
    const TSplitResult& Get() const;

private:
    bool tryFindWord();

private:
    const size_t maxWords;
    size_t wordsNumber;

    const char* text = nullptr;
    const unsigned char *start = nullptr, *end = nullptr;

    TSplitResult current;
};

class TFrom {
public:
    TFrom() = default;
    explicit TFrom(TStringBuf from);

    TFrom(TString name, TString addr) noexcept
    : Name(std::move(name))
    , Addr(std::move(addr)) {}

    friend IOutputStream& operator<<(IOutputStream& s, const TFrom& from);

    [[nodiscard]] const TString &GetName() const { return Name; }

    [[nodiscard]] const TString &GetAddr() const { return Addr; }

private:
    TString Name, Addr;
};

TString FixAddress(const TStringBuf& addr);
