#pragma once

#include <util/datetime/base.h>
#include "parsers.h"

class TCgiParameters;
namespace NJson {
    class TJsonValue;
}

class TReceipt {
private:
    TReceipt(TInstant timestamp, size_t dataSize, TString from, TString formId) noexcept
    : Timestamp(timestamp)
    , DataSize(dataSize)
    , From(std::move(from))
    , FormId(std::move(formId)) {}

public:
    TReceipt() = default;

    TString ToJson() const;

    TString CompressAndBase64() const;

    static std::pair<TReceipt, NJson::TJsonValue> Unbase64AndDecompress(const TStringBuf &data);

    size_t GetDataSize() const { return DataSize; }
    TInstant GetTimestamp() const { return Timestamp; }

    static TReceipt FromJson(const NJson::TJsonValue &json);

    static TReceipt MakeReceipt(const TCgiParameters &cgi);

    friend IOutputStream& operator<<(IOutputStream& stream, const TReceipt& receipt);

private:
    TInstant Timestamp{};
    size_t DataSize{};
    TFrom From;
    TString FormId;
};

