#pragma once

#include "regexp.h"

#include <util/string/join.h>
#include <library/cpp/testing/unittest/registar.h>

namespace NRegexp {

    namespace NTest {
        template<class TExpression>
        void Match() {
            {
                TMatches matches;
                TExpression expr("(\\w+):(\\d+)");

                UNIT_ASSERT_EQUAL(expr.Match("ruby:1234", 100, matches), EMatchResult::Match);
                UNIT_ASSERT_EQUAL_C(matches.size(), 3, matches.size());
                UNIT_ASSERT_EQUAL(matches[0], "ruby:1234");
                UNIT_ASSERT_EQUAL_C(TString{matches[1]}, "ruby", matches[1]);
                UNIT_ASSERT_EQUAL_C(TString{matches[2]}, "1234", matches[2] << ' ' << matches[2].size());

                UNIT_ASSERT_EQUAL(expr.Match("ruby", 100, matches), EMatchResult::NotMatch);
                UNIT_ASSERT_EQUAL(expr.Match("ruby"), EMatchResult::NotMatch);
            }
            {
                TMatches matches;
                TExpression expr("([a-z]+){2}");

                UNIT_ASSERT_EQUAL(expr.Match("\"abcabc@ya.ru>", 100, matches), EMatchResult::Match);
                UNIT_ASSERT_EQUAL(expr.Match("\"abcabc@ya.ru>"), EMatchResult::Match);
            }
            {
                TMatches matches;
                TExpression expr("(?im)^[a-z][a-z \\r\\n-]*[a-z](?:,\\s*[a-z][a-z \\r\\n-]*[a-z])*$");

                UNIT_ASSERT_EQUAL(expr.Match("arial, helvetica, sans-serif"), EMatchResult::Match);
            }
            {
                TMatches matches;
                TExpression expr("(?im)(?:^|(\\.))([-\\w]+\\.[-\\w]+)$");

                UNIT_ASSERT_EQUAL(expr.Match("bis-education.ru", 20, matches), EMatchResult::Match);
                UNIT_ASSERT_EQUAL(expr.Match("bis-education.ru"), EMatchResult::Match);
            }
            {
                TMatches matches;
                TExpression expr("(?m)\\/[a-zA-Z0-9\\/=?&._-]{46}");

                UNIT_ASSERT_EQUAL(expr.Match("budnizi.ru/web.php", 20, matches), EMatchResult::NotMatch);
                UNIT_ASSERT_EQUAL(expr.Match("budnizi.ru/web.php"), EMatchResult::NotMatch);
            }
            {
                TMatches matches;
                TExpression expr("(?m)([-+])(\\d\\d)(\\d\\d)$");

                UNIT_ASSERT_EQUAL(expr.Match("+0300", 20, matches), EMatchResult::Match);
                UNIT_ASSERT_EQUAL(expr.Match("+0300"), EMatchResult::Match);
            }

        }
    }
}
