#include <util/charset/utf8.h>
#include <library/cpp/charset/recyr.hh>
#include <mail/so/libs/syslog/so_log.h>
#include "safe_recode.h"

TString SafeRecode(const TStringBuf &src, TMaybe<ECharset> preferedEncode) {
    const TString s(src);
    if (!IsUtf(s)) {
        if (preferedEncode) {
            try {
                return Recode(*preferedEncode, CODES_UTF8, s);
            } catch (...) {
                Syslog(TLOG_WARNING) << CurrentExceptionMessage();
            }
        }

        for (ECharset charset: {CODES_KOI8, CODES_WIN}) {
            try {
                return Recode(charset, CODES_UTF8, s);
            } catch (...) {
                Syslog(TLOG_WARNING) << CurrentExceptionMessage();
            }
        }
    }
    return s;
}
