#include "shconn.h"
#include <util/string/cast.h>
#include <util/stream/tee.h>
#include "sobase64.h"
#include <library/cpp/string_utils/quote/quote.h>

IOutputStream & operator<<(IOutputStream & s, const TParamItem & p) {
    s << p.name() << '=' << CGIEscapeRet(TStringBuf(p.data(), p.datasize()));
    return s;
}

IOutputStream & operator<<(IOutputStream & s, const TParametrsList & paramlist) {
    if(!paramlist.empty()) {
        auto p = paramlist.cbegin();
        s << *p;
        for(++p; p != paramlist.cend(); ++p)
            s << '&' << *p;
    }
    return s;
}

TString MakeCGIString(const TParametrsList & params) {
    TStringStream s;
    s << params;
    return s.Str();
}
