#pragma once

#include <util/generic/string.h>
#include <util/generic/list.h>

class TParamItem {
private:
    TString m_name;
    TString m_data;

public:
    TParamItem() = default;
    TParamItem(TString name, TString data) noexcept : m_name(std::move(name)), m_data(std::move(data)) {}

    const TString & name() const {
        return m_name;
    }
    const char* data() const {
        return m_data.c_str();
    }
    ui32 datasize() const {
        return static_cast<ui32>(m_data.size());
    }
};

struct THeaderItem {
    TString name;
    TString value;

    THeaderItem(TString _name, TString _value) noexcept
        : name(std::move(_name))
        , value(std::move(_value))
    {
    }
};

typedef TList<TParamItem> TParametrsList;
typedef TParametrsList::iterator TParametrsListIt;

typedef TList<THeaderItem> THeadersList;

IOutputStream & operator<<(IOutputStream & s, const TParamItem & p);
IOutputStream & operator<<(IOutputStream & s, const TParametrsList & params);
TString MakeCGIString(const TParametrsList & params);

