#pragma once

#include <util/generic/deque.h>
#include <util/generic/hash_set.h>
#include <library/cpp/json/json_value.h>
#include <library/cpp/logger/log.h>
#include <mail/so/libs/primitives/types.h>
#include <mail/so/api/so_api.pb.h>
#include "so_class.h"


struct TCheckMessageReport{
    TCheckMessageReport() = default;

    double Hits{}, DlvHits{};

    Y_SAVELOAD_DEFINE(Hits, DlvHits);
};

struct TCheckedMessage {
    class TAsLegacy;
    class TUidsResolutionsPrinter;

    static constexpr const TStringBuf ANSWER_TAG = "SODAEMON";
    static constexpr const TStringBuf REJECT_TAG = "REJECT";
    static constexpr const TStringBuf REJECTSTR_TAG = "REJECTSTR";
    static constexpr const TStringBuf SPAM_TAG = "SPAM";
    static constexpr const TStringBuf SPAMSTR_TAG = "SPAMSTR";
    static constexpr const TStringBuf UID_ACTIVE_TAG = "X-Yandex-UID-Active";
    static constexpr const TStringBuf EMPTY_ANSWER = "SODAEMON 0";
    static constexpr const TStringBuf SPAMPERS_TAG = "SPAMPERS";

    TCheckedMessage() = default;
    explicit TCheckedMessage(TSpClass spClass, TDeque<TUid> uids, TDeque<TSuid> suids)
            : spClass(spClass)
            , Uids(std::move(uids))
            , Suids(std::move(suids)) {}

    TCheckedMessage(TDeque<TUid> uids, TDeque<TSuid> suids)
            : TCheckedMessage(TSpClass::UNKNOWN, std::move(uids), std::move(suids)) {}

    [[nodiscard]] TAsLegacy AsLegacy(bool printPersonalReslutions) const;
    [[nodiscard]] TUidsResolutionsPrinter UidsPrinter() const;
    [[nodiscard]] mail::so::api::v1::SoResponse AsSoResponse(bool addDlvLog, const TLog& logger) const;
    void SetResHamAndAllNotPfResSpam();

    void CombineWith(TCheckedMessage&& another);

    Y_SAVELOAD_DEFINE(
            spClass,
            Uids,
            Suids,
            Report,
            ShouldLogForKaspersky,
            UidsActivities,
            SuidsWithPf,
            UidsWithPf,
            DenyGreyListing,
            SoClass,
            ForeignZone,
            MXCode,
            UidsResolutions,
            Reject,
            RejectStr,
            Mailish
    );

    TSpClass spClass = TSpClass::UNKNOWN;
    TDeque<TUid> Uids;
    TDeque<TSuid> Suids;
    TCheckMessageReport Report;
    bool ShouldLogForKaspersky{};
    THashMap<TUid, int> UidsActivities{};
    THashSet<TSuid> SuidsWithPf{};
    THashSet<TUid> UidsWithPf{};
    bool DenyGreyListing{};
    THashSet<TString> SoClass{};
    TString ForeignZone;
    TString MXCode;
    THashMap<TUid, TSpClass> UidsResolutions{};
    int Reject{};
    TString RejectStr;
    TDeque<TDeque<std::pair<TString, TString>>> DlvLog;
    bool Mailish{};
    bool TempFail{};
};

class TCheckedMessage::TAsLegacy {
private:
    const TCheckedMessage& Master;
    bool PrintPersonalResolutions{};
public:
    TAsLegacy(const TCheckedMessage& master, bool printPersonalResolutions) noexcept
    : Master(master)
    , PrintPersonalResolutions(printPersonalResolutions) {}

    friend IOutputStream& operator<<(IOutputStream& stream, const TAsLegacy& checked);
};

class TCheckedMessage::TUidsResolutionsPrinter {
private:
    const TCheckedMessage& Master;
public:
    explicit TUidsResolutionsPrinter(const TCheckedMessage& master) noexcept
        : Master(master) {}

    friend IOutputStream& operator<<(IOutputStream& stream, const TUidsResolutionsPrinter& checked);
    [[nodiscard]] NJson::TJsonValue AsJson() const;
};
