#pragma once

#include <util/system/defaults.h>

enum class TSpClass {
    UNKNOWN = 0 /* "NO" */,
    HAM = 1 /* "NO" */,
    DLVR = 2 /* "DLVR" */,
    SPAM = 4 /* "YES" */,
    MALIC = 256 /* "MALIC" */,
};

constexpr bool IsSpam(TSpClass type) {
    return type == TSpClass::MALIC || type == TSpClass::SPAM;
}

constexpr bool IsHam(TSpClass type) {
    return type == TSpClass::HAM || type == TSpClass::DLVR || type == TSpClass::UNKNOWN;
}

constexpr TSpClass Opposite(TSpClass type) {
    if(IsHam(type)) {
        return TSpClass::SPAM;
    } else {
        return TSpClass::HAM;
    }
}