#pragma once

#include <util/folder/path.h>
#include <library/cpp/logger/priority.h>
#include <library/cpp/logger/element.h>
#include <library/cpp/json/writer/json.h>
#include "json_util.h"

class TKasperskyLogFormatter {
public:
    TKasperskyLogFormatter(
            TStringBuf email,
            TStringBuf connect,
            TStringBuf helo,
            TStringBuf mailfrom,
            const TVector<TString>& rcpts) noexcept
            : Email(email)
            , Connect(connect)
            , Helo(helo)
            , Mailfrom(mailfrom)
            , Rcpts(rcpts) {}

    friend NJsonWriter::TBuf& PrintJson(const TKasperskyLogFormatter& v, NJsonWriter::TBuf &json) {
        json.BeginObject();

        json.WriteKey("email").WriteString(v.Email);
        json.WriteKey("connect").WriteString(v.Connect);
        json.WriteKey("helo").WriteString(v.Helo);
        json.WriteKey("mailfrom").WriteString(v.Mailfrom);
        json.WriteKey("rcpt");
        json << v.Rcpts;

        json.EndObject();
        return json;
    }

private:
    const TStringBuf Email;
    const TStringBuf Connect, Helo, Mailfrom;
    const TVector<TString>& Rcpts;
};
