#pragma once

#include <util/digest/fnv.h>
#include <util/generic/hash.h>
#include <util/generic/list.h>
#include <util/generic/deque.h>
#include <util/datetime/systime.h>

#include <library/cpp/logger/backend.h>

#include <optional>
#include <vector>
#include <map>
#include <util/system/getpid.h>
#include <util/datetime/base.h>
#include <util/system/rusage.h>
#include <util/generic/buffer.h>
#include <util/generic/maybe.h>
#include <util/system/rwlock.h>
#include <util/generic/hash_set.h>
#include <mail/so/libs/primitives/types.h>
#include <mail/so/libs/html_sanitizer_misc/html_sanitizer_misc.h>
#include <library/cpp/langs/langs.h>
#include <library/cpp/charset/doccodes.h>
#include "so_class.h"
#include "exp_boxes.h"

bool calc_strcrc64(const TStringBuf & b, char str[32]);
bool calc_strcrc64(const char* pbuf, size_t len, char str[32]);

#define MAX_STR_PID 32

#define DELETE_OBJ(obj) \
    {                   \
        if (obj) {      \
            delete obj; \
            obj = nullptr; \
        }               \
    }
#define DELETE_ARR(arr)   \
    {                     \
        if (arr) {        \
            delete[] arr; \
            arr = nullptr;   \
        }                 \
    }
#define DELETE_FP(fp)   \
    {                   \
        if (fp) {       \
            fclose(fp); \
            fp = 0;     \
        }               \
    }

#define SET_STR_NULL(str) str[sizeof(str) - 1] = 0

#define STRNCMP(str1, str2) strncmp(str1, str2, strlen(str2))
#define STRNICMP(str1, str2) strnicmp(str1, str2, strlen(str2))

template <class T>
void STRDUP(T** tdst, const T* tsrc, size_t count) {
    *tdst = new T[count + 1];
    memcpy(*tdst, tsrc, count * sizeof(T));
    (*tdst)[count] = 0;
    return;
}

void STRDUPLWR(char** dst, const char* src, size_t count);

struct TRemoveForbiddenChars{
    explicit TRemoveForbiddenChars(const TString & s) : s(s) {}
    const TString & s;
};
IOutputStream & operator << (IOutputStream & s, const TRemoveForbiddenChars & r);

bool IsNumber(char* sztext);
bool IsNumber(const char* ptext, int len);
bool IsInt(const char* ptext, int len);
bool IsInt(const char* ptext);
bool GetInt(const char* ptext, int len, int* pval);
bool GetDouble(const char* pstr, int len, double* d);
int GetDigitTextLen(const unsigned char* ptext);
//   bool IsSpace (ui8 c);

//trasform dd.mm.yy in time_t
// 20 - 12 - 2005
// 20-12-2005
// 20.12.2005
// return 0 in error case
time_t GetDayMonthYear(const char* str, int len);
time_t GetDayMonthYear(const char* str);

//trasform mm.dd.yy in time_t
// time_t
// 10 - 22 - 2005
// 10-22-2005
// 10.22.2005
// return 0 in error case
time_t GetMonthDayYear(const char* str, int len);
time_t GetMonthDayYear(const char* str);

//trasform yy.mm.dd in time_t
// time_t
// 2005 - 10 - 22
// 2005-10-22
// 2005.10.22
// return 0 in error case
time_t GetYearMonthDay(const char* str, int len);
time_t GetYearMonthDay(const char* str);

// !!! strSource - nullptr - terminated string
// if length of strSource >= DestSize then copy (DestSize - 1) bytes only
// and return strDest closed by 0.
char* STRNCPY(char* strDest, const char* strSource, size_t DestSize);
char* STRNCPY(char* strDest, const char* strSource, size_t DestSize, size_t count);
char* STRNCPYLWR(char* strDest, const char* strSource, size_t DestSize);
char* STRNCPYLWR(char* strDest, const char* strSource, size_t DestSize, size_t count);
char* APPENDSTR(char* strDest, const char* strSource, size_t DestSize, size_t count);
char* GetStrPid(char* str);
bool StrToHex(const ui8* str, int len, ui32* val);
void CheckDirSlash(char* dirname);
void CheckDirSlash(TString& dirname);
bool IpToInt(const char* pstr, int len, ui32* pnet, ui32* pip);
int str_remove(char* str, int len, char* prem, int lenrem);
int str_remove(char* str, int len, char* prem, char* premend);
char* rot13(const char* strsrc, char* strout);
void SpTrim(const char* szText, const char** pp, int* plen);
void SpSkipSpaces(const char** ppstr);
bool SpIsNotSpace(char ch);
void SpSkipWord(const char** ppstr);
bool SpEnd_Of_Str(char ch);
int SpGetFirstWord(const char** ppstr, const char** ppnextword);
int SpGetNextWord(const char** ppstr, const char** ppnextword);
const char* IntToIp(ui32 ip, char sip[]);
bool cmpdomensrevi(const TStringBuf& subdomen, const TStringBuf& domen);

class SpPerformance {
public:
    void StartPerformance() {
//        TWriteGuard g(lock);
//        usageStart.Fill();
    }

    ui64 GetPerformance() const {
        return {};
//        TReadGuard g(lock);
//        return (TRusage::Get().Utime - usageStart.Utime).MicroSeconds();
    }

private:
    TRWMutex lock;
    TRusage usageStart;
};

//#ifdef WIN32
#ifndef xdigit
#define xdigit(c) (isdigit(c) ? (c) - '0' : islower(c) ? (c) - 'a' + 10 : (c) - 'A' + 10)
#endif

bool GetFullName(TString& sFullName, const TStringBuf& d, const TStringBuf& n, TString& errorStr);
bool GetDirByFileName(TString& sDirName, const TStringBuf& fn);

FILE* SpFileOpen(const char* dn, const char* szName, const char* option, TString& errorStr);
FILE* SpFileOpen(const char* fn, const char* option, bool fMessage, TString& errorStr);

//class TFileLogBackend;
TLogBackend * SpFileOpenLog(const TString &name, bool fMessage, TString &errorStr);
bool SpGetFileSize(const char* fn, ui32* size, TString& errorStr);

struct TFileStat;
TMaybe<TFileStat> FileStateWasChanged(const TStringBuf& fn, const TFileStat & oldStat, TString& errorStr);

// CurTime - buffer, buflen - CurTime length
void SpCurTimeStr(char* CurTime, int buflen, const char* tag);


struct TPidPrinter {
    TPidPrinter() = default;
    explicit TPidPrinter(TProcessId pid) : pid(pid) {}

    const TProcessId pid = GetPID();
};
IOutputStream & operator << (IOutputStream & s, const TPidPrinter & printer);

struct TCurTimeAndPid {
    TCurTimeAndPid() = default;
    TCurTimeAndPid(TInstant now, TProcessId pid) : now(now), pidPrinter(pid) {}

    const TInstant now = Now();
    const TPidPrinter pidPrinter{};
};
IOutputStream& operator<<(IOutputStream& s, const TCurTimeAndPid& p);

bool GetLogin(TString& sLogin, const char* login);

struct TTextAdder{
    TTextAdder(TStringBuf text, char delim) : text(text), delim(delim) {}

    const TStringBuf text;
    const char delim;
};
TStringStream& operator<<(TStringStream& stream, const TTextAdder& ta);

TStringBuf GetDomain(const TStringBuf & login);
bool IsYandexDomain(const TStringBuf& domain);

struct TSoPersonal {
    TSpClass fromto = TSpClass::UNKNOWN;
    TSpClass complaint = TSpClass::UNKNOWN;
    int compl_spam = 0;
    int compl_ham = 0;
};

class rcptattrs {
public:
    rcptattrs() noexcept = default;
    explicit rcptattrs(TSuid suid) noexcept
    : sSuid(std::move(suid)) {};

    rcptattrs(bool abook, TSuid suid, int cnt)
    : aBook(abook)
    , sSuid(std::move(suid))
    , iCnt(cnt){}

    friend IOutputStream& operator<<(IOutputStream& s, const rcptattrs& attr) {
        return s << attr.sUid << ' ' << attr.sSuid << ' ' << (void*)attr.sender;
    }

    const TUid* RobustUid() const {
        if(sUid) {
            return &sUid;
        }
        if(sender && sender->Uid) {
            return &sender->Uid;
        }
        return nullptr;
    }

    void SetSUID(TSuid suid) {
        sSuid = std::move(suid);
    }

    void SetUID(TUid uid) {
        sUid = std::move(uid);
    }

    void SetActivity(int daysSinceActive) {
        iDaysSinceActive = daysSinceActive;
    }

    void SetBornDate(TString bornDate) {
        BornDate = std::move(bornDate);
    }

    void SetTriade(bool abook, TUid uid, int cnt) {
        aBook = abook;
        sUid = std::move(uid);
        iCnt = cnt;
    }

    void SetCountry(TString country) {
        sCountry = std::move(country);
    }

    bool aBook{};
    TSuid sSuid{"0"};
    TUid sUid;
    TString BornDate;
    std::optional<TExpBoxes> ExpBoxes;
    int iCnt{};
    TString sCountry;
    int iDaysSinceActive = -1;
    TSoPersonal pres_personal;
    const NHtmlSanMisc::TSender* sender{};
};

typedef THashMap<TLogin, rcptattrs> M_RCPT_ATTRS;

TStringBuf IsHttp(TStringBuf url);
TStringBuf IsMailto(TStringBuf url);

ptrdiff_t GetCharsNumBeforeSpace(const char *pText, int Len);

ptrdiff_t GetCharsNumBeforeSpace(const char *pText);

TStringBuf StringAfter(const TStringBuf& text, const TStringBuf& part);

template<class T, class S>
IOutputStream& operator<<(IOutputStream& stream, const std::pair<T, S>& pair) {
    return stream << pair.first << ':' << pair.second;
}

ECharset GetDestinationEncoding(ELanguage lang);
