
#include "stats_consumer.h"

TString YasmTagFromComment(const TStringBuf & comment) {
    TString tag(comment);
    std::replace(tag.begin(), tag.begin() + tag.size(), '/', '-');
    return tag;
}

TStatsConsumerLock::TStatsConsumerLock(TStatsConsumer& consumer, TString name)
    : name(std::move(name)), consumer(consumer)
{ }

void TStatsConsumerLock::Acquire() {
    prof.Start();
}

void TStatsConsumerLock::Release() {
    prof.Stop();
    consumer.Add(name, prof);
}

