#include "tag_sets.h"
#include <contrib/libs/re2/re2/re2.h>

namespace NTagSets {
    namespace NHelpers {
        TRegexpReplaceImpl::TRegexpReplaceImpl(const TString& from, const TString& to)
            : TRegexpReplaceImpl(std::make_pair(from, to))
        { }

        TRegexpReplaceImpl::TRegexpReplaceImpl(const TReplaceItem& item)
            : TRegexpReplaceImpl(TReplaceInfo(1, item))
        { }

        TRegexpReplaceImpl::TRegexpReplaceImpl(const TReplaceInfo& info) {
            for (const auto& item :info) {
                m_info.emplace_back(MakeHolder<RE2>(item.first), MakeHolder<re2::StringPiece>(item.second));
            }
        }

        TRegexpReplaceImpl::~TRegexpReplaceImpl() { }

        template<typename T>
        static TString ReplaceAll(TString value, const T& info) {
            for (const auto& item : info) {
                while (RE2::Replace(&value, *item.first, *item.second)) {}
            }
            return value;
        }

        THashSet<TString> TRegexpReplaceImpl::Replace(const THashSet<TString>& data) const {
            if (m_info.empty())
                return data;

            THashSet<TString> result;
            for (const auto& item : data) {
                result.insert(ReplaceAll(item, m_info));
            }
            return result;
        }
    }
}
