#include "tanswerparser.h"

//**********************************************************************************************************************************
//                                                        TAnswerParser
//**********************************************************************************************************************************

TAnswerParser::TAnswerParser() {
}

TAnswerParser::~TAnswerParser() {
}

bool TAnswerParser::ParseAnswer(const char* p_answer, size_t answer_size, TAnswerParseItemVector& data) {
    return ParseAnswer(TStringBuf(p_answer, answer_size), data);
}

//find template <head:body> in data
bool GetNextMessage(TStringBuf& data, TStringBuf& head, TStringBuf& body) {
    size_t start = data.find('<');
    size_t delimiter = data.find(':', start + 1);
    size_t end = data.find('>', delimiter + 1);

    if (end == TStringBuf::npos || start + 1 == delimiter || delimiter + 1 == end)
        return false;

    head = TStringBuf(data, start + 1, delimiter - start - 1);
    body = TStringBuf(data, delimiter + 1, end - delimiter - 1);
    data.Skip(end + 1);
    return true;
}

bool TAnswerParser::ParseAnswer(TStringBuf answer, TAnswerParseItemVector& data) {
    TString dummy;
    TStringBuf head, body;
    TAnswerParseItem api;
    TAnswerParseItemVector result;

    while (GetNextMessage(answer, head, body)) {
        api.Clear();
        if (pStrokaToHashMapBase(body.data(), body.size(), api.m_data, dummy)) {
            api.m_ident = head;
            result.push_back(api);
        }
    }

    data.swap(result);
    return true;
}

//**********************************************************************************************************************************
