#pragma once

#ifndef tanswerparser_H
#define tanswerparser_H

#include "anyvalue.h"
#include <vector>

//**********************************************************************************************************************************
//                                                        TAnswerParser
//**********************************************************************************************************************************

struct TAnswerParseItem {
    TString m_ident;
    nosql::HashMap m_data;

    void Clear() {
        m_ident = "";
        m_data.clear();
    }
};

typedef std::vector<TAnswerParseItem> TAnswerParseItemVector;
typedef TAnswerParseItemVector::iterator TAnswerParseItemVectorIt;

class TAnswerParser {
public:
    TAnswerParser();
    ~TAnswerParser();

    bool ParseAnswer(const char* p_answer, size_t answer_size, TAnswerParseItemVector& data);
    bool ParseAnswer(TStringBuf answer, TAnswerParseItemVector& data);
};

//**********************************************************************************************************************************

#endif
