#include "tanswerparser.h"

#include <library/cpp/testing/unittest/registar.h>

Y_UNIT_TEST_SUITE(TestAnswerParser) {
    Y_UNIT_TEST(AnyValue) {
        nosql::HashMap data;
        data["int"] = 1;
        data["double"] = 3.14;
        data["stroka"] = "<text:text>";

        const TString result = nosql::HashMapToStrokaBase(data);
        UNIT_ASSERT_EQUAL(result, "double=#3'3.14'&int=#1'1'&stroka=#5'%3Ctext%3Atext%3E'&");
    }

    Y_UNIT_TEST(AnyValueRecode) {
        nosql::HashMap data;
        data["int"] = 1;
        data["double"] = 3.14;
        data["stroka"] = "<text:text>";

        const TString text = nosql::HashMapToStrokaBase(data);

        TString dummy;
        nosql::HashMap decode_data;
        UNIT_ASSERT_EQUAL(nosql::StrokaToHashMapBase(text, decode_data, dummy), true);
        UNIT_ASSERT_EQUAL(decode_data, data);
    }

    void CheckHashMap(const nosql::HashMap& data) {
        UNIT_ASSERT_EQUAL(data.size(), 2);

        nosql::HashMap::const_iterator it = data.begin();
        UNIT_ASSERT_EQUAL(it->first, "double");
        UNIT_ASSERT_EQUAL(it->second, 3.14);

        ++it;
        UNIT_ASSERT_EQUAL(it->first, "int");
        UNIT_ASSERT_EQUAL(it->second, 1);
    }

    Y_UNIT_TEST(Simple) {
        const TString text = "<first:int=#1'1'&double=#3'3.14'&>";

        TAnswerParser parser;
        TAnswerParseItemVector result;

        parser.ParseAnswer(text, result);

        UNIT_ASSERT_EQUAL(result.size(), 1);
        UNIT_ASSERT_EQUAL(result.front().m_ident, "first");
        CheckHashMap(result.front().m_data);
    }

    Y_UNIT_TEST(Limited) {
        const TString text = "<first:int=#1'1'&double=#3'3.14'&><second:int=#1'1'&double=#3'3.14'&>";

        TAnswerParser parser;
        TAnswerParseItemVector result;

        parser.ParseAnswer(text.c_str(), 34, result);

        UNIT_ASSERT_EQUAL(result.size(), 1);
        UNIT_ASSERT_EQUAL(result.front().m_ident, "first");

        CheckHashMap(result.front().m_data);
    }

    Y_UNIT_TEST(TwoItem) {
        const TString text = "<first:int=#1'1'&double=#3'3.14'&><second:int=#1'1'&double=#3'3.14'&>";

        TAnswerParser parser;
        TAnswerParseItemVector result;

        parser.ParseAnswer(text, result);

        UNIT_ASSERT_EQUAL(result.size(), 2);
        UNIT_ASSERT_EQUAL(result[0].m_ident, "first");
        UNIT_ASSERT_EQUAL(result[1].m_ident, "second");

        CheckHashMap(result[0].m_data);
        CheckHashMap(result[1].m_data);
    }

    Y_UNIT_TEST(Garbage) {
        const TString text = "<first:int=#1'1'&double=#3'3.!!!!!!!!!!!'&><second:int=#1'1'&double=#3'3.14'&><third:int=#1'1'asdf&double=#3'3.14'&>";

        TAnswerParser parser;
        TAnswerParseItemVector result;

        parser.ParseAnswer(text, result);

        UNIT_ASSERT_EQUAL(result.size(), 1);
        UNIT_ASSERT_EQUAL(result.front().m_ident, "second");

        CheckHashMap(result.front().m_data);
    }
}
