#include "tbasestoragetypes.h"

namespace stor_bt {

    TString TStorageActionTypeToStroka(TStorageActionType value)
    {
          TString res = "";

          switch (value)
          {
          case SAT_UPDATE:
                                    res = "SAT_UPDATE";
                                    break;
          case SAT_FINDONE:
                                    res = "SAT_FINDONE";
                                    break;
          case SAT_ERASE:
                                    res = "SAT_ERASE";
                                    break;
          case SAT_SIZE:
                                    res = "SAT_SIZE";
                                    break;
          case SAT_MULTYACTION:
                                    res = "SAT_MULTYACTION";
                                    break;
          case SAT_FIND:
                                    res = "SAT_FIND";
                                    break;
          case SAT_CLEAR:
                                    res = "SAT_CLEAR";
                                    break;
          case SAT_FINDANDMODIFY:
                                    res = "SAT_FINDANDMODIFY";
                                    break;
          case SAT_DROPTABLE:
                                    res = "SAT_DROPTABLE";
                                    break;
          case SAT_CREATETABLE:
                                    res = "SAT_CREATETABLE";
                                    break;
          };

          return res;
    }

    TString TShingleStorageTypeToStroka(TShingleStorageType value)
    {
          TString res = "";

          switch (value)
          {
                case SST_USRCOLL_UNKNOWN:
                                            res = "SST_USRCOLL_UNKNOWN";
                                            break;
                case SST_USRCOLL_ASTEXT:
                                            res = "SST_USRCOLL_ASTEXT";
                                            break;
                case SST_USRCOLL_01:
                                            res = "SST_USRCOLL_01";
                                            break;
                case SST_USRCOLL_02:
                                            res = "SST_USRCOLL_02";
                                            break;
                case SST_USRCOLL_03:
                                            res = "SST_USRCOLL_03";
                                            break;
                case SST_USRCOLL_04:
                                            res = "SST_USRCOLL_04";
                                            break;
                case SST_USRCOLL_05:
                                            res = "SST_USRCOLL_05";
                                            break;
                case SST_USRCOLL_06:
                                            res = "SST_USRCOLL_06";
                                            break;
                case SST_USRCOLL_07:
                                            res = "SST_USRCOLL_07";
                                            break;
                case SST_STAT:
                                            res = "SST_STAT";
                                            break;
          };

          return res;
    }

    //**********************************************************************************************************************************************
    //                                                   TNoSqlItem
    //**********************************************************************************************************************************************

    TNoSqlItem::TNoSqlItem()
    {
        clear();
    }

    TNoSqlItem::TNoSqlItem(ui64 shingleA, int typeA)
    {
         shingle = shingleA;
         type = typeA;
         clear();
    }

    TNoSqlItem::~TNoSqlItem()
    {

    }

    void TNoSqlItem::clear()
    {
         incrs.clear();
         sets.clear();
         hash.clear();
    }

    bool TNoSqlItem::Valid()
    {
         if (shingle != 0)
            return true;
         else
            return false;
    }

    TString TNoSqlItem::ShingleS()
    {
        return ShingleToStroka(shingle);
    }

    TString TNoSqlItem::TypeS()
    {
        return IntToStroka(type);
    }

    bool TNoSqlItem::Empty()
    {
        return hash.empty();
    }

    bool TNoSqlItem::RequestEmpty()
    {
         bool res = true;

         if ((!incrs.empty()) || (!sets.empty()))
            res = false;

         return res;
    }

    TString TNoSqlItem::toLog()
    {
        TString res = "";

        res += "shingle:" + ShingleS() + ";";
        res += "sets:"  + HashMapToStrokaBase(sets) + ";";
        res += "incrs:" + HashMapToStrokaBase(incrs) + ";";
        res += "hash:"  + HashMapToStrokaBase(hash) + ";";

        return res;
    }

    //**********************************************************************************************************************************************
    //                                                 TConstructError
    //**********************************************************************************************************************************************

    TConstructError::TConstructError()
    {
        Clear();
    }

    void TConstructError::Clear()
    {
         err = false;
         err_text = "";
    }

    void TConstructError::PrintErrToLog(ui64 shingle, int type, const TString &functionA, TLogsGroupBase *LogsGroupA)
    {
         if (err)
         {
            if ((LogsGroupA != NULL) && (LogsGroupA->GetServerLog() != NULL))
                LogsGroupA->GetServerLog()->WriteMessageAndDataStatus(KERROR, "STOR: Negativ value: shingle=0x%016llx-%d, func='%s', errtext='%s'", shingle, type, functionA.c_str(), err_text.c_str());
         }
    }

    //**********************************************************************************************************************************************
    //                                                 TStorageActionList
    //**********************************************************************************************************************************************

    TStorageActionItem::TStorageActionItem()
    {
        m_action       = stor_bt::SAT_FINDONE;
        m_storage_type = stor_bt::SST_USRCOLL_UNKNOWN;
        m_storage_name = "";
        m_err          = NULL;
        m_tick         = NULL;
        m_nosqldata    = NULL;
    }

    TStorageActionItem::TStorageActionItem(TStorageActionType actionA, TShingleStorageType storage_typeA, TNoSqlItem *nosqldataA, bool *errA, ui32 *tickA)
    {
         m_action       = actionA;
         m_storage_type = storage_typeA;
         m_storage_name = "";
         m_err          = errA;
         m_tick         = tickA;
         m_nosqldata    = nosqldataA;
    }

    TStorageActionItem::TStorageActionItem(TStorageActionType actionA, const TString &storage_nameA, TNoSqlItem *nosqldataA, bool *errA, ui32 *tickA)
    {
         m_action = actionA;
         m_storage_type = SST_USRCOLL_ASTEXT;
         m_storage_name = storage_nameA;
         m_err = errA;
         m_tick = tickA;
         m_nosqldata = nosqldataA;
    }

    void TStorageActionItem::Clear()
    {
         if (m_nosqldata != NULL)
         {
              delete m_nosqldata;
              m_nosqldata = NULL;
         }
    }

    TString TStorageActionItem::toLog()
    {
        TString res = "";

        res += "act=" + TStorageActionTypeToStroka(m_action) + "|";
        if (m_storage_type == SST_USRCOLL_ASTEXT)
            res += "stortype=" + m_storage_name + "|";
        else
            res += "stortype=" + TShingleStorageTypeToStroka(m_storage_type) + "|";
        if (m_err != NULL)
            res += "err=" + BoolToStroka2(*m_err) + "|";
        if (m_tick != NULL)
            res += "tick=" + IntToStroka(*m_tick) + "|";
        if (m_nosqldata != NULL)
            res += "nosqldata=" + m_nosqldata->toLog() + "|";

        return res;
    }

    //**********************************************************************************************************************************************
    //                                                   TStrorageNoSqlBase
    //**********************************************************************************************************************************************

    TStorageNoSqlBase::TStorageNoSqlBase()
    {
         LogsGroupB          = NULL;
         m_storage_type_name = "";
         m_storage_name  = "";
         m_otherdata   = "";
         m_storage_connect = false;
         m_storage_status    = "";
    }

    TStorageNoSqlBase::~TStorageNoSqlBase()
    {


    }

    NStorageStats::TStorageStatVector TStorageNoSqlBase::GetWebStat()
    {
        return webstat.GetWebStat();
    }

    NStorageStats::TStorageStatVector TStorageNoSqlBase::GetMonStat()
    {
        return monstat.GetMonStat();
    }


    //**********************************************************************************************************************************************

}
