#pragma once

#include <util/generic/string.h>
#include "anyvalue.h"
#include "eventhandler.h"
#include "tstoragerequeststat.h"
#include "tlogsgroupbase.h"
#include <list>

namespace stor_bt {

    enum TStorageActionType { SAT_UPDATE,
                              SAT_FINDONE,
                              SAT_ERASE,
                              SAT_SIZE,
                              SAT_MULTYACTION,
                              SAT_FIND,
                              SAT_CLEAR,
                              SAT_FINDANDMODIFY,
                              SAT_DROPTABLE,
                              SAT_CREATETABLE };
    enum TShingleStorageType { SST_USRCOLL_UNKNOWN,
                               SST_USRCOLL_ASTEXT,
                               SST_USRCOLL_01,
                               SST_USRCOLL_02,
                               SST_USRCOLL_03,
                               SST_USRCOLL_04,
                               SST_USRCOLL_05,
                               SST_USRCOLL_06,
                               SST_USRCOLL_07,
                               SST_STAT };

#define SERVER_IDENT_SID "srv_ident"      //server identificator
#define SERVER_NAME_SID "srv_name"        //server name
#define START_SERVER_TIME_SID "srv_start" //server start time
#define SERVER_VERSION_SID "srv_vers"     //server version

    TString TStorageActionTypeToStroka(TStorageActionType value);
    TString TShingleStorageTypeToStroka(TShingleStorageType value);

    //**********************************************************************************************************************************************
    //                                                   TNoSqlItem
    //**********************************************************************************************************************************************

    class TNoSqlItem {
    public:
        ui64 shingle;         //�����
        int type;             //���
        nosql::HashMap incrs; //���� ��� ����������
        nosql::HashMap sets;  //���� ��� ����
        nosql::HashMap hash;  //������ �� ����� �� ���� ������

    public:
        TNoSqlItem();
        TNoSqlItem(ui64 shingleA, int typeA);
        ~TNoSqlItem();

        void clear();
        bool Valid();
        TString ShingleS();
        TString TypeS();
        bool Empty();
        bool RequestEmpty();
        TString toLog();
    };

    //**********************************************************************************************************************************************
    //                                                 TConstructError
    //**********************************************************************************************************************************************

    struct TConstructError {
        bool err;
        TString err_text;

        TConstructError();

        void Clear();
        void PrintErrToLog(ui64 shingle, int type, const TString& functionA, TLogsGroupBase* LogsGroupA);
    };

    //**********************************************************************************************************************************************
    //                                                 TStorageActionList
    //**********************************************************************************************************************************************

    struct TStorageActionItem {
        TStorageActionType m_action;
        TShingleStorageType m_storage_type;
        TString m_storage_name;
        bool* m_err;
        ui32* m_tick;
        TNoSqlItem* m_nosqldata;

        TStorageActionItem();
        TStorageActionItem(TStorageActionType actionA, TShingleStorageType storage_typeA, TNoSqlItem* nosqldataA, bool* errA, ui32* tickA);
        TStorageActionItem(TStorageActionType actionA, const TString& storage_nameA, TNoSqlItem* nosqldataA, bool* errA, ui32* tickA);
        void Clear();

        TString toLog();
    };

    typedef std::list<TStorageActionItem> TStorageActionList;
    typedef TStorageActionList::iterator TStorageActionListIt;

    //*********************************************************************************************************************************
    //                                                    LoggerHandler
    //*********************************************************************************************************************************

    class LoggerHandler : public nosql::EventHandler {
        TLogsGroupBase* LogsGroup;

    public:
        LoggerHandler() {
            LogsGroup = nullptr;
        }

        void Init(TLogsGroupBase* LogsGroupA) {
            LogsGroup = LogsGroupA;
        }

        void Error(const TString& msg) override {
            if (LogsGroup)
                LogsGroup->GetServerLog()->WriteMessageAndDataStatus(KERROR, "Storage error: %s", msg.c_str());
        }

        void Info(const TString& msg) override {
            if (LogsGroup)
                LogsGroup->GetServerLog()->WriteMessageAndDataStatus(KINFO, "Storage info: %s", msg.c_str());
        }
    };

    namespace {
        stor_bt::LoggerHandler loghandler;
    }

    //**********************************************************************************************************************************************
    //                                                   TStorageNoSqlBase
    //**********************************************************************************************************************************************

    class TStorageNoSqlBase {
    public:
        TLogsGroupBase* LogsGroupB;

        //set in TStorageNoSql
        TString m_database_name;
        TString m_usercoll_01_name;
        TString m_usercoll_02_name;
        TString m_usercoll_03_name;
        TString m_usercoll_04_name;
        TString m_usercoll_05_name;
        TString m_usercoll_06_name;
        TString m_usercoll_07_name;
        TString m_statcoll_name;

        //set in StorageClient (TDataBasaMongoV3, TDataBasaPostgre, ...)
        TString m_storage_name;
        TString m_storage_type_name;
        TString m_otherdata;
        bool m_storage_connect;
        TString m_storage_status;

        NStorageStats::TStorageRequestStatMain webstat;
        NStorageStats::TStorageRequestStatMain monstat;

        virtual bool InitBeforeFork_base(int index, const TString& server_hostname, const TString& server_code, const TString& server_start_time, const TString& server_version, TLogsGroupBase* LogsGroupA, TKConfig* configobjA) = 0;
        virtual void InitAfterFork_base() = 0;
        virtual bool Midnight_base() = 0;
        virtual void EventTick_base() = 0;
        virtual void SetDatabaseAndCollectionNames() = 0;

        virtual TString GetCollectionName(stor_bt::TShingleStorageType sstype, int type) = 0;
        virtual void IncrementStat(stor_bt::TShingleStorageType sstype, bool res) = 0;
        virtual void AddStorageStat(stor_bt::TShingleStorageType stortype, stor_bt::TStorageActionType acttype, int count, NStorageStats::TSRSErrType good, ui32 tick) = 0;

        NStorageStats::TStorageStatVector GetWebStat();
        NStorageStats::TStorageStatVector GetMonStat();

        TStorageNoSqlBase();
        virtual ~TStorageNoSqlBase();
    };

    //**********************************************************************************************************************************************

} // namespace stor_bt
