#include "thashipv6.h"
#include "shtime.h"
//#include "baniplist.h"
#include <library/cpp/charset/doccodes.h>

namespace kipv6 {

    //*********************************************************************************************************************
    //                                                 THashIP
    //*********************************************************************************************************************

    THashIPv6::THashIPv6() {
        m_filename = "";
        LogsGroup = nullptr;
        m_ident = "";
        m_clear_before_load = true;
        m_name = "";
    }

    THashIPv6::THashIPv6(const TString& name) {
        m_filename = "";
        LogsGroup = nullptr;
        m_ident = "";
        m_clear_before_load = true;
        m_name = name;
    }

    THashIPv6::~THashIPv6() = default;

    void THashIPv6::Lock() {
        m_Mutex.AcquireWrite();
    }

    void THashIPv6::UnLock() {
        m_Mutex.ReleaseWrite();
    }

    void THashIPv6::LockRead() {
        m_Mutex.AcquireRead();
    }

    void THashIPv6::UnLockRead() {
        m_Mutex.ReleaseRead();
    }

    void THashIPv6::LockLoad() {
        m_MutexLoad.Acquire();
    }

    void THashIPv6::UnLockLoad() {
        m_MutexLoad.Release();
    }

    void THashIPv6::InitBase(const TString& ident, const TString& filename, TLogsGroupBase* LogsGroupA, bool clear_before_load) {
        char buff[25];

        memset(buff, 0, sizeof(buff));
        snprintf(buff, sizeof(buff), "%15s", ident.c_str());
        m_ident = TString(buff);

        m_filename = filename;
        LogsGroup = LogsGroupA;
        m_clear_before_load = clear_before_load;
    }

    void THashIPv6::ReloadFileList() {
        TString errstr = "";

        if (!m_filename.empty()) {
            if (ExistsFile()) {
                auto state = FileStateWasChanged(m_filename, m_statHashIp, errstr);
                if (!state) {
                    if ((LogsGroup != nullptr) && (LogsGroup->GetServerLog() != nullptr))
                        LogsGroup->GetServerLog()->WriteMessageAndDataStatus(KMESSAGE, "%s:    no changed.", m_ident.c_str());
                    return;
                }
                m_statHashIp = *state;

                FILE* handle = nullptr;
                //int file_size = 0;
                //char* buff = nullptr;
                //int buff_size = 0;
                //int read_count = 0;
                char tbuff[1024];
                size_t len = 0;
                TString restxt = "";
                THashStat stat;

                handle = fopen(m_filename.c_str(), "rb");
                if (handle != nullptr) {
                    LockLoad();

                    ui64 timepoint = CShingleTime::GetMs();

                    PrefixFunction(); //�������������� ��������� �����

                    while (fgets(tbuff, sizeof(tbuff), handle)) {
                        len = strlen(tbuff);
                        if (len > 0)
                            ReloadMemListA(tbuff, len, stat);
                    }

                    PostfixFunction(); //��������� ��������� ����� � ����������
                    TriggerFunction();

                    UnLockLoad();

                    fclose(handle);

                    timepoint = CShingleTime::GetMs() - timepoint;
                    restxt = GetResultPrint(stat, timepoint);
                    if ((LogsGroup != nullptr) && (LogsGroup->GetServerLog() != nullptr))
                        LogsGroup->GetServerLog()->WriteMessageAndDataStatus(KMESSAGE, "%s", restxt.c_str());

                } else {
                    if ((LogsGroup != nullptr) && (LogsGroup->GetServerLog() != nullptr))
                        LogsGroup->GetServerLog()->WriteMessageAndDataStatus(KMESSAGE, "%s:   error open file to read: '%s'.", m_ident.c_str(), m_filename.c_str());
                }
            } else {
                if ((LogsGroup != nullptr) && (LogsGroup->GetServerLog() != nullptr))
                    LogsGroup->GetServerLog()->WriteMessageAndDataStatus(KMESSAGE, "%s:   file not found: '%s'.", m_ident.c_str(), m_filename.c_str());
            }
        } else {
            if ((LogsGroup != nullptr) && (LogsGroup->GetServerLog() != nullptr))
                LogsGroup->GetServerLog()->WriteMessageAndDataStatus(KMESSAGE, "%s:   no defined filename.", m_ident.c_str());
        }
    }

    ui32 THashIPv6::GetStr(const char* source, size_t source_size, char* destination, ui32 destination_size) {
        long pos = -1;
        ui32 res = 0;
        ui8 dob = 0;

        for (ui32 i = 0; i < source_size; i++) {
            if ((source[i] == 0x0D) && ((i + 1) < source_size) && (source[i + 1] == 0x0A)) {
                pos = i;
                dob = 1;
                break;
            }
            if (source[i] == 0x0A) {
                pos = i;
                dob = 0;
                break;
            }
        }
        res = pos + 1 + dob;
        if (res == 0)
            res = source_size;
        if (res > 0) {
            memset(destination, 0, destination_size);
            if (res <= (destination_size - 1)) {
                memcpy(destination, source, res);
            } else {
                memcpy(destination, source, destination_size - 1);
            }
        }
        return res;
    }

    void THashIPv6::ReloadMemListA(const char* buff, size_t buff_size, THashStat& stat) {
        size_t m_buff_pos = 0;
        char tbuff[65500];
        const char* sourcebuff = nullptr;
        size_t sourcebuffsize = 0;
        size_t strlength = 0;
        TString restxt = "";
        bool valid_str;

        sourcebuff = buff;
        sourcebuffsize = static_cast<size_t>(buff_size);
        m_buff_pos = 0;
        while (m_buff_pos < sourcebuffsize) {
            strlength = GetStr(sourcebuff + m_buff_pos, sourcebuffsize - m_buff_pos, tbuff, sizeof(tbuff));
            if (strlength > 0) {
                m_buff_pos += strlength;

                valid_str = false;
                for (size_t i = 0; i < strlength; i++) {
                    if ((tbuff[i] < 0) || (tbuff[i] > ' ')) {
                        valid_str = true;
                        break;
                    }
                }

                if (valid_str)
                    ParseItem(tbuff, stat);

            } else
                break;
        }
    }

    void THashIPv6::ReloadMemList(const TString& data) {
        THashStat stat;
        TString restxt = "";

        LockLoad();

        ui64 timepoint = CShingleTime::GetMs();
        PrefixFunction(); //�������������� ��������� �����

        ReloadMemListA(data.c_str(), data.length(), stat);

        PostfixFunction(); //��������� ��������� ����� � ����������
        TriggerFunction();

        UnLockLoad();

        timepoint = CShingleTime::GetMs() - timepoint;
        restxt = GetResultPrint(stat, timepoint);
        if ((LogsGroup != nullptr) && (LogsGroup->GetServerLog() != nullptr))
            LogsGroup->GetServerLog()->WriteMessageAndDataStatus(KMESSAGE, "%s", restxt.c_str());
    }

    bool THashIPv6::ExistsFile() {
        bool res = false;
        FILE* handle = nullptr;

        if (!m_filename.empty()) {
            handle = fopen(m_filename.c_str(), "rb");
            if (handle != nullptr) {
                res = true;
                fclose(handle);
            }
        }

        return res;
    }

    ui64 THashIPv6::CalcShingle(const TString& str_data) {
        ui64 res = 0;
        TString str_data_t = "";

        if (!str_data.empty()) {
            str_data_t = Trim(str_data);
            if (!str_data_t.empty()) {
                char sshingle[32];
                TString stemp = "";

                stemp = "sh_" + str_data_t;
                ToLower(stemp.begin(), stemp.size());
                memset(sshingle, 0, sizeof(sshingle));
                calc_strcrc64(stemp.c_str(), stemp.size(), sshingle);
                sscanf(sshingle, "%" PRIx64, &res);
            }
        }

        return res;
    }

    TString THashIPv6::IntToIpV4(ui32 ip) {
        TString res = "";
        char buff[64];
        ui32 oct[4];

        memset(buff, 0, sizeof(buff));
        oct[0] = (ip >> 24) & 0xFF;
        oct[1] = (ip >> 16) & 0xFF;
        oct[2] = (ip >> 8) & 0xFF;
        oct[3] = ip & 0xFF;
        snprintf(buff, sizeof(buff) - 1, "%u.%u.%u.%u", oct[0], oct[1], oct[2], oct[3]);
        res = TString(buff);

        return res;
    }

    char* THashIPv6::STRNCPY(char* strDest, const char* strSource, size_t DestSize, size_t count) {
        if (count > DestSize - 1)
            count = DestSize - 1;
        strncpy(strDest, strSource, count);
        strDest[count] = 0;
        return strDest;
    }

    bool THashIPv6::IpToIntV4(const char* pstr, size_t len, ui32* pnet, ui32* pip) {
        const char* pdot;
        size_t c = pip ? 3 : 2;
        ui32 t[4];
        const int buf_sz = 64;
        char buf[buf_sz];

        for (size_t i = 0; i < len; i++) {
            if (!isdigit(pstr[i]) && pstr[i] != '.')
                return false;
        }

        for (size_t i = 0; i < c; i++) {
            pdot = strchr(pstr, '.');
            if (!pdot)
                return false;
            STRNCPY(buf, pstr, buf_sz, pdot - pstr);
            t[i] = atoi(buf);
            pstr = pdot + 1;
            if (t[i] > 255)
                return false;
        }

        if (!isdigit(*pstr))
            return false;
        t[c] = atoi(pstr);
        if (t[c] > 255)
            return false;

        *pnet = t[0] * 256 * 256 * 256;
        *pnet += t[1] * 256 * 256;
        *pnet += t[2] * 256;

        if (pip) {
            *pip = *pnet;
            *pip += t[3];
        }

        return true;
    }

    //*********************************************************************************************************************
    //                                                 TWhiteIPv6
    //*********************************************************************************************************************

    TWhiteIPv6::TWhiteIPv6()
        : THashIPv6(__FUNCTION__) {
    }

    TWhiteIPv6::~TWhiteIPv6() {
        ClearData();
    }

    void TWhiteIPv6::Init(const TString& filename, TLogsGroupBase* LogsGroupA) {
        InitBase("WHITEIP", filename, LogsGroupA, true);
    }

    void TWhiteIPv6::Init(const TString& ident, const TString& filename, TLogsGroupBase* LogsGroupA) {
        InitBase(ident, filename, LogsGroupA, true);
    }

    void TWhiteIPv6::ClearData() {
        data_temp.clear();
        data_trace_temp.clear();
        data.clear();
        data_trace.clear();
    }

    void TWhiteIPv6::ParseItem(const char* str, THashStat& stat) {
        if ((str != nullptr)) {
            int len = strlen(str);
            char buff[2][100];
            bool trace = false;

            memset(buff, 0, sizeof(buff));
            if (len > 0) {
                sscanf(str, " %s %s ", buff[0], buff[1]);
                if (buff[0][0] == '#') {
                } else {
                    trace = (buff[1][0] == '-') ? false : true;

                    auto ip = TKIPv6(buff[0]);
                    if (!ip.Undefined()) {
                        if (trace) {
                            if (auto uho = MapFindPtr(data_trace_temp, ip)) {
                                stat.dublicat_count = IncMax32(stat.dublicat_count, 1);
#ifndef K_PRINT_ONLY_STAT
                                if ((LogsGroup != nullptr) && (LogsGroup->GetServerLog() != nullptr))
                                    LogsGroup->GetServerLog()->WriteMessageAndDataStatus(KWARNING, "%s:   trace ip doubling %s", m_ident.c_str(), ip.toStroka().c_str());
#endif
                            } else {
                                data_trace_temp.emplace(ip, TKUidHash{});
                                stat.trace_count = IncMax32(stat.trace_count, 1);
                            }
                        } else {
                            if (auto value = MapFindPtr(data_temp, ip)) {
                                stat.dublicat_count = IncMax32(stat.dublicat_count, 1);
#ifndef K_PRINT_ONLY_STAT
                                if ((LogsGroup != nullptr) && (LogsGroup->GetServerLog() != nullptr))
                                    LogsGroup->GetServerLog()->WriteMessageAndDataStatus(KWARNING, "%s:   ip doubling '%s'", m_ident.c_str(), ip.toStroka().c_str());
#endif
                            } else {
                                data_temp.emplace(ip, 0);
                                stat.no_trace_count = IncMax32(stat.no_trace_count, 1);
                            }
                        }
                    } else {
                        stat.bad_count = IncMax32(stat.bad_count, 1);

#ifndef K_PRINT_ONLY_STAT
                        if ((LogsGroup != nullptr) && (LogsGroup->GetServerLog() != nullptr))
                            LogsGroup->GetServerLog()->WriteMessageAndDataStatus(KERROR, "%s:   bad ip '%s'", m_ident.c_str(), buff[0]);
#endif
                    }
                }
            }
        }
    }

    TString TWhiteIPv6::GetResultPrint(THashStat& stat, ui32 timedelay) {
        TString res = "";
        ui32 all = 0;

        all = IncMax32(all, stat.trace_count);
        all = IncMax32(all, stat.no_trace_count);
        all = IncMax32(all, stat.bad_count);
        all = IncMax32(all, stat.dublicat_count);
        res = m_ident + ":   Read list (" + IntToStroka(timedelay) + " ms), records: " + IntToStroka(all) + " (trace=" + IntToStroka(stat.trace_count) + ", no_trace=" + IntToStroka(stat.no_trace_count) + ", bad=" + IntToStroka(stat.bad_count) + ", dublicat=" + IntToStroka(stat.dublicat_count) + ")";

        return res;
    }

    void TWhiteIPv6::TriggerFunction() {
    }

    void TWhiteIPv6::PrefixFunction() {
        data_temp = {};
        data_trace_temp = {};
    }

    void TWhiteIPv6::PostfixFunction() {
        //��������� ������� ����� �� ���������, ���� ��������� ������
        Lock();

        data = std::exchange(data_temp, {});
        data_trace = std::exchange(data_trace_temp, {});

        UnLock();
    }

    bool TWhiteIPv6::IsWhiteIp(TKIPv6 ip) {
        bool res = false;

        Lock();

        if ((data.contains(ip)))
            res = true;

        if (!res) {
            if (data_trace.contains(ip))
                res = true;
        }

        UnLock();

        return res;
    }

    bool TWhiteIPv6::IsWhiteIpTrace(TKIPv6 ip, ui64 uid) {
        bool res = false;
        const int MaxArr = 16;
        ui32 counts[MaxArr];
        TKUidHashIt uit;
        TString txt = "";

        memset(counts, 0, sizeof(counts));

        Lock();

        if (auto uho = MapFindPtr(data_trace, ip)) {
            res = true;
            if (uho != nullptr) {
                if (uid > 0) {
                    uit = uho->find(uid);
                    if (uit != uho->end()) {
                        (*uit).second = IncMax32((*uit).second, 1);
                    } else {
                        if (uho->size() < MAX_UID_COUNT)
                            (*uho)[uid] = 1;
                    }
                }

                uit = uho->begin();
                while (uit != uho->end()) {
                    if ((*uit).second < MaxArr)
                        ++counts[(*uit).second];
                    else
                        ++counts[0];

                    ++uit;
                }

                txt = "";
                for (int i = 0; i < MaxArr; i++) {
                    if (counts[i]) {
                        if (i == (MaxArr - 1))
                            txt = txt + IntToStroka(i) + " - " + IntToStroka(counts[i]);
                        else
                            txt = txt + IntToStroka(i) + " - " + IntToStroka(counts[i]) + ", ";
                    }
                }
            }
        }

        UnLock();

        return res;
    }

    //*********************************************************************************************************************
    //                                                 TRblIPv6
    //*********************************************************************************************************************

    //***** TRblIPv6Item *****

    TRblIPv6Item::TRblIPv6Item()
        : THashIPv6(__FUNCTION__) {
        m_data = nullptr;
    }

    TRblIPv6Item::~TRblIPv6Item() = default;

    void TRblIPv6Item::Init(const TString& ident, const TString& filename, TLogsGroupBase* LogsGroupA) {
        m_data = nullptr;
        InitBase(ident, filename, LogsGroupA, false);
    }

    void TRblIPv6Item::ParseItem(const char* str, THashStat& stat) {
        if ((m_data != nullptr) && (str != nullptr)) {
            int len = strlen(str);
            char buff[2][100];
            //ui32 readcount = 0;

            memset(buff, 0, sizeof(buff));
            if (len > 0) {
                sscanf(str, " %s %s ", buff[0], buff[1]);
                if (buff[0][0] == '#') {
                } else {
                    auto ip = TKIPv6(buff[0]);
                    if (!ip.Undefined()) {
                        if (m_data->contains(ip)) {
                            stat.dublicat_count = IncMax32(stat.dublicat_count, 1);
#ifndef K_PRINT_ONLY_STAT
                            if ((LogsGroup != nullptr) && (LogsGroup->GetServerLog() != nullptr))
                                LogsGroup->GetServerLog()->WriteMessageAndDataStatus(KWARNING, "%s:   ip doubling '%s'", m_ident.c_str(), ip.toStroka().c_str());
#endif
                        } else {
                            m_data->emplace(ip, 1);
                            stat.no_trace_count = IncMax32(stat.no_trace_count, 1);
                        }
                    } else {
                        stat.bad_count = IncMax32(stat.bad_count, 1);

#ifndef K_PRINT_ONLY_STAT
                        if ((LogsGroup != nullptr) && (LogsGroup->GetServerLog() != nullptr))
                            LogsGroup->GetServerLog()->WriteMessageAndDataStatus(KERROR, "%s:   bad ip '%s'", m_ident.c_str(), buff[0]);
#endif
                    }
                }
            }
        }
    }

    void TRblIPv6Item::ClearData() {
    }

    TString TRblIPv6Item::GetResultPrint(THashStat& stat, ui32 timedelay) {
        TString res = "";
        ui32 all = 0;

        all = IncMax32(all, stat.no_trace_count);
        all = IncMax32(all, stat.bad_count);
        all = IncMax32(all, stat.dublicat_count);
        res = m_ident + ":   Read list (" + IntToStroka(timedelay) + " ms), records: " + IntToStroka(all) + " (good=" + IntToStroka(stat.no_trace_count) + ", bad=" + IntToStroka(stat.bad_count) + ", dublicat=" + IntToStroka(stat.dublicat_count) + ")";

        return res;
    }

    void TRblIPv6Item::TriggerFunction() {
    }

    void TRblIPv6Item::PrefixFunction() {
    }

    void TRblIPv6Item::PostfixFunction() {
    }

    //***** TRblIPv6ItemDiff *****

    TRblIPv6ItemDiff::TRblIPv6ItemDiff()
        : THashIPv6(__FUNCTION__) {
        m_data = nullptr;
    }

    TRblIPv6ItemDiff::~TRblIPv6ItemDiff() = default;

    void TRblIPv6ItemDiff::Init(const TString& ident, const TString& filename, TLogsGroupBase* LogsGroupA) {
        m_data = nullptr;
        InitBase(ident, filename, LogsGroupA, false);
    }

    void TRblIPv6ItemDiff::ParseItem(const char* str, THashStat& stat) {
        if ((m_data != nullptr) && (str != nullptr)) {
            int len = strlen(str);
            char buff[2][100];
            ui8 sw = 0;

            memset(buff, 0, sizeof(buff));
            if (len > 0) {
                sscanf(str, " %s %s ", buff[0], buff[1]);
                if (buff[0][0] == '#') {
                } else {
                    switch (buff[0][0]) {
                        case '<': //delete
                            sw = 1;
                            break;
                        case '>': //insert
                            sw = 2;
                            break;
                        default:
                            sw = 0;
                    }
                    if ((sw == 1) || (sw == 2)) {
                        auto ip = TKIPv6(buff[0]);
                        if (!ip.Undefined()) {
                            if (m_data->contains(ip)) {
                                stat.dublicat_count = IncMax32(stat.dublicat_count, 1);
#ifndef K_PRINT_ONLY_STAT
                                if ((LogsGroup != nullptr) && (LogsGroup->GetServerLog() != nullptr))
                                    LogsGroup->GetServerLog()->WriteMessageAndDataStatus(KWARNING, "%s:   ip doubling '%s'", m_ident.c_str(), ip.toStroka().c_str());
#endif
                            } else {
                                m_data->emplace(ip, sw);
                                stat.no_trace_count = IncMax32(stat.no_trace_count, 1);
                            }

                        } else {
                            stat.bad_count = IncMax32(stat.bad_count, 1);

#ifndef K_PRINT_ONLY_STAT
                            if ((LogsGroup != nullptr) && (LogsGroup->GetServerLog() != nullptr))
                                LogsGroup->GetServerLog()->WriteMessageAndDataStatus(KERROR, "%s:   bad ip '%s'", m_ident.c_str(), buff[0]);
#endif
                        }
                    }
                }
            }
        }
    }

    void TRblIPv6ItemDiff::ClearData() {
    }

    TString TRblIPv6ItemDiff::GetResultPrint(THashStat& stat, ui32 timedelay) {
        TString res = "";
        ui32 all = 0;

        all = IncMax32(all, stat.no_trace_count);
        all = IncMax32(all, stat.bad_count);
        all = IncMax32(all, stat.dublicat_count);
        res = m_ident + ":   Read list (" + IntToStroka(timedelay) + " ms), records: " + IntToStroka(all) + " (good=" + IntToStroka(stat.no_trace_count) + ", bad=" + IntToStroka(stat.bad_count) + ", dublicat=" + IntToStroka(stat.dublicat_count) + ")";

        return res;
    }

    void TRblIPv6ItemDiff::TriggerFunction() {
    }

    void TRblIPv6ItemDiff::PrefixFunction() {
    }

    void TRblIPv6ItemDiff::PostfixFunction() {
    }

    //***** TRblIPv6 *****

    TRblIPv6::TRblIPv6() {
        LogsGroup = nullptr;
        blacklist1 = "";
        blacklist1to = "";
        blacklist2 = "";
        blacklist2to = "";
        blacklist3 = "";
        blacklist3to = "";
        blacklist4 = "";
        blacklist4to = "";
        blacklistdiff = "";

        data = nullptr;
        data_diff = nullptr;
        data_temp = nullptr;
        data_diff_temp = nullptr;
    }

    TRblIPv6::~TRblIPv6() {
        if (data_temp != nullptr) {
            delete data_temp;
            data_temp = nullptr;
        }
        if (data_diff_temp != nullptr) {
            delete data_diff_temp;
            data_diff_temp = nullptr;
        }
        if (data != nullptr) {
            delete data;
            data = nullptr;
        }
        if (data_diff != nullptr) {
            delete data_diff;
            data_diff = nullptr;
        }
    }

    void TRblIPv6::Init(const TString& blacklist1A, const TString& blacklist1toA, const TString& blacklist2A, const TString& blacklist2toA, const TString& blacklist3A,
                        const TString& blacklist3toA, const TString& blacklist4A, const TString& blacklist4toA, const TString& blacklistdiffA, TLogsGroupBase* LogsGroupA) {
        LogsGroup = LogsGroupA;
        blacklist1 = blacklist1A;
        blacklist1to = blacklist1toA;
        blacklist2 = blacklist2A;
        blacklist2to = blacklist2toA;
        blacklist3 = blacklist3A;
        blacklist3to = blacklist3toA;
        blacklist4 = blacklist4A;
        blacklist4to = blacklist4toA;
        blacklistdiff = blacklistdiffA;

        m_rbl1.Init("RBL1", blacklist1, LogsGroup);
        m_rbl2.Init("RBL2", blacklist2, LogsGroup);
        m_rbl3.Init("RBL3", blacklist3, LogsGroup);
        m_rbl4.Init("RBL4", blacklist4, LogsGroup);
        m_rbl_diff.Init("RBLDiff", blacklistdiff, LogsGroup);
    }

    void TRblIPv6::Lock() {
        m_Mutex.Acquire();
    }

    void TRblIPv6::UnLock() {
        m_Mutex.Release();
    }

    void TRblIPv6::LockLoad() {
        m_MutexLoad.Acquire();
    }

    void TRblIPv6::UnLockLoad() {
        m_MutexLoad.Release();
    }

    void TRblIPv6::PrefixFunction() {
        if (data_temp != nullptr) {
            delete data_temp;
            data_temp = nullptr;
        }
        data_temp = new TKIPv6HashM();

        if (data_diff_temp != nullptr) {
            delete data_diff_temp;
            data_diff_temp = nullptr;
        }
        data_diff_temp = new TKIPv6HashM();
    }

    void TRblIPv6::PostfixFunction() {
        TKIPv6HashM* data_t = nullptr;
        TKIPv6HashM* data_diff_t = nullptr;

        //��������� ������� ����� �� ���������, ���� ��������� ������
        Lock();

        data_t = data;
        data = data_temp;
        data_temp = nullptr;

        data_diff_t = data_diff;
        data_diff = data_diff_temp;
        data_diff_temp = nullptr;

        UnLock();

        //������� ������ ������
        if (data_t != nullptr) {
            delete data_t;
        }
        if (data_diff_t != nullptr) {
            delete data_diff_t;
        }
    }

    bool TRblIPv6::RefreshBLFiles() {
        bool res = true;
        ui32 count = 0;
        ui32 readtime = 0;
        ui32 copytime = 0;

        LockLoad();

        readtime = CShingleTime::GetMs();

        PrefixFunction();

        m_rbl1.SetHashPointer(data_temp);
        m_rbl2.SetHashPointer(data_temp);
        m_rbl3.SetHashPointer(data_temp);
        m_rbl4.SetHashPointer(data_temp);

        m_rbl1.ReloadFileList();
        m_rbl2.ReloadFileList();
        m_rbl3.ReloadFileList();
        m_rbl4.ReloadFileList();

        PostfixFunction();

        Lock();
        if (data != nullptr)
            count = data->size();
        UnLock();

        readtime = CShingleTime::GetMs() - readtime;

        UnLockLoad();

        copytime = CShingleTime::GetMs();

        if ((!blacklist1.empty()) && (!blacklist1to.empty()))
            copyfile(blacklist1.c_str(), blacklist1to.c_str());
        if ((!blacklist2.empty()) && (!blacklist2to.empty()))
            copyfile(blacklist2.c_str(), blacklist2to.c_str());
        if ((!blacklist3.empty()) && (!blacklist3to.empty()))
            copyfile(blacklist3.c_str(), blacklist3to.c_str());
        if ((!blacklist4.empty()) && (!blacklist4to.empty()))
            copyfile(blacklist4.c_str(), blacklist4to.c_str());
        if (!blacklistdiff.empty())
            remove(blacklistdiff.c_str());

        copytime = CShingleTime::GetMs() - copytime;

        if ((LogsGroup != nullptr) && (LogsGroup->GetServerLog() != nullptr))
            LogsGroup->GetServerLog()->WriteMessageAndDataStatus(KMESSAGE, "        RBLMAIN:   read (%u msec) and copy (%u msec) complete, add %u record.", readtime, copytime, count);

        return res;
    }

    bool TRblIPv6::RefreshBLMems(const TString& rbl1_txt, const TString& rbl2_txt, const TString& rbl3_txt, const TString& rbl4_txt) {
        bool res = true;
        ui32 count = 0;
        ui32 readtime = 0;

        LockLoad();

        readtime = CShingleTime::GetMs();

        PrefixFunction();

        m_rbl1.SetHashPointer(data_temp);
        m_rbl2.SetHashPointer(data_temp);
        m_rbl3.SetHashPointer(data_temp);
        m_rbl4.SetHashPointer(data_temp);

        m_rbl1.ReloadMemList(rbl1_txt);
        m_rbl2.ReloadMemList(rbl2_txt);
        m_rbl3.ReloadMemList(rbl3_txt);
        m_rbl4.ReloadMemList(rbl4_txt);

        PostfixFunction();

        Lock();
        if (data != nullptr)
            count = data->size();
        UnLock();

        readtime = CShingleTime::GetMs() - readtime;

        UnLockLoad();

        if ((LogsGroup != nullptr) && (LogsGroup->GetServerLog() != nullptr))
            LogsGroup->GetServerLog()->WriteMessageAndDataStatus(KMESSAGE, "        RBLMAIN:   read rbls (%u msec) complete, add %u record.", readtime, count);

        return res;
    }

    void TRblIPv6::PrefixFunctionDiff() {
        if (data_diff_temp != nullptr) {
            delete data_diff_temp;
            data_diff_temp = nullptr;
        }
        data_diff_temp = new TKIPv6HashM();
    }

    void TRblIPv6::PostfixFunctionDiff() {
        Lock();

        if ((data_diff_temp != nullptr) && (data_diff != nullptr)) {
            for (const auto& [ip, value] : *data_diff_temp) {
                if (data_diff->contains(ip)) {
                    //stat.dublicat_count = IncMax32(stat.dublicat_count, 1);
                    //if ( (LogsGroup != nullptr) && (LogsGroup->GetServerLog() != nullptr))
                    //   LogsGroup->GetServerLog()->WriteMessageAndDataStatus(KWARNING, "        RBLMAIN:   (add diff) ip doubling '%s'", ip.toStroka().c_str());
                } else {
                    data_diff->emplace(ip, value);
                    //stat.no_trace_count = IncMax32(stat.no_trace_count, 1);
                }
            }
        }

        UnLock();

        if (data_diff_temp != nullptr) {
            delete data_diff_temp;
            data_diff_temp = nullptr;
        }
    }

    bool TRblIPv6::RefreshBLDiffFiles() {
        bool res = true;
        ui32 count = 0;
        ui32 readtime = 0;

        LockLoad();

        readtime = CShingleTime::GetMs();

        PrefixFunctionDiff();

        m_rbl_diff.SetHashPointer(data_diff_temp);
        m_rbl_diff.ReloadFileList();

        PostfixFunctionDiff();

        Lock();

        if (data_diff != nullptr)
            count = data_diff->size();

        UnLock();

        readtime = CShingleTime::GetMs() - readtime;

        UnLockLoad();

        if ((LogsGroup != nullptr) && (LogsGroup->GetServerLog() != nullptr))
            LogsGroup->GetServerLog()->WriteMessageAndDataStatus(KMESSAGE, "        RBLMAIN:   read rbl diff (%u msec) complete, add %u record.", readtime, count);

        return res;
    }

    bool TRblIPv6::RefreshBLDiffMems(const TString& data) {
        bool res = true;
        ui32 count = 0;
        ui32 readtime = 0;

        LockLoad();

        readtime = CShingleTime::GetMs();

        m_rbl_diff.ReloadMemList(data);

        if (data_diff != nullptr)
            count = data_diff->size();

        readtime = CShingleTime::GetMs() - readtime;

        UnLockLoad();

        if ((LogsGroup != nullptr) && (LogsGroup->GetServerLog() != nullptr))
            LogsGroup->GetServerLog()->WriteMessageAndDataStatus(KMESSAGE, "        RBLMAIN:   read rbl diff (%u msec) complete, add %u record.", readtime, count);

        return res;
    }

    i64 TRblIPv6::copyfile(const char* source, const char* destination) {
        i64 res = 0;
        FILE *hsource = nullptr, *hdest = nullptr;
        char* BUFF = nullptr;
        ui32 count = 0, count_w = 0;
        ui32 sizebuff = 256000;

        if (source != nullptr) {
            if (destination != nullptr) {
                hsource = fopen(source, "rb");
                if (hsource != nullptr) {
                    hdest = fopen(destination, "wb");
                    if (hdest != nullptr) {
                        BUFF = new char[sizebuff];
                        try {
                            while (!feof(hsource)) {
                                count = fread(BUFF, 1, sizebuff, hsource);
                                count_w = fwrite(BUFF, 1, count, hdest);
                                if (count != count_w) {
                                    res = -3;
                                    break;
                                }
                                res += count;
                            }
                            delete[] BUFF;
                            BUFF = nullptr;
                        } catch (...) {
                            delete[] BUFF;
                        }

                        fclose(hdest);
                    } else {
                        res = -2;
                    }
                    fclose(hsource);
                } else {
                    res = -1;
                }
            } else {
                res = -5;
            }
        } else {
            res = -4;
        }
        return res;
    }

    bool TRblIPv6::GetRBL(TKIPv6 ip) {
        bool res = false;
        if ((data_diff != nullptr) && (!ip.Undefined())) {
            Lock();

            if (auto value = MapFindPtr(*data_diff, ip)) {
                if (*value == 1)
                    res = false;
                else if (*value == 2)
                    res = true;
            } else {
                if (data != nullptr) {
                    if (data->contains(ip))
                        res = true;
                }
            }

            UnLock();
        }

        return res;
    }

    //*********************************************************************************************************************
    //                                                 TStringsLists
    //*********************************************************************************************************************

    TStringsLists::TStringsLists()
        : THashIPv6(__FUNCTION__) {
        data = nullptr;
        data_temp = nullptr;
    }

    TStringsLists::~TStringsLists() {
        ClearData();
    }

    void TStringsLists::Init(const TString& ident, const TString& filename, TLogsGroupBase* LogsGroupA) {
        InitBase(ident, filename, LogsGroupA, true);
    }

    void TStringsLists::ParseItem(const char* str, THashStat& stat) {
        TString strt_source = "";
        TString strt = "";

        if ((str != nullptr) && (data_temp != nullptr)) {
            strt_source = TString(str);
            strt = Trim(strt_source);
            if (!strt.empty()) {
                if (strt[0] == '#') {
                } else {
                    ui64 shingle = 0;
                    TStrokaHashIt it;

                    shingle = CalcShingle(strt);
                    if (shingle != 0) {
                        it = data_temp->find(shingle);
                        if (it != data_temp->end()) {
                            stat.dublicat_count = IncMax32(stat.dublicat_count, 1);
#ifndef K_PRINT_ONLY_STAT
                            if ((LogsGroup != nullptr) && (LogsGroup->GetServerLog() != nullptr))
                                LogsGroup->GetServerLog()->WriteMessageAndDataStatus(KWARNING, "%s:   doubling '%s'", m_ident.c_str(), strt.c_str());
#endif
                        } else {
                            (*data_temp)[shingle] = strt;
                            stat.no_trace_count = IncMax32(stat.no_trace_count, 1);
                        }
                    } else {
                        stat.bad_count = IncMax32(stat.bad_count, 1);

#ifndef K_PRINT_ONLY_STAT
                        if ((LogsGroup != nullptr) && (LogsGroup->GetServerLog() != nullptr))
                            LogsGroup->GetServerLog()->WriteMessageAndDataStatus(KERROR, "%s:   bad item '%s'", m_ident.c_str(), strt_source.c_str());
#endif
                    }
                }
            }
        }
    }

    void TStringsLists::ClearData() {
        if (data != nullptr) {
            data->clear();
            delete data;
            data = nullptr;
        }
        if (data_temp != nullptr) {
            delete data_temp;
            data_temp = nullptr;
        }
    }

    TString TStringsLists::GetResultPrint(THashStat& stat, ui32 timedelay) {
        TString res = "";
        ui32 all = 0;

        all = IncMax32(all, stat.no_trace_count);
        all = IncMax32(all, stat.bad_count);
        all = IncMax32(all, stat.dublicat_count);
        res = m_ident + ":   Read list (" + IntToStroka(timedelay) + " ms), records: " + IntToStroka(all) + " (good=" + IntToStroka(stat.no_trace_count) + ", bad=" + IntToStroka(stat.bad_count) + ", dublicat=" + IntToStroka(stat.dublicat_count) + ")";

        return res;
    }

    void TStringsLists::TriggerFunction() {
    }

    void TStringsLists::PrefixFunction() {
        data_temp = new TStrokaHash();
    }

    void TStringsLists::PostfixFunction() {
        TStrokaHash* data_t = nullptr;

        //��������� ������� ����� �� ���������, ���� ��������� ������
        Lock();

        data_t = data;
        data = data_temp;
        data_temp = nullptr;

        UnLock();

        //������� ������ ������
        if (data_t != nullptr) {
            delete data_t;
        }
    }

    bool TStringsLists::Find(const char* value) {
        bool res = false;
        TString str = "";

        if (value != nullptr) {
            str = TString(value);
            res = Find(str);
        }

        return res;
    }

    bool TStringsLists::Find(const TString& value) {
        bool res = false;
        TStrokaHashIt it;
        ui64 shingle = 0;

        if ((!value.empty()) && (data != nullptr)) {
            shingle = CalcShingle(value);
            if (shingle != 0) {
                LockRead();

                it = data->find(shingle);
                if (it != data->end()) {
                    if ((*it).second == value)
                        res = true;
                }

                UnLockRead();
            }
        }

        return res;
    }

    //*********************************************************************************************************************
    //                                                 TStringsNumberLists
    //*********************************************************************************************************************

    TStringsNumberLists::TStringsNumberLists()
        : THashIPv6(__FUNCTION__) {
        m_type = 0;
        data = nullptr;
        data_temp = nullptr;
    }

    TStringsNumberLists::~TStringsNumberLists() {
        ClearData();
    }

    void TStringsNumberLists::Init(const TString& ident, const TString& filename, TLogsGroupBase* LogsGroupA, int type) {
        InitBase(ident, filename, LogsGroupA, true);
        m_type = type;
    }

    void TStringsNumberLists::ParseItem(const char* str, THashStat& stat) {
        TString strt_source = "";
        TString strt = "";

        if ((str != nullptr) && (data_temp != nullptr)) {
            strt_source = TString(str);
            strt = Trim(strt_source);
            if (!strt.empty()) {
                if (strt[0] == '#') {
                } else {
                    ui64 shingle = 0;
                    TStrokaNumberHashIt it;

                    shingle = CalcShingle(strt);
                    if (shingle != 0) {
                        it = data_temp->find(shingle);
                        if (it != data_temp->end()) {
                            stat.dublicat_count = IncMax32(stat.dublicat_count, 1);
#ifndef K_PRINT_ONLY_STAT
                            if ((LogsGroup != nullptr) && (LogsGroup->GetServerLog() != nullptr))
                                LogsGroup->GetServerLog()->WriteMessageAndDataStatus(KWARNING, "%s:   doubling '%s'", m_ident.c_str(), strt.c_str());
#endif
                        } else {
                            (*data_temp)[shingle] = TStringNumber(strt, m_type);
                            stat.no_trace_count = IncMax32(stat.no_trace_count, 1);
                        }
                    } else {
                        stat.bad_count = IncMax32(stat.bad_count, 1);

#ifndef K_PRINT_ONLY_STAT
                        if ((LogsGroup != nullptr) && (LogsGroup->GetServerLog() != nullptr))
                            LogsGroup->GetServerLog()->WriteMessageAndDataStatus(KERROR, "%s:   bad item '%s'", m_ident.c_str(), strt_source.c_str());
#endif
                    }
                }
            }
        }
    }

    void TStringsNumberLists::ClearData() {
        if (data_temp != nullptr) {
            delete data_temp;
            data_temp = nullptr;
        }
        if (data != nullptr) {
            data->clear();
            delete data;
            data = nullptr;
        }
    }

    TString TStringsNumberLists::GetResultPrint(THashStat& stat, ui32 timedelay) {
        TString res = "";
        ui32 all = 0;

        all = IncMax32(all, stat.no_trace_count);
        all = IncMax32(all, stat.bad_count);
        all = IncMax32(all, stat.dublicat_count);
        res = m_ident + ":   Read list (" + IntToStroka(timedelay) + " ms), records: " + IntToStroka(all) + " (good=" + IntToStroka(stat.no_trace_count) + ", bad=" + IntToStroka(stat.bad_count) + ", dublicat=" + IntToStroka(stat.dublicat_count) + ")";

        return res;
    }

    void TStringsNumberLists::TriggerFunction() {
    }

    void TStringsNumberLists::PrefixFunction() {
        data_temp = new TStrokaNumberHash();
    }

    void TStringsNumberLists::PostfixFunction() {
        TStrokaNumberHash* data_t = nullptr;

        //��������� ������� ����� �� ���������, ���� ��������� ������
        Lock();

        data_t = data;
        data = data_temp;
        data_temp = nullptr;

        UnLock();

        //������� ������ ������
        if (data_t != nullptr) {
            delete data_t;
        }
    }

    int TStringsNumberLists::Find(const char* value) {
        int res = 0;
        TString str = "";

        if (value != nullptr) {
            str = TString(value);
            res = Find(str);
        }

        return res;
    }

    int TStringsNumberLists::Find(const TString& value) {
        int res = 0;
        TStrokaNumberHashIt it;
        ui64 shingle = 0;

        if ((!value.empty()) && (data != nullptr)) {
            shingle = CalcShingle(value);
            if (shingle != 0) {
                Lock();

                it = data->find(shingle);
                if (it != data->end()) {
                    if ((*it).second.m_text == value)
                        res = (*it).second.m_number;
                }

                UnLock();
            }
        }

        return res;
    }

    //*********************************************************************************************************************
    //                                                 TZoneStat
    //*********************************************************************************************************************

    TZoneStat::TZoneStat()
        : THashIPv6(__FUNCTION__) {
        data = nullptr;
        data_temp = nullptr;
    }

    TZoneStat::~TZoneStat() {
        ClearData();
    }

    void TZoneStat::Init(const TString& filename, TLogsGroupBase* LogsGroupA) {
        InitBase("VZONESTAT", filename, LogsGroupA, true);
    }

    void TZoneStat::ParseItem(const char* str, THashStat& stat) {
        TString strt_source = "";
        TString strt = "";

        if ((str != nullptr) && (data_temp != nullptr)) {
            strt_source = TString(str);
            strt = Trim(strt_source);
            if (!strt.empty()) {
                if (strt[0] == '#') {
                } else {
                    ui64 shingle = 0;
                    TZoneStatStructHashIt it;

                    shingle = CalcShingle(strt);
                    if (shingle != 0) {
                        it = data_temp->find(shingle);
                        if (it != data_temp->end()) {
                            stat.dublicat_count = IncMax32(stat.dublicat_count, 1);
#ifndef K_PRINT_ONLY_STAT
                            if ((LogsGroup != nullptr) && (LogsGroup->GetServerLog() != nullptr))
                                LogsGroup->GetServerLog()->WriteMessageAndDataStatus(KWARNING, "%s:   doubling '%s'", m_ident.c_str(), strt.c_str());
#endif
                        } else {
                            (*data_temp)[shingle] = TZoneStatStruct(strt);
                            stat.no_trace_count = IncMax32(stat.no_trace_count, 1);
                        }
                    } else {
                        stat.bad_count = IncMax32(stat.bad_count, 1);

#ifndef K_PRINT_ONLY_STAT
                        if ((LogsGroup != nullptr) && (LogsGroup->GetServerLog() != nullptr))
                            LogsGroup->GetServerLog()->WriteMessageAndDataStatus(KERROR, "%s:   bad item '%s'", m_ident.c_str(), strt_source.c_str());
#endif
                    }
                }
            }
        }
    }

    void TZoneStat::ClearData() {
        if (data != nullptr) {
            data->clear();
            delete data;
            data = nullptr;
        }
        if (data_temp != nullptr) {
            delete data_temp;
            data_temp = nullptr;
        }
    }

    TString TZoneStat::GetResultPrint(THashStat& stat, ui32 timedelay) {
        TString res = "";
        ui32 all = 0;

        all = IncMax32(all, stat.no_trace_count);
        all = IncMax32(all, stat.bad_count);
        all = IncMax32(all, stat.dublicat_count);
        res = m_ident + ":   Read list (" + IntToStroka(timedelay) + " ms), records: " + IntToStroka(all) + " (good=" + IntToStroka(stat.no_trace_count) + ", bad=" + IntToStroka(stat.bad_count) + ", dublicat=" + IntToStroka(stat.dublicat_count) + ")";

        return res;
    }

    void TZoneStat::TriggerFunction() {
    }

    void TZoneStat::PrefixFunction() {
        data_temp = new TZoneStatStructHash();
    }

    void TZoneStat::PostfixFunction() {
        TZoneStatStructHash* data_t = nullptr;

        //��������� ������� ����� �� ���������, ���� ��������� ������
        Lock();

        data_t = data;
        data = data_temp;
        data_temp = nullptr;

        UnLock();

        //������� ������ ������
        if (data_t != nullptr) {
            delete data_t;
        }
    }

    bool TZoneStat::AddZone(const char* zone, TSpClass messclass, bool fDSN) {
        bool res = true;
        TZoneStatStructHashIt it;
        ui64 shingle = 0;
        TString st = "";

        st = TString(zone);
        if ((!st.empty()) && (data != nullptr)) {
            shingle = CalcShingle(st);
            if (shingle != 0) {
                it = data->find(shingle);
                if (it != data->end()) {
                    if (messclass == TSpClass::SPAM)
                        (*it).second.m_data.cS = IncMax32((*it).second.m_data.cS, 1);

                    if (messclass == TSpClass::DLVR)
                        (*it).second.m_data.cD = IncMax32((*it).second.m_data.cD, 1);

                    if (messclass == TSpClass::HAM)
                        (*it).second.m_data.cH = IncMax32((*it).second.m_data.cH, 1);

                    if (fDSN)
                        (*it).second.m_data.cDSN = IncMax32((*it).second.m_data.cDSN, 1);
                }
            }
        }

        return res;
    }

    bool TZoneStat::AddZoneTwice(const char* zone, TSpClass messclass, bool fDSN) {
        Lock();

        AddZone(zone, messclass, fDSN);

        const char* p = zone;
        while (*p && *p != '.') {
            p++;
        }
        if (*p == '.') {
            AddZone(p + 1, messclass, fDSN);
        }

        UnLock();

        return true;
    }

    bool TZoneStat::PrintZones(const char* filename, bool fClear) {
        bool res = true;
        FILE* handle = nullptr;

        if ((filename != nullptr) && (strlen(filename) > 0) && (data != nullptr)) {
            handle = fopen(filename, "wt");
            if (handle != nullptr) {
                TString zone = "";
                TZoneStatStructHashIt it;
                ui32 summ = 0;
                ui32 cS = 0;
                ui32 cD = 0;
                ui32 cH = 0;
                ui32 cDSN = 0;
                int count = 0;
                int countw = 0;

                fprintf(handle, "\n----------------------------------------------------------\n");
                fprintf(handle, "      ZONE\tSUMWODSN\t SPAM\t  DLV\t  HAM\t  DSN\n");
                fprintf(handle, "------------------------------------------------------------\n");

                Lock();

                it = data->begin();
                while (it != data->end()) {
                    zone = (*it).second.m_text;
                    cS = (*it).second.m_data.cS;
                    cD = (*it).second.m_data.cD;
                    cH = (*it).second.m_data.cH;
                    cDSN = (*it).second.m_data.cDSN;
                    if ((cS > 0) || (cD > 0) || (cH > 0)) {
                        summ = 0;
                        summ = IncMax32(summ, cS);
                        summ = IncMax32(summ, cD);
                        summ = IncMax32(summ, cH);
                        fprintf(handle, "%10s\t%8u\t%5u\t%5u\t%5u\t%5u\n", zone.c_str(), summ, cS, cD, cH, cDSN);

                        countw++;
                        if (fClear) {
                            (*it).second.m_data.cD = 0;
                            (*it).second.m_data.cH = 0;
                            (*it).second.m_data.cS = 0;
                            (*it).second.m_data.cDSN = 0;
                        }
                    }

                    ++it;
                }

                UnLock();

                fclose(handle);

                if ((LogsGroup != nullptr) && (LogsGroup->GetServerLog() != nullptr))
                    LogsGroup->GetServerLog()->WriteMessageAndDataStatus(KMESSAGE, "%s:  PrintZones saved file %s  (all=%d allwodsn=%d)", m_ident.c_str(), filename, count, countw);
            }
        }

        return res;
    }

    bool TZoneStat::PrintZones(TLogClass* log, bool fClear) {
        bool res = true;

        if ((log != nullptr) && (data != nullptr)) {
            TString zone = "";
            TZoneStatStructHashIt it;
            ui32 summ = 0;
            ui32 cS = 0;
            ui32 cD = 0;
            ui32 cH = 0;
            ui32 cDSN = 0;
            int count = 0;
            int countw = 0;

            log->TruncLog();
            log->WriteMessage("\n----------------------------------------------------------\n");
            log->WriteMessage("      ZONE\tSUMWODSN\t SPAM\t  DLV\t  HAM\t  DSN\n");
            log->WriteMessage("------------------------------------------------------------\n");

            Lock();

            it = data->begin();
            while (it != data->end()) {
                zone = (*it).second.m_text;
                cS = (*it).second.m_data.cS;
                cD = (*it).second.m_data.cD;
                cH = (*it).second.m_data.cH;
                cDSN = (*it).second.m_data.cDSN;
                if ((cS > 0) || (cD > 0) || (cH > 0)) {
                    summ = 0;
                    summ = IncMax32(summ, cS);
                    summ = IncMax32(summ, cD);
                    summ = IncMax32(summ, cH);
                    log->WriteMessage("%10s\t%8u\t%5u\t%5u\t%5u\t%5u\n", zone.c_str(), summ, cS, cD, cH, cDSN);

                    countw++;
                    if (fClear) {
                        (*it).second.m_data.cD = 0;
                        (*it).second.m_data.cH = 0;
                        (*it).second.m_data.cS = 0;
                        (*it).second.m_data.cDSN = 0;
                    }
                }

                ++it;
            }

            UnLock();

            if ((LogsGroup != nullptr) && (LogsGroup->GetServerLog() != nullptr))
                LogsGroup->GetServerLog()->WriteMessageAndDataStatus(KMESSAGE, "%s:   PrintZones saved file %s  (all=%d allwodsn=%d)", m_ident.c_str(), log->GetTekFilename().c_str(), count, countw);
        }

        return res;
    }

    //*********************************************************************************************************************
    //                                                 TWhiteNetv6
    //*********************************************************************************************************************

    TWhiteNetv6::TWhiteNetv6() {
        idents = "";
        host_data = nullptr;
        host_data_temp = nullptr;
        range_data = nullptr;
        range_data_temp = nullptr;
    }

    TWhiteNetv6::TWhiteNetv6(const TString& ident) {
        idents = ident;
        host_data = nullptr;
        host_data_temp = nullptr;
        range_data = nullptr;
        range_data_temp = nullptr;
    }

    TWhiteNetv6::~TWhiteNetv6() {
        ClearData();
    }

    void TWhiteNetv6::Init(const TString& filename, TLogsGroupBase* LogsGroupA) {
        InitTable();
        InitBase(idents, filename, LogsGroupA, true);
    }

    void TWhiteNetv6::ParseItem(const char* str, THashStat& stat) {
        if (str != nullptr) {
            //TString         strdata = Trim(TString(str));
            TString strdata = NormalizeStr(str, strlen(str));
            TRecordType rectype;
            TWIPv6 wip;
            ui64 shingle = 0;
            TTStringHashIt it;

            if ((!strdata.empty()) && (host_data_temp != nullptr) && (range_data_temp != nullptr)) {
                if (strdata[0] == '#') {
                } else {
                    rectype = GetRecordType(strdata.c_str(), strdata.length());
                    switch (rectype) {
                        case TWhiteNetv6::THOST:
                            shingle = CalcShingle(strdata);
                            if (shingle != 0) {
                                it = host_data_temp->find(shingle);
                                if (it != host_data_temp->end()) {
                                    stat.dublicat_count = IncMax32(stat.dublicat_count, 1);
#ifndef K_PRINT_ONLY_STAT
                                    if ((LogsGroup != NULL) && (LogsGroup->ActionLog() != NULL))
                                        LogsGroup->ActionLog()->WriteMessageAndDataStatus(KWARNING, "%s:   doubling '%s'", m_ident.c_str(), strdata.c_str());
#endif
                                } else {
                                    (*host_data_temp)[shingle] = strdata;
                                    stat.trace_count = IncMax32(stat.trace_count, 1);
                                }
                            } else {
                                stat.bad_count = IncMax32(stat.bad_count, 1);
#ifndef K_PRINT_ONLY_STAT
                                if ((LogsGroup != NULL) && (LogsGroup->ActionLog() != NULL))
                                    LogsGroup->ActionLog()->WriteMessageAndDataStatus(KERROR, "%s:   bad item '%s'", m_ident.c_str(), strdata.c_str());
#endif
                            }
                            break;
                        case TWhiteNetv6::TIPNET: //range 1 (127.0.0.1/32)
                            if (ParseRangeType1(strdata, wip)) {
                                range_data_temp->push_back(wip);
                                stat.no_trace_count = IncMax32(stat.no_trace_count, 1);
                            } else {
                                stat.bad_count = IncMax32(stat.bad_count, 1);
                            }
                            break;
                        case TWhiteNetv6::TIPRANGE: //range 2 (127.0.0.1 127.0.0.2)
                            if (ParseRangeType2(strdata, wip)) {
                                range_data_temp->push_back(wip);
                                stat.no_trace_count = IncMax32(stat.no_trace_count, 1);
                            } else {
                                stat.bad_count = IncMax32(stat.bad_count, 1);
                            }
                            break;
                        case TWhiteNetv6::TUNDEF:
                            break;
                        case TWhiteNetv6::TIPADDRESS:
                            break;
                    }
                }
            }
        }
    }

    void TWhiteNetv6::ClearData() {
        if (host_data != nullptr) {
            delete host_data;
            host_data = nullptr;
        }
        if (host_data_temp != nullptr) {
            delete host_data_temp;
            host_data_temp = nullptr;
        }
        if (range_data != nullptr) {
            delete range_data;
            range_data = nullptr;
        }
        if (range_data_temp != nullptr) {
            delete range_data_temp;
            range_data_temp = nullptr;
        }
    }

    TString TWhiteNetv6::GetResultPrint(THashStat& stat, ui32 timedelay) {
        TString res = "";
        ui32 all = 0;

        all = IncMax32(all, stat.no_trace_count);
        all = IncMax32(all, stat.trace_count);
        all = IncMax32(all, stat.bad_count);
        all = IncMax32(all, stat.dublicat_count);
        res = m_ident + ":   Read list (" + IntToStroka(timedelay) + " ms), records: " + IntToStroka(all) + " (url=" + IntToStroka(stat.trace_count) + ", dublicat url=" + IntToStroka(stat.dublicat_count) + ", range=" + IntToStroka(stat.no_trace_count) + ", bad=" + IntToStroka(stat.bad_count) + ")";

        return res;
    }

    void TWhiteNetv6::TriggerFunction() {
    }

    void TWhiteNetv6::PrefixFunction() {
        host_data = new TTStringHash();
        host_data_temp = new TTStringHash();
        range_data = new TWIPv6List();
        range_data_temp = new TWIPv6List();
    }

    void TWhiteNetv6::PostfixFunction() {
        TTStringHash* host_data_t = nullptr;
        TWIPv6List* range_data_t = nullptr;

        //подменяем текущие листы на временные, куда загрузили данные
        Lock();

        host_data_t = host_data;
        host_data = host_data_temp;
        host_data_temp = nullptr;

        range_data_t = range_data;
        range_data = range_data_temp;
        range_data_temp = nullptr;

        UnLock();

        //удаляем старые данные
        if (host_data_t != nullptr) {
            delete host_data_t;
        }
        if (range_data_t != nullptr) {
            delete range_data_t;
        }
    }

    TString TWhiteNetv6::NormalizeStr(const char* str, size_t strlength) {
        TString res = "";
        char symb = 0;
        char symb2 = 0;
        TString stemp = "";
        TString stemp2 = "";
        bool first_symb = true;
        bool next_slash;
        char last_symb = 0x00;
        const char* p = nullptr;
        int count = 0;

        stemp = TString(str, static_cast<size_t>(strlength));
        if (!stemp.empty()) {
            p = strchr(stemp.c_str(), '#');
            if (p != nullptr) {
                count = p - stemp.c_str();
                if (count > 0)
                    stemp = TString(stemp.c_str(), static_cast<size_t>(count));
            }
            for (size_t i = 0; i < stemp.length(); i++) {
                symb = *(stemp.c_str() + i);
                if (symb <= ' ') {
                    if (first_symb) {
                        continue;
                    } else {
                        size_t j = 0;
                        next_slash = false;
                        for (j = (i + 1); j < stemp.length(); j++) {
                            symb2 = *(stemp.c_str() + j);
                            if (symb2 <= ' ') {
                                continue;
                            } else if ((symb2 == '\\') || (symb2 == '/')) {
                                next_slash = true;
                                break;
                            } else
                                break;
                        }
                        if ((!next_slash) && (last_symb != '/') && (last_symb != '\\') && (j < stemp.length()))
                            stemp2 = stemp2 + ' ';
                        i = j - 1;
                    }
                } else {
                    if (first_symb)
                        first_symb = false;
                    stemp2 = stemp2 + symb;
                    last_symb = symb;
                }
            }
            res = stemp2;
        }

        return res;
    }

    TWhiteNetv6::TRecordType TWhiteNetv6::GetRecordType(const char* str, size_t strlength) {
        TRecordType res = TUNDEF;
        char symb = 0;
        bool not_range1 = false;
        bool not_range2 = false;
        const char* pgood = nullptr;
        const char* pbad = nullptr;

        if ((str != nullptr) && (strlength > 0)) {
            for (size_t i = 0; i < strlength; i++) {
                symb = *(str + i);
                if (!IsAllowSymbolRange1(symb))
                    not_range1 = true;
                if (!IsAllowSymbolRange2(symb))
                    not_range2 = true;
                if (not_range1 && not_range2) {
                    res = THOST;
                    break;
                }
            }
        }
        if (!not_range1) //range 1 (127.0.0.1/32)
        {
            pgood = strchr(str, '/');
            if (pgood == nullptr)
                pgood = strchr(str, '\\');
            pbad = strchr(str, ' ');
            if ((pgood != nullptr) && (pbad == nullptr))
                res = TIPNET;
        }
        if ((res != TIPNET) && (!not_range2)) //range 2 (127.0.0.1 127.0.0.2)
        {
            pgood = strchr(str, ' ');
            pbad = strchr(str, '/');
            if (pbad == nullptr)
                pbad = strchr(str, '\\');
            if ((pgood != nullptr) && (pbad == nullptr))
                res = TIPRANGE;
        }
        if (res == TUNDEF) {
            auto addr = TKIPv6(str);
            if (!addr.Undefined())
                res = TIPADDRESS;
        }

        return res;
    }

    void TWhiteNetv6::InitTable() {
        memset(SymbTable, 0, sizeof(SymbTable));

        //range 1 (127.0.0.1/32)
        SymbTable[static_cast<unsigned char>('.')] = (SymbTable[static_cast<unsigned char>('.')] & 0xFE) + 0x01;
        SymbTable[static_cast<unsigned char>(':')] = (SymbTable[static_cast<unsigned char>(':')] & 0xFE) + 0x01;
        SymbTable[static_cast<unsigned char>('/')] = (SymbTable[static_cast<unsigned char>('/')] & 0xFE) + 0x01;
        SymbTable[static_cast<unsigned char>('\\')] = (SymbTable[static_cast<unsigned char>('\\')] & 0xFE) + 0x01;
        for (int i = 'a'; i <= 'f'; i++)
            SymbTable[i] = (SymbTable[i] & 0xFE) + 0x01;
        for (int i = 'A'; i <= 'F'; i++)
            SymbTable[i] = (SymbTable[i] & 0xFE) + 0x01;
        for (int i = '0'; i <= '9'; i++)
            SymbTable[i] = (SymbTable[i] & 0xFE) + 0x01;

        //range 2
        SymbTable[static_cast<unsigned char>('.')] = (SymbTable[static_cast<unsigned char>('.')] & 0xFD) + 0x02;
        SymbTable[static_cast<unsigned char>(':')] = (SymbTable[static_cast<unsigned char>(':')] & 0xFD) + 0x02;
        SymbTable[static_cast<unsigned char>(' ')] = (SymbTable[static_cast<unsigned char>(' ')] & 0xFD) + 0x02;
        for (int i = 'a'; i <= 'f'; i++)
            SymbTable[i] = (SymbTable[i] & 0xFD) + 0x02;
        for (int i = 'A'; i <= 'F'; i++)
            SymbTable[i] = (SymbTable[i] & 0xFD) + 0x02;
        for (int i = '0'; i <= '9'; i++)
            SymbTable[i] = (SymbTable[i] & 0xFD) + 0x02;
    }

    bool TWhiteNetv6::IsAllowSymbolRange1(char symb) {
        bool res = false;
        unsigned char uc = 0;
        ui8 value = 0;

        memcpy(&uc, &symb, sizeof(symb));
        value = SymbTable[uc];
        if (IS_SYMB_RANGE_WN1(value) > 0)
            res = true;

        return res;
    }

    bool TWhiteNetv6::IsAllowSymbolRange2(char symb) {
        bool res = false;
        unsigned char uc = 0;
        ui8 value = 0;

        memcpy(&uc, &symb, sizeof(symb));
        value = SymbTable[uc];
        if (IS_SYMB_RANGE_WN2(value) > 0)
            res = true;

        return res;
    }

    bool TWhiteNetv6::ParseRangeType1(const TString& text, TWIPv6& value) {
        bool res = false;
        const char* p1 = nullptr;
        const char* p2 = nullptr;
        int ipsize = 0;
        ui32 ip = 0;
        ui32 net = 0;
        ui32 ipmaskai2 = 0;
        ui32 firstip = 0;
        ui32 lastip = 0;
        ui32 ipcount = 0;
        int ipmaskai = 0;
        TString ipaddress = "";
        TString ipmaska = "";
        TString firstip_s = "";
        TString lastip_s = "";

        if (!text.empty()) {
            p1 = strstr(text.c_str(), "\\");
            p2 = strstr(text.c_str(), "/");
            if (p1 != nullptr) {
                ipsize = p1 - text.c_str();
                if (ipsize > 0) {
                    ipaddress = Trim(TString(text.c_str(), static_cast<size_t>(ipsize)));
                    ipmaska = Trim(TString(p1 + 1));
                    ipmaskai = atoi(ipmaska.c_str());
                }
            } else if (p2 != nullptr) {
                ipsize = p2 - text.c_str();
                if (ipsize > 0) {
                    ipaddress = TString(text.c_str(), static_cast<size_t>(ipsize));
                    ipmaska = TString(p2 + 1);
                    ipmaskai = atoi(ipmaska.c_str());
                }
            }
            if ((!ipaddress.empty()) && (!ipmaska.empty() && (ipmaskai > 0))) {
                if (!IpToIntV4(ipaddress.c_str(), ipaddress.size(), &net, &ip))
                    ip = 0;

                if (ip > 0) {
                    ipmaskai2 = 0xFFFFFFFF << (32 - ipmaskai);
                    ipcount = static_cast<ui32>(1 << (32 - ipmaskai));
                    firstip = ip & ipmaskai2;
                    lastip = firstip + ipcount - 1;

                    firstip_s = IntToIpV4(firstip);
                    lastip_s = IntToIpV4(lastip);

                    value.ip1 = TKIPv6(firstip_s.c_str());
                    value.ip2 = TKIPv6(lastip_s.c_str());
                    if ((!value.ip1.Undefined()) && (!value.ip2.Undefined()))
                        res = true;
                }
            }
        }

        return res;
    }

    bool TWhiteNetv6::ParseRangeType2(const TString& text, TWIPv6& value) {
        bool res = false;
        char ipbuff1[255];
        char ipbuff2[255];

        if (!text.empty()) {
            memset(ipbuff1, 0, sizeof(ipbuff1));
            memset(ipbuff2, 0, sizeof(ipbuff2));
            if (sscanf(text.c_str(), " %s %s ", ipbuff1, ipbuff2) == 2) {
                value.ip1 = TKIPv6(ipbuff1);
                value.ip2 = TKIPv6(ipbuff2);
                if ((!value.ip1.Undefined()) && (!value.ip2.Undefined()))
                    res = true;
            }
        }

        return res;
    }

    bool TWhiteNetv6::IsWhiteNet(const char* phost) {
        bool res = false;
        TTStringHashIt it;
        ui64 shingle = 0;
        TString st = "";

        if ((phost != nullptr) && (*phost != '-') && (host_data != nullptr)) {
            st = TString(phost);
            shingle = CalcShingle(st);
            if (shingle != 0) {
                Lock();

                it = host_data->find(shingle);
                if (it != host_data->end()) {
                    if ((*it).second == st)
                        res = true;
                }

                UnLock();
            }
        }

        return res;
    }

    bool TWhiteNetv6::IsWhiteNet(TKIPv6 ip) {
        TKIPv6 min_ip_from_diapason = TKIPv6();

        return IsWhiteNet(ip, min_ip_from_diapason);
    }

    bool TWhiteNetv6::IsWhiteNet(TKIPv6 ip, TKIPv6& min_ip_from_diapason) {
        bool res = false;
        TWIPv6ListIt it;
        TWIPv6 wip;
        TString s1 = "", s2 = "", s3 = "";

        if ((!ip.Undefined()) && (range_data != nullptr)) {
            Lock();

            it = range_data->begin();
            while (it != range_data->end()) {
                wip = *it;

                s1 = ip.toStroka();
                s2 = wip.ip1.toStroka();
                s3 = wip.ip2.toStroka();

                if ((ip >= wip.ip1) && (ip <= wip.ip2)) {
                    min_ip_from_diapason = wip.ip1;
                    res = true;
                    break;
                }

                ++it;
            }

            UnLock();
        }

        return res;
    }

    TWhiteNetv6::TRecordType TWhiteNetv6::GetAddresses(const TString& addr_text, TWIPv6& value) {
        TRecordType res;
        TWIPv6 wip = TWIPv6();
        TString stemp = NormalizeStr(addr_text.c_str(), addr_text.length());
        TKIPv6 ip;

        value = TWIPv6();
        res = GetRecordType(stemp.c_str(), stemp.length());
        switch (res) {
            case TWhiteNetv6::TUNDEF:
                break;
            case TWhiteNetv6::THOST:
                break;
            case TWhiteNetv6::TIPNET: //range 1 (127.0.0.1/32)
                if (ParseRangeType1(stemp, wip))
                    value = wip;
                else
                    res = TUNDEF;
                break;
            case TWhiteNetv6::TIPRANGE: //range 2 (127.0.0.1 127.0.0.2)
                if (ParseRangeType2(stemp, wip))
                    value = wip;
                else
                    res = TUNDEF;
                break;
            case TWhiteNetv6::TIPADDRESS:
                ip = TKIPv6(stemp.c_str());
                if (!ip.Undefined()) {
                    value.ip1 = ip;
                    value.ip2 = ip;
                } else
                    res = TUNDEF;
                break;
        }

        return res;
    }

    //********************************************************************************************************************
} // namespace kipv6
