#include "tkconfig.h"

TKConfig::TKConfig()
{
    m_config_filename = "";
    m_section_count   = 0;
    m_key_count       = 0;
}

TKConfig::~TKConfig()
{

}

void TKConfig::Lock()
{
    m_Mutex.Acquire();
}

void TKConfig::UnLock()
{
    m_Mutex.Release();
}

void TKConfig::AddParam(const TString &section, const TString &key, const TString &value)
{
    TThreeDimHashIt tdit;
 TKMapIt         mit;
 int             section_count = 0;
 int             key_count = 0;

 Lock();

 if ((!section.empty()) && (!key.empty()))
 {
  tdit = m_data.find(section);
  if (tdit != m_data.end())
  {
     mit = (*tdit).second.find(key);
     if (mit != (*tdit).second.end())
     {
              (*mit).second = value;
           }
           else
     {
              ((*tdit).second)[key] = value;
              key_count++;
           }
        }
        else
  {
            section_count++;
            m_data[section] = TKMap();
            tdit = m_data.find(section);
            if (tdit != m_data.end())
   {
                ((*tdit).second)[key] = value;
                key_count++;
            }
        }
     }

     UnLock();
}

bool TKConfig::Load(const TString& config_filenameA)
{
    bool res = false;
    ui32 m_buff_pos = 0;
    const ui32 tbuffsize = 65500;
    char* tbuff = nullptr;
    ui32 strlength = 0;
    char* pbuff = nullptr;
    size_t plen = 0;
    FILE* handle = nullptr;
    int count = 0;
    TString st = "";
    TString section = "";
    TString key = "";
    TString value = "";
    const char* p1 = nullptr;
    const char* p2 = nullptr;
    TThreeDimHashIt tdit;
    TKMapIt mit;
    int section_count = 0;
    int key_count = 0;
    Lock();
    m_config_filename = config_filenameA;
    if (!m_config_filename.empty()) {
        handle = fopen(m_config_filename.c_str(), "rb");
        if (handle != nullptr) {
            pbuff = new char[MAX_CONFIG_SIZE];
            if (pbuff != nullptr) {
                memset(pbuff, 0, MAX_CONFIG_SIZE);
                count = fread(pbuff, 1, MAX_CONFIG_SIZE - 1, handle);
            }
            fclose(handle);
        }
    }
    if (pbuff != nullptr) {
        res = true;
        plen = strlen(pbuff);
        if (plen > 0) {
            tbuff = new char[tbuffsize];
            try {
                while (m_buff_pos < plen) {
                    strlength = GetStr(pbuff + m_buff_pos, plen - m_buff_pos, tbuff, tbuffsize);
                    if (strlength > 0) {
                        m_buff_pos += strlength;
                        st = Trim(TString(tbuff));
                        if (!st.empty()) {
                            if (st[0] != '#') {
                                section = "";
                                key = "";
                                value = "";
                                p1 = strchr(st.c_str(), '.');
                                if (p1 != nullptr) {
                                    count = p1 - st.c_str();
                                    if (count > 0) {
                                        section = Trim(TString(st.c_str(), count));
                                        p2 = strchr(p1, ':');
                                        if (p2 != nullptr) {
                                            count = p2 - p1 - 1;
                                            if (count > 0) {
                                                key = Trim(TString(p1 + 1, count));
                                                value = Trim(TString(p2 + 1));
                                                if ((!section.empty()) && (!key.empty())) {
                                                    tdit = m_data.find(section);
                                                    if (tdit != m_data.end()) {
                                                        mit = (*tdit).second.find(key);
                                                        if (mit != (*tdit).second.end()) {
                                                            (*mit).second = value;
                                                        } else {
                                                            ((*tdit).second)[key] = value;
                                                            key_count++;
                                                        }
                                                    } else {
                                                        section_count++;
                                                        m_data[section] = TKMap();
                                                        tdit = m_data.find(section);
                                                        if (tdit != m_data.end()) {
                                                            ((*tdit).second)[key] = value;
                                                            key_count++;
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    } else
                        break;
                }
                if (tbuff != nullptr) {
                    delete[] tbuff;
                    tbuff = nullptr;
                }
            } catch (...) {
                if (tbuff != nullptr) {
                    delete[] tbuff;
                    tbuff = nullptr;
                }
            }
        }
        delete[] pbuff;
        pbuff = nullptr;
    }
    m_section_count = section_count;
    m_key_count = key_count;
    UnLock();
    return res;
}

ui32 TKConfig::GetStr(const char* source, ui32 source_size, char* destination, ui32 destination_size)
{
    long pos = -1;
    ui32 res = 0;
    ui8 dob = 0;
    for (ui32 i = 0; i < source_size; i++) {
        if ((source[i] == 0x0D) && ((i + 1) < source_size) && (source[i + 1] == 0x0A)) {
            pos = i;
            dob = 1;
            break;
        }
        if (source[i] == 0x0A) {
            pos = i;
            dob = 0;
            break;
        }
    }
    res = pos + 1 + dob;
    if (res == 0)
        res = source_size;
    if (res > 0) {
        memset(destination, 0, destination_size);
        if (res <= (destination_size - 1)) {
            memcpy(destination, source, res);
        } else {
            memcpy(destination, source, destination_size - 1);
        }
    }
    return res;
}

bool TKConfig::SectionExists(const TString& section)
{
    bool res = false;
    TThreeDimHashIt tdit;
    tdit = m_data.find(section);
    if (tdit != m_data.end())
        res = true;
    return res;
}

bool TKConfig::KeyExists(const TString& section, const TString& key)
{
    bool res = false;
    Lock();
    ReadValue(section, key, res);
    UnLock();
    return res;
}

TString TKConfig::ReadValue(const TString& section, const TString& key, bool& exists)
{
    TString res = "";
    TThreeDimHashIt tdit;
    TKMapIt mit;
    const char* p = nullptr;
    int count = 0;
    exists = false;
    tdit = m_data.find(section);
    if (tdit != m_data.end()) {
        mit = (*tdit).second.find(key);
        if (mit != (*tdit).second.end()) {
            exists = true;
            res = (*mit).second;
            p = strchr(res.c_str(), '#');
            if (p != nullptr) {
                count = p - res.c_str();
                if (count > 0)
                    res = Trim(TString(res.c_str(), count));
                else
                    res = "";
            }
        }
    }
    return res;
}

TString TKConfig::ReadStroka(const TString& section, const TString& key, const TString& defaults)
{
    TString res;
    Lock();
    bool exists = false;
    TString value = "";
    value = ReadValue(section, key, exists);
    if (exists)
        res = value;
    else
        res = defaults;
    UnLock();
    return res;
}

int TKConfig::ReadInteger(const TString& section, const TString& key, int defaults)
{
    int res = false;
    Lock();
    bool exists = false;
    TString value = "";
    value = ReadValue(section, key, exists);
    if (exists)
        res = atoi(value.c_str());
    else
        res = defaults;
    UnLock();
    return res;
}

ui64 TKConfig::ReadUI64(const TString& section, const TString& key, ui64 defaults)
{
    ui64 res = false;
    Lock();
    bool exists = false;
    TString value = "";
    value = ReadValue(section, key, exists);
    if (exists)
        sscanf(value.c_str(), "%" PRIu64, &res);
    else
        res = defaults;
    UnLock();
    return res;
}

bool TKConfig::ReadBool(const TString& section, const TString& key, bool defaults)
{
    bool res = false;
    Lock();
    bool exists = false;
    TString value = "";
    value = ReadValue(section, key, exists);
    if (exists)
        res = (bool)atoi(value.c_str());
    else
        res = defaults;
    UnLock();
    return res;
}

TString TKConfig::ReadPath(const TString& section, const TString& key, const TString& defaults)
{
    TString res;
    Lock();
    bool exists = false;
    TString value = "";
    value = ReadValue(section, key, exists);
    if (exists) {
#ifdef _win_
        char symb = '\\';
#else
        char symb = '/';
#endif
        res = value;
        if ((res.size() > 0) && (res.back() != symb))
            res = res + symb;
    } else
        res = defaults;
    UnLock();
    return res;
}

float TKConfig::ReadFloat(const TString& section, const TString& key, float defaults)
{
    float res = false;
    Lock();
    bool exists = false;
    TString value = "";
    value = ReadValue(section, key, exists);
    if (exists)
        res = (float)atof(value.c_str());
    else
        res = defaults;
    UnLock();
    return res;
}

TString TKConfig::GetAllValueBySection(const TString& section)
{
    TString res = "";
    TThreeDimHashIt tdit;
    TKMapIt mit;
    tdit = m_data.find(section);
    if (tdit != m_data.end()) {
        mit = (*tdit).second.begin();
        while (mit != (*tdit).second.end()) {
            if (!res.empty())
                res = res + ", " + (*mit).first + "(" + (*mit).second + ")";
            else
                res = res + (*mit).first + "(" + (*mit).second + ")";
            ++mit;
        }
    }
    return res;
}
