#pragma once

#include "util/generic/string.h"
#include "util/generic/hash.h"
#include "util/system/mutex.h"
#include "kfunc.h"

typedef THashMap<TString, TString> TKMap;
typedef TKMap::iterator TKMapIt;
typedef THashMap<TString, TKMap> TThreeDimHash;
typedef TThreeDimHash::iterator TThreeDimHashIt;

class TKConfig
{
private:
         static const int MAX_CONFIG_SIZE = 65535;
private:
        TString       m_config_filename;
        TThreeDimHash m_data;
        ui32          m_section_count;
        ui32          m_key_count;
        TMutex        m_Mutex;

  void          Lock();
        void          UnLock();

        ui32          GetStr(const char* source, ui32 source_size, char* destination, ui32 destination_size);
        TString       ReadValue(const TString& section, const TString& key, bool& exists);
public:
        TKConfig();
        ~TKConfig();

        bool    Load(const TString& config_filenameA);
        void    AddParam(const TString &section, const TString &key, const TString &value);
        bool    SectionExists(const TString& section);
        bool    KeyExists(const TString& section, const TString& key);
        TString ReadStroka(const TString& section, const TString& key, const TString& defaults);
        int     ReadInteger(const TString& section, const TString& key, int defaults);
        ui64    ReadUI64(const TString& section, const TString& key, ui64 defaults);
        bool    ReadBool(const TString& section, const TString& key, bool defaults);
        TString ReadPath(const TString& section, const TString& key, const TString& defaults);
        float   ReadFloat(const TString& section, const TString& key, float defaults);
        TString ConfigFilename() { return m_config_filename; }
        TString GetAllValueBySection(const TString& section);
};

