#include "tkcounterclass.h"

i64 TKAtomic::Value() {
    return AtomicGet(m_value);
}

i64 TKAtomic::Add(i64 value) {
    return AtomicAdd(m_value, value);
}

i64 TKAtomic::Swap(i64 value) {
    return AtomicSwap(&m_value, value);
}

i64 TKAtomic::Increment() {
    return AtomicIncrement(m_value);
}

i64 TKAtomic::Decrement() {
    return AtomicDecrement(m_value);
}

void TKCounterclass::Set(ui32 value) {
    m_value.Swap(value);
}

void TKCounterclass::Clear() {
    m_value.Swap(0);
}

i64 TKCounterclass::Increment() {
    return m_value.Increment();
}

i64 TKCounterclass::Value() {
    return m_value.Value();
}
