#include "tkinifile.h"

#include <util/string/reverse.h>

TKIniFile::TKIniFile() {
    data.clear();
    filename = "";
    m_change = false;
}

TKIniFile::~TKIniFile() {
    data.clear();
    m_order_list.clear();
}

void TKIniFile::Lock() {
    m_Mutex.Acquire();
}

void TKIniFile::UnLock() {
    m_Mutex.Release();
}

bool TKIniFile::ReadAll(int type, TString sectionA, TString keyA) {
    bool res = false;
    FILE* handle = nullptr;
    char BUFF[1024];
    char tbuff[1024];
    char sb1[1024];
    char* s = nullptr;
    TString skey = "", svalue = "", svalue_w = "";
    int n = 0;
    char *p = nullptr, *p2 = nullptr;
    TString ssection = "";
    bool fok = false;

    if (type == 0) //������ ������ ���������� ������ ��� ������ ������������
        m_order_list.clear();
    if (!filename.empty()) {
        handle = fopen(filename.c_str(), "rb");
        if (handle != nullptr) {
            res = true;
            memset(BUFF, 0, sizeof(BUFF));
            s = fgets(BUFF, sizeof(BUFF) - 1, handle);
            while (s != nullptr) {
                memset(tbuff, 0, sizeof(tbuff));
                n = sscanf(s, " %s", tbuff);
                if ((n > 0) && (tbuff[0] != '#') && (strlen(tbuff) > 0)) {
                    p = strstr(tbuff, "[");
                    if (p != nullptr) {
                        p2 = strstr(p + 1, "]");
                        if (p2 == nullptr)
                            ssection = TString(p + 1);
                        else
                            ssection = TString(p + 1, p2 - p - 1);
                        if ((type == 0) && (!ssection.empty())) //������ ������ ���������� ������ ��� ������ ������������
                            m_order_list.push_back(ssection);
                    } else {
                        memset(sb1, 0, sizeof(sb1));
                        p = strstr(s, "=");
                        if (p != nullptr) {
                            *p = 0x00;
                            sscanf(s, " %s ", sb1);
                            p++;
                            svalue_w = TString(p);
                            svalue_w = Trim(svalue_w);
                        } else {
                            sscanf(s, " %s ", sb1);
                        }
                        skey = TString(sb1);
                        svalue = svalue_w;

                        fok = false;
                        switch (type) {
                            case 0: //������������� ���
                                fok = true;
                                break;
                            case 1: //������������� ������ ������
                                if (ssection == sectionA)
                                    fok = true;
                                break;
                            case 2: //������������� ������������ ���� ������
                                if ((ssection == sectionA) && (skey == keyA))
                                    fok = true;
                                break;
                        };

                        if ((!ssection.empty()) && (fok)) {
                            TIniHashIt it;
                            TDBLStrokaListIt lit;

                            it = data.find(ssection);
                            if (it == data.end()) {
                                data[ssection] = TDBLStrokaList();
                                it = data.find(ssection);
                            }
                            if (it != data.end()) {
                                lit = (*it).second.find(skey);
                                if (lit != (*it).second.end()) {
                                    (*lit).second = svalue;
                                } else {
                                    ((*it).second)[skey] = svalue;
                                }
                            }
                        }
                    }
                }

                s = fgets(BUFF, sizeof(BUFF) - 1, handle);
            }

            fclose(handle);
        }
    }

    m_change = false;

    n = data.size();
    return res;
}

TString TKIniFile::ReadValue(TString section, TString key, bool& exists) {
    TString res = "";
    TIniHashIt it;
    TDBLStrokaListIt lit;

    exists = false;
    it = data.find(section);
    if (it != data.end()) {
        lit = (*it).second.find(key);
        if (lit != (*it).second.end()) {
            exists = true;
            res = (*lit).second;
        }
    }

    return res;
}

bool TKIniFile::WriteValue(TString section, TString key, TString value) {
    bool res = false;
    TIniHashIt it;
    TDBLStrokaListIt lit;

    it = data.find(section);
    if (it == data.end()) {
        data[section] = TDBLStrokaList();
        it = data.find(section);
    }

    if (it != data.end()) {
        lit = (*it).second.find(key);
        if (lit == (*it).second.end()) {
            ((*it).second)[key] = value;
            res = true;
        } else {
            (*lit).second = value;
            res = true;
        }
    }

    m_change = true;

    return res;
}

bool TKIniFile::Init(const TString& filenameA) {
    bool res = false;

    Lock();

    filename = filenameA;
    if (!filename.empty())
        res = ReadAll(0, "", "");

    UnLock();

    return res;
}

bool TKIniFile::SectionExists(const TString& section) {
    bool res = false;

    Lock();

    TIniHashIt it;

    it = data.find(section);
    if (it != data.end())
        res = true;

    UnLock();

    return res;
}

bool TKIniFile::KeyExists(const TString& section, const TString& key) {
    bool res = false;

    Lock();

    TIniHashIt it;
    TDBLStrokaListIt lit;

    it = data.find(section);
    if (it != data.end()) {
        lit = (*it).second.find(key);
        if (lit != (*it).second.end())
            res = true;
    }

    UnLock();

    return res;
}

bool TKIniFile::KeyExistsCompare(const TString& section, const TString& key) {
    bool res = false;

    Lock();

    TIniHashIt it;
    TDBLStrokaListIt lit;
    TString s1 = "", s2 = "";
    int n1 = 0, n2 = 0;
    bool onlycurhost = false;

    s2 = key;
    ReverseInPlace(s2);
    n2 = s2.size();
    it = data.find(section);
    if (it != data.end()) {
        lit = (*it).second.begin();
        while (lit != (*it).second.end()) {
            s1 = (*lit).first;
            if ((s1.length() > 1) && (s1[0] == '^')) {
                s1 = s1.substr(1, s1.length() - 1);
                onlycurhost = true;
            } else
                onlycurhost = false;
            ReverseInPlace(s1);
            n1 = s1.size();

            if (onlycurhost) {
                //���� ������ ������ �����
                if ((n1 > 0) && (n1 == n2) && (memcmp(s1.c_str(), s2.c_str(), n1) == 0)) {
                    res = true;
                    break;
                }
            } else {
                //����� �����
                if ((n1 > 0) && (n1 == n2) && (memcmp(s1.c_str(), s2.c_str(), n1) == 0)) {
                    res = true;
                    break;
                }
                //���� �������� ������ ����� �������� ������ �� ������������ � ������
                if ((n1 > 0) && (n2 > n1) && (s2[n1] == '.')) {
                    if (memcmp(s1.c_str(), s2.c_str(), n1) == 0) {
                        res = true;
                        break;
                    }
                }
            }

            ++lit;
        }
    }

    UnLock();

    return res;
}

bool TKIniFile::ReloadAll() {
    bool res = false;

    Lock();

    data.clear();
    res = ReadAll(0, "", "");

    UnLock();

    return res;
}

bool TKIniFile::ReloadSection(const TString& section) {
    bool res = false;

    Lock();

    res = ReadAll(1, section, "");

    UnLock();

    return res;
}

bool TKIniFile::ReloadKey(const TString& section, const TString& key) {
    bool res = false;

    Lock();

    res = ReadAll(2, section, key);

    UnLock();

    return res;
}

TString TKIniFile::GetAllField() {
    TString res = "";

    Lock();

    TIniHashIt it;
    TDBLStrokaListIt lit;
    TString section = "", key = "", value = "";
    std::list<TString> slist;
    std::list<TString>::iterator slistit;
    TString s = "";

    it = data.begin();
    while (it != data.end()) {
        section = (*it).first;
        slist.clear();
        lit = (*it).second.begin();
        while (lit != (*it).second.end()) {
            key = (*lit).first;
            value = (*lit).second;
            if (!value.empty())
                s = key + "=" + value;
            else
                s = key;
            slist.push_back(s);

            ++lit;
        }

        if (it == data.begin())
            res = res + section + "[";
        else
            res = res + ", " + section + "[";
        slist.sort();
        slistit = slist.begin();
        while (slistit != slist.end()) {
            if (slistit == slist.begin())
                res = res + (*slistit);
            else
                res = res + ", " + (*slistit);
            ++slistit;
        }
        res = res + "]";

        ++it;
    }
    res = res + ".";

    UnLock();

    return res;
}

bool WriteSection(TIniHash* data, FILE* handle, TString sectionname) {
    bool res = false;
    TIniHashIt it;
    TDBLStrokaListIt lit;
    TString skey = "";
    TString svalue = "";
    TString sectiondata = "";
    TString ssection = "";

    if (data != nullptr) {
        it = data->find(sectionname);
        if (it != data->end()) {
            sectiondata = "";
            ssection = (*it).first;
#ifdef _win_
            sectiondata = sectiondata + "\r\n[" + ssection + "]\r\n";
#else
            sectiondata = sectiondata + "\n[" + ssection + "]\n";
#endif
            lit = (*it).second.begin();
            while (lit != (*it).second.end()) {
                skey = (*lit).first;
                svalue = (*lit).second;
#ifdef _win_
                sectiondata = sectiondata + skey + "=" + svalue + "\r\n";
#else
                sectiondata = sectiondata + skey + "=" + svalue + "\n";
#endif
                res = true;

                ++lit;
            }
            fprintf(handle, "%s", sectiondata.c_str());
        }
    }

    return res;
}

bool TKIniFile::RewriteDiskFile2() {
    bool res = false;
    TIniHashIt it;
    TString ssection = "";
    FILE* handle = nullptr;

    Lock();

    if (!filename.empty()) {
        handle = fopen(filename.c_str(), "wb");
        if (handle != nullptr) {
            //write 'server' section
            if (WriteSection(&data, handle, "server"))
                res = true;

            //write 'filter' section
            if (WriteSection(&data, handle, "filter"))
                res = true;

            //write 'logs' section
            if (WriteSection(&data, handle, "logs"))
                res = true;

            //write other section
            it = data.begin();
            while (it != data.end()) {
                ssection = (*it).first;
                if ((ssection != "server") && (ssection != "filter") && (ssection != "logs")) {
                    if (WriteSection(&data, handle, ssection))
                        res = true;
                }

                ++it;
            }

            fclose(handle);
        }
    }

    if (res)
        m_change = false;

    UnLock();

    return res;
}

bool TKIniFile::RewriteDiskFile() {
    bool res = false;
    TIniHashIt it;
    TString ssection = "";
    FILE* handle = nullptr;
    TIStrokaListIt sit;
    TDBLStrokaList whash; //������ ������ ��� ���������� �� ����
    TDBLStrokaListIt whash_it;

    Lock();

    if (!filename.empty()) {
        handle = fopen(filename.c_str(), "wb");
        if (handle != nullptr) {
            whash.clear();

            sit = m_order_list.begin();
            while (sit != m_order_list.end()) {
                ssection = *sit;
                if (!ssection.empty()) {
                    if (WriteSection(&data, handle, ssection)) {
                        res = true;
                        whash[ssection] = "y";
                    } else
                        whash[ssection] = "n";
                }

                ++sit;
            }

            //write other section
            it = data.begin();
            while (it != data.end()) {
                ssection = (*it).first;
                if (!ssection.empty()) {
                    whash_it = whash.find(ssection);
                    if (whash_it == whash.end()) {
                        if (WriteSection(&data, handle, ssection)) {
                            res = true;
                            whash[ssection] = "y";
                        } else
                            whash[ssection] = "n";
                    }
                }
                ++it;
            }

            fclose(handle);

            whash.clear();
        }
    }

    if (res)
        m_change = false;

    UnLock();

    return res;
}

TString TKIniFile::ReadStroka(const TString& section, const TString& key, const TString& defaults) {
    TString res;

    Lock();

    bool exists = false;
    TString value = "";

    value = ReadValue(section, key, exists);
    if (exists)
        res = value;
    else
        res = defaults;

    UnLock();

    return res;
}

int TKIniFile::ReadInteger(const TString& section, const TString& key, int defaults) {
    int res = false;

    Lock();

    bool exists = false;
    TString value = "";

    value = ReadValue(section, key, exists);
    if (exists)
        res = atoi(value.c_str());
    else
        res = defaults;

    UnLock();

    return res;
}

ui64 TKIniFile::ReadUI64(const TString& section, const TString& key, ui64 defaults) {
    ui64 res = false;

    Lock();

    bool exists = false;
    TString value = "";

    value = ReadValue(section, key, exists);
    if (exists)
        sscanf(value.c_str(), "%" PRIu64, &res);
    else
        res = defaults;

    UnLock();

    return res;
}

bool TKIniFile::ReadBool(const TString& section, const TString& key, bool defaults) {
    bool res = false;

    Lock();

    bool exists = false;
    TString value = "";

    value = ReadValue(section, key, exists);
    if (exists)
        res = (bool)atoi(value.c_str());
    else
        res = defaults;

    UnLock();

    return res;
}

TString TKIniFile::ReadPath(const TString& section, const TString& key, const TString& defaults) {
    TString res;

    Lock();

    bool exists = false;
    TString value = "";

    value = ReadValue(section, key, exists);
    if (exists) {
#ifdef _win_
        char symb = '\\';
#else
        char symb = '/';
#endif

        res = value;
        if ((res.size() > 0) && (res.back() != symb))
            res = res + symb;

    } else
        res = defaults;

    UnLock();

    return res;
}

float TKIniFile::ReadFloat(const TString& section, const TString& key, float defaults) {
    float res = false;

    Lock();

    bool exists = false;
    TString value = "";

    value = ReadValue(section, key, exists);
    if (exists)
        res = (float)atof(value.c_str());
    else
        res = defaults;

    UnLock();

    return res;
}

bool TKIniFile::WriteStroka(const TString& section, const TString& key, const TString& value) {
    bool res = false;
    TString value_s = "";

    Lock();

    value_s = value;
    res = WriteValue(section, key, value_s);

    UnLock();

    return res;
}

bool TKIniFile::WriteInteger(const TString& section, const TString& key, int value) {
    bool res = false;
    TString value_s = "";

    Lock();

    value_s = IntToStroka(value);
    res = WriteValue(section, key, value_s);

    UnLock();

    return res;
}

bool TKIniFile::WriteUI64(const TString& section, const TString& key, ui64 value) {
    bool res = false;
    TString value_s = "";

    Lock();

    value_s = UI64ToStroka(value);
    res = WriteValue(section, key, value_s);

    UnLock();

    return res;
}

bool TKIniFile::WriteBool(const TString& section, const TString& key, bool value) {
    bool res = false;
    TString value_s = "";

    Lock();

    value_s = BoolToStroka(value);
    res = WriteValue(section, key, value_s);

    UnLock();

    return res;
}

bool TKIniFile::WriteFloat(const TString& section, const TString& key, float value) {
    bool res = false;
    TString value_s = "";

    Lock();

    value_s = FloatToStr5(value);
    res = WriteValue(section, key, value_s);

    UnLock();

    return res;
}

bool TKIniFile::IsChanged() {
    return m_change;
}

TString TKIniFile::GetAllValueBySection(const TString& section) {
    TString res = "";
    TIniHashIt it;
    TDBLStrokaListIt mit;

    Lock();

    it = data.find(section);
    if (it != data.end()) {
        mit = (*it).second.begin();
        while (mit != (*it).second.end()) {
            if (!res.empty())
                res = res + ", " + (*mit).first + "(" + (*mit).second + ")";
            else
                res = res + (*mit).first + "(" + (*mit).second + ")";

            ++mit;
        }
    }

    UnLock();

    return res;
}
