#pragma once

#ifndef tkinifile_H
#define tkinifile_H

#include <list>
//#ifdef VERSION_TAG
#include "util/generic/hash.h"
#include "util/system/mutex.h"
//#else
//#  include "util/yhash.h"
//#  include "util/sysmutex.h"
//#endif
#include "kfunc.h"

struct TDBLStroka {
    TString key;
    TString value;

    TDBLStroka() {
        Clear();
    }

    TDBLStroka(TString keyA, TString valueA) {
        Clear();
        key = keyA;
        value = valueA;
    }

    void Clear() {
        key = "";
        value = "";
    }
};

typedef THashMap<TString, TString> TDBLStrokaList;
typedef TDBLStrokaList::iterator TDBLStrokaListIt;

typedef THashMap<TString, TDBLStrokaList> TIniHash;
typedef TIniHash::iterator TIniHashIt;

typedef std::list<TString> TIStrokaList;
typedef TIStrokaList::iterator TIStrokaListIt;

class TKIniFile {
private:
    TIniHash data;
    TString filename;
    //#ifdef VERSION_TAG
    TMutex m_Mutex;
    //#else
    //        Os::Thread_Mutex   m_Mutex;
    //#endif
    bool m_change;
    TIStrokaList m_order_list;

    void Lock();
    void UnLock();
    bool ReadAll(int type, TString sectionA, TString keyA);
    TString ReadValue(TString section, TString key, bool& exists);
    bool WriteValue(TString section, TString key, TString value);

public:
    TKIniFile();
    ~TKIniFile();

    bool Init(const TString& filenameA);

    bool SectionExists(const TString& section);
    bool KeyExists(const TString& section, const TString& key);
    bool KeyExistsCompare(const TString& section, const TString& key);
    bool ReloadAll();
    bool ReloadSection(const TString& section);
    bool ReloadKey(const TString& section, const TString& key);
    TString GetAllField();
    bool RewriteDiskFile();
    bool RewriteDiskFile2();

    TString ReadStroka(const TString& section, const TString& key, const TString& defaults);
    int ReadInteger(const TString& section, const TString& key, int defaults);
    ui64 ReadUI64(const TString& section, const TString& key, ui64 defaults);
    bool ReadBool(const TString& section, const TString& key, bool defaults);
    TString ReadPath(const TString& section, const TString& key, const TString& defaults); //��������� '/' ���� ��� ���
    float ReadFloat(const TString& section, const TString& key, float defaults);

    bool WriteStroka(const TString& section, const TString& key, const TString& value);
    bool WriteInteger(const TString& section, const TString& key, int value);
    bool WriteUI64(const TString& section, const TString& key, ui64 value);
    bool WriteBool(const TString& section, const TString& key, bool value);
    bool WriteFloat(const TString& section, const TString& key, float value);

    bool IsChanged();
    TString GetFilename() {
        return filename;
    }
    TString GetAllValueBySection(const TString& section);
};

#endif
