#pragma once

#ifndef tkipv6classes_H
#define tkipv6classes_H

#include "util/generic/string.h"
#include "util/system/mutex.h"
#include "tkipv6.h"
#include "kfunc.h"
#include "tlogclass.h"
#include <list>

//#define K_PRINT_ONLY_STAT

//********************************************************************************************************************
//                                                 THashStatK
//********************************************************************************************************************

struct THashStatK {
    ui32 trace_count;
    ui32 no_trace_count;
    ui32 bad_count;
    ui32 dublicat_count;

    THashStatK() {
        Clear();
    }

    void Clear() {
        trace_count = 0;
        no_trace_count = 0;
        bad_count = 0;
        dublicat_count = 0;
    }
};

//*********************************************************************************************************************
//                                                 THashKIPv6
//*********************************************************************************************************************

struct TFileStateK {
    time_t mtime;
    long size;

    TFileStateK() {
        mtime = 0;
        size = 0;
    }
};

class THashKIPv6 {
private:
    static const int MAX_FILE_SIZE = 33000000;

private:
    TString m_filename;
    TFileStateK m_statHashIp;
    bool m_clear_before_load;

    ui32 GetStr(const char* source, ui32 source_size, char* destination, ui32 destination_size);
    void ReloadMemListA(const char* buff, int buff_size, THashStatK& stat);
    virtual void ParseItem(const char* str, THashStatK& stat) = 0;
    virtual void ClearData() = 0;
    virtual TString GetResultPrint(THashStatK& stat, ui32 timedelay) = 0;
    virtual void TriggerFunction() = 0;
    virtual void PrefixFunction() = 0;
    virtual void PostfixFunction() = 0;
    bool ExistsFile();
    bool FileStateWasChangedK(const char* fn, TFileStateK* poldbufstat);

public:
    TLogClass* Log;
    TString m_ident;
    TMutex m_Mutex;
    TMutex m_MutexLoad; //�� ����� �������� ����� ������

    void Lock();
    void UnLock();
    void LockLoad();
    void UnLockLoad();
    ui64 CalcShingle(const TString& str_data);
    TString IntToStroka(int value);
    TString KTrim(const TString& s);
    ui32 IncMax32(const ui32 value, const ui32 step);
    TString IntToIpV4(ui32 ip);
    char* STRNCPY(char* strDest, const char* strSource, size_t DestSize, size_t count);
    bool IpToIntV4(const char* pstr, int len, ui32* pnet, ui32* pip);

public:
    THashKIPv6();
    THashKIPv6(const THashKIPv6& value);
    virtual ~THashKIPv6();

    void InitBase(const TString& ident, const TString& filename, TLogClass* LogsA, bool clear_before_load);
    void ReloadFileList();
    void ReloadMemList(const TString& data);
};

//*********************************************************************************************************************
//                                                 TNetKIPv6
//*********************************************************************************************************************

#define SYMB_RANGE1 0x01
#define SYMB_RANGE2 0x02
#define IS_SYMB_RANGE1(flag) ((flag)&SYMB_RANGE1)
#define IS_SYMB_RANGE2(flag) ((flag)&SYMB_RANGE2)

struct TWKIPv6 {
    TKIPv6 ip1;
    TKIPv6 ip2;

    TWKIPv6() {
        ip1 = TKIPv6();
        ip2 = TKIPv6();
    }
};

typedef std::list<TWKIPv6> TWKIPv6List;
typedef TWKIPv6List::iterator TWKIPv6ListIt;

typedef THashMap<ui64, TString> TStrokaHash;
typedef TStrokaHash::iterator TStrokaHashIt;

class TNetKIPv6: public THashKIPv6 {
public:
    enum TRecordType { TUNDEF,
                       THOST,
                       TIPNET,
                       TIPRANGE,
                       TIPADDRESS };

private:
    TStrokaHash* host_data;
    TStrokaHash* host_data_temp;
    TWKIPv6List* range_data;
    TWKIPv6List* range_data_temp;
    ui8 SymbTable[256];
    TString idents;

    virtual void ParseItem(const char* str, THashStatK& stat);
    virtual void ClearData();
    virtual TString GetResultPrint(THashStatK& stat, ui32 timedelay);
    virtual void TriggerFunction();
    virtual void PrefixFunction();
    virtual void PostfixFunction();
    TString NormalizeStr(const char* str, int strlength);
    TRecordType GetRecordType(const char* str, size_t strlength);
    void InitTable();
    bool IsAllowSymbolRange1(char symb);
    bool IsAllowSymbolRange2(char symb);
    bool ParseRangeType1(const TString& text, TWKIPv6& value);
    bool ParseRangeType2(const TString& text, TWKIPv6& value);

public:
    TNetKIPv6(const TString& ident);
    virtual ~TNetKIPv6();

    void Init(const TString& filename, TLogClass* LogA);
    bool IsInNet(const char* phost);
    bool IsInNet(TKIPv6 ip);
    bool IsInNet(TKIPv6 ip, TKIPv6& min_ip_from_diapason);

    TRecordType GetAddresses(const TString& addr_text, TWKIPv6& value);
};

//**********************************************************************************************************************

#endif
