#include <stdarg.h>
#include "tlogclass.h"
#include "tkinifile.h"
#include <util/string/reverse.h>
#include <util/generic/scope.h>

//**************************************************************************************
//                              TBaseLogClass
//**************************************************************************************

TBaseLogClass::TBaseLogClass() {
    enable_write = true;
}

TBaseLogClass::~TBaseLogClass() {
}

void TBaseLogClass::Lock() {
    m_Mutex.Acquire();
}

void TBaseLogClass::UnLock() {
    m_Mutex.Release();
}

TString TBaseLogClass::KTrim(TString s) {
    TString res = "", stemp = s;
    int nb = 0, ne = 0, nbc = 0, nec = 0;
    TString::iterator it;
    int count = 0;

    it = stemp.begin();
    while (it != stemp.end()) {
        nb++;
        if ((*it) != ' ')
            break;
        ++it;
    }

    ReverseInPlace(stemp);
    it = stemp.begin();
    while (it != stemp.end()) {
        ne++;
        if ((*it) != ' ')
            break;
        ++it;
    }

    nbc = nb > 0 ? nb - 1 : 0;
    nec = ne > 0 ? ne - 1 : 0;
    count = s.size() - nbc - nec;
    if (count > 0)
        res = s.substr(nbc, count);

    return res;
}

void TBaseLogClass::DisableWrite() {
    Lock();

    enable_write = false;

    UnLock();
}

void TBaseLogClass::EnableWrite() {
    Lock();

    enable_write = true;

    UnLock();
}

bool TBaseLogClass::GetWriteStatus() {
    bool res = false;

    Lock();

    res = enable_write;

    UnLock();

    return res;
}

TString TBaseLogClass::GetWriteStatusS() {
    TString res = "";

    Lock();

    if (enable_write)
        res = "enable write";
    else
        res = "disable write";

    UnLock();

    return res;
}

//**************************************************************************************
//                              TLogClass
//**************************************************************************************

TLogClass::TLogClass(const TString& filenameA, bool AddDate) {
    filename = filenameA;
    filenamearx = filenameA;
    handle = nullptr;
    fadddate = AddDate;
    fyear = 0;
    fmon = 0;
    fday = 0;
    lifetime = 0;
    lifetimeArx = 0;
    openfilemode = "ab";
    disable_fflush = true;
    fileshap = "";
    m_isset_diffpos = false;

    tfilename = GetFilename();
    if (tfilename != "") {
        CreateFileIfNotExists(tfilename);
        handle = fopen(tfilename.c_str(), openfilemode.c_str());
    }
}

TLogClass::TLogClass(const TString& filenameA, bool AddDate, const TString& shapA) {
    filename = filenameA;
    filenamearx = filenameA;
    handle = nullptr;
    fadddate = AddDate;
    fyear = 0;
    fmon = 0;
    fday = 0;
    lifetime = 0;
    lifetimeArx = 0;
    openfilemode = "ab";
    disable_fflush = true;
    fileshap = shapA;

    tfilename = GetFilename();
    if (tfilename != "") {
        CreateFileIfNotExists(tfilename);
        handle = fopen(tfilename.c_str(), openfilemode.c_str());
        if (!fileshap.empty() && (handle != nullptr)) {
            fprintf(handle, "%s", fileshap.c_str());
            if (!disable_fflush)
                fflush(handle);
        }
    }
}

TLogClass::~TLogClass() {
    if (handle != nullptr) {
        fclose(handle);
        handle = nullptr;
    }
}

void TLogClass::SetLifeTime(ui16 lifetimeA) {
    Lock();

    lifetime = lifetimeA;

    UnLock();
}

ui16 TLogClass::GetLifeTime() {
    return lifetime;
}

void TLogClass::SetLifeTimeArx(ui16 lifetimeA) {
    Lock();

    lifetimeArx = lifetimeA;

    UnLock();
}

ui16 TLogClass::GetLifeTimeArx() {
    return lifetimeArx;
}

TString TLogClass::GetBaseFilename() {
    return filename;
}

TString TLogClass::GetTimeFilename(time_t ttek, bool& del) {
    TString res = "";
    ui16 year = 0, mon = 0, day = 0;
    char tbuff[1025];
    TString sname = "", sdate = "", sext = "";
    char* p = nullptr;
    tm ttm;
    time_t ttoday = time(nullptr);
    tm tmtoday;
    time_t tmodtoday = 0;

    del = false;
    ttm = *localtime(&ttek);
    year = 1900 + ttm.tm_year;
    mon = ttm.tm_mon + 1;
    day = ttm.tm_mday;
    memset(tbuff, 0, sizeof(tbuff));
    snprintf(tbuff, sizeof(tbuff) - 1, "%04d-%02d-%02d", year, mon, day);
    sdate.assign(tbuff);

    memset(tbuff, 0, sizeof(tbuff));
    strncpy(tbuff, filename.c_str(), sizeof(tbuff) - 1);
    p = strstr(tbuff, ".");
    if (p != nullptr) {
        sext.assign(p);
        *p = 0x00;
    }
    sname.assign(tbuff);
    res = sname + "_" + sdate + sext;

    if (lifetime > 0) {
        tmtoday = *localtime(&ttoday);
        tmtoday.tm_hour = 0;
        tmtoday.tm_min = 0;
        tmtoday.tm_sec = 0;
        tmodtoday = mktime(&tmtoday);
        if (ttek < (tmodtoday - (ui32)(lifetime * 3600 * 24)))
            del = true;
    }

    return res;
}

TString TLogClass::GetTimeFilenameArx(time_t ttek, bool& del) {
    TString res = "";
    ui16 year = 0, mon = 0, day = 0;
    char tbuff[1025];
    TString sname = "", sdate = "", sext = "";
    char* p = nullptr;
    tm ttm;
    time_t ttoday = time(nullptr);
    tm tmtoday;
    time_t tmodtoday = 0;

    del = false;
    ttm = *localtime(&ttek);
    year = 1900 + ttm.tm_year;
    mon = ttm.tm_mon + 1;
    day = ttm.tm_mday;
    memset(tbuff, 0, sizeof(tbuff));
    snprintf(tbuff, sizeof(tbuff) - 1, "%04d-%02d-%02d", year, mon, day);
    sdate.assign(tbuff);

    memset(tbuff, 0, sizeof(tbuff));
    strncpy(tbuff, filenamearx.c_str(), sizeof(tbuff) - 1);
    p = strstr(tbuff, ".");
    if (p != nullptr) {
        sext.assign(p);
        *p = 0x00;
    }
    sname.assign(tbuff);
    res = sname + "_" + sdate + sext;

    if (lifetimeArx > 0) {
        tmtoday = *localtime(&ttoday);
        tmtoday.tm_hour = 0;
        tmtoday.tm_min = 0;
        tmtoday.tm_sec = 0;
        tmodtoday = mktime(&tmtoday);
        if (ttek < (tmodtoday - (ui32)(lifetimeArx * 3600 * 24)))
            del = true;
    }

    return res;
}

TString TLogClass::GetTimeOnlyFilenameArx(time_t ttek) {
    TString res = "";
    ui16 year = 0, mon = 0, day = 0;
    char tbuff[1025];
    TString sname = "", sdate = "", sext = "";
    char* p = nullptr;
    tm ttm;

    ttm = *localtime(&ttek);
    year = 1900 + ttm.tm_year;
    mon = ttm.tm_mon + 1;
    day = ttm.tm_mday;
    memset(tbuff, 0, sizeof(tbuff));
    snprintf(tbuff, sizeof(tbuff) - 1, "%04d-%02d-%02d", year, mon, day);
    sdate.assign(tbuff);

    memset(tbuff, 0, sizeof(tbuff));
    strncpy(tbuff, filenamearx.c_str(), sizeof(tbuff) - 1);
    p = strstr(tbuff, ".");
    if (p != nullptr) {
        sext.assign(p);
        *p = 0x00;
    }
    sname.assign(tbuff);
    res = sname + "_" + sdate + sext;

    return res;
}

TString TLogClass::GetFilename() {
    if (filename == "")
        return "";

    if (!fadddate)
        return filename;

    TString res = "";
    //tm     ttime;
    time_t t;
    ui16 year = 0, mon = 0, day = 0;

    t = time(nullptr);
    tm ttm = *localtime(&t);
    year = 1900 + ttm.tm_year;
    mon = ttm.tm_mon + 1;
    day = ttm.tm_mday;

    if ((year == fyear) && (mon == fmon) && (day == fday)) {
        res = tfilename;
    } else {
        char tbuff[1025];
        TString sname = "", sdate = "", sext = "";
        char* p;

        memset(tbuff, 0, sizeof(tbuff));
        snprintf(tbuff, sizeof(tbuff) - 1, "%04d-%02d-%02d", year, mon, day);
        sdate.assign(tbuff);

        memset(tbuff, 0, sizeof(tbuff));
        strncpy(tbuff, filename.c_str(), sizeof(tbuff) - 1);
        p = strstr(tbuff, ".");
        if (p != nullptr) {
            sext.assign(p);
            *p = 0x00;
        }
        sname.assign(tbuff);
        tfilename = sname + "_" + sdate + sext;
        fyear = year;
        fmon = mon;
        fday = day;
        res = tfilename;
    }

    return res;
}

bool TLogClass::filename_change() {
    if (!fadddate)
        return false;

    bool res = false;
    //tm     ttime;
    time_t t;
    ui16 year = 0, mon = 0, day = 0;

    t = time(nullptr);
    tm ttm = *localtime(&t);
    year = 1900 + ttm.tm_year;
    mon = ttm.tm_mon + 1;
    day = ttm.tm_mday;

    if ((year != fyear) || (mon != fmon) || (day != fday))
        res = true;

    return res;
}

void TLogClass::CreateFileIfNotExists(const TString& filename) {
    int handle = -1;
    int flags = 0;
    //char    buff[512];
    int umaskv = 0;
    int nmaskv = 0;
    int resmask = 0;
    TString mask_to_binary = "";
    TString umask_to_binary = "";
    TString nmask_to_binary = "";
    TString resmask_to_binary = "";

#ifndef _win_
    //flags  = S_IRUSR | S_IWUSR | S_IRGRP | S_IROTH | S_IWOTH;
    flags = S_IRUSR | S_IWUSR | S_IRGRP | S_IROTH;
    nmaskv = 0;
    umaskv = umask(nmaskv);
#else
    flags = S_IREAD | S_IWRITE;
#endif

    resmask = flags & (~nmaskv);
    handle = open(filename.c_str(), O_CREAT | O_RDWR, flags);
    if (handle >= 0) {
        mask_to_binary = /*ui32ToBinary(flags) + ":" + */ FilemaskToBinary(flags);
        umask_to_binary = FilemaskToBinary(umaskv);
        nmask_to_binary = FilemaskToBinary(nmaskv);
        resmask_to_binary = FilemaskToBinary(resmask);
        //memset(buff, 0, sizeof(buff));
        //count = snprintf(buff, sizeof(buff) - 1, "#FATTR: %X(%s), UMASK: %X(%s), NEWMASK: %X(%s), RESMASK: %X(%s)\n", flags, mask_to_binary.c_str(), umaskv, umask_to_binary.c_str(), nmaskv, nmask_to_binary.c_str(), resmask, resmask_to_binary.c_str());
        //write(handle, buff, count);
        close(handle);
    }
}

void TLogClass::SetDiffPoint() {
    Lock();

    if (handle != nullptr) {
        fseek(handle, 0, SEEK_END);
        if (!fgetpos(handle, &m_diffpos))
            m_isset_diffpos = true;
    }

    UnLock();
}

TString TLogClass::GetDiff() {
    TString res = "";

    char tbuff[1024];
    char* s = nullptr;

    Lock();

    if (handle != nullptr)
        fclose(handle);

    handle = fopen(tfilename.c_str(), "rb");
    if (handle != nullptr) {
        if ((m_isset_diffpos) && (!fsetpos(handle, &m_diffpos))) {
            do {
                memset(tbuff, 0, sizeof(tbuff));
                s = fgets(tbuff, sizeof(tbuff) - 1, handle);
                if (s != nullptr)
                    res = res + TString(s) + "<br>";

            } while (!feof(handle) && !ferror(handle));
            m_isset_diffpos = false;
        }
        fclose(handle);
    }
    handle = fopen(tfilename.c_str(), openfilemode.c_str());

    UnLock();

    char ttb[32];
    ui32 sv = sizeof(m_diffpos);
    memset(ttb, 0, sizeof(ttb));
    snprintf(ttb, sizeof(ttb) - 1, "%u", sv);

    return res;
}

TString TLogClass::GetDiff2() {
    TString res = "";

    char tbuff[1024];
    char* s = nullptr;
    int count = 0;
    int buffsize = 0;
    int inbuffsize = 0;
    char* buff = nullptr;
    TString st = "";
    long fsize = 0, fpos = 0;

    Lock();

    if (handle != nullptr)
        fclose(handle);

    handle = fopen(tfilename.c_str(), "rb");
    if (handle != nullptr) {
        //���������� ������ ������ ��� ������
        if (m_isset_diffpos) {
            fseek(handle, 0, SEEK_END);
            fsize = ftell(handle);

            if (!fsetpos(handle, &m_diffpos)) {
                fpos = ftell(handle);

                if (fsize > fpos) {
                    buffsize = fsize - fpos;
                    if (buffsize > 0) {
                        buffsize = buffsize * 2;
                        buff = new char[buffsize];
                        buff[0] = 0x00;

                        do {
                            memset(tbuff, 0, sizeof(tbuff));
                            s = fgets(tbuff, sizeof(tbuff) - 1, handle);
                            if (s != nullptr) {
                                st = TString(s) + "<br>";
                                count = buffsize - inbuffsize - 1;
                                if (count > 0) {
                                    strncat(buff, st.c_str(), count);
                                    inbuffsize += st.length();
                                }
                            }

                        } while (!feof(handle) && !ferror(handle));

                        m_isset_diffpos = false;

                        if (buff != nullptr) {
                            res = TString(buff);

                            delete[] buff;
                            buff = nullptr;
                        }
                    }
                }
            }
        }
        fclose(handle);
    }
    handle = fopen(tfilename.c_str(), openfilemode.c_str());

    UnLock();

    char ttb[32];
    ui32 sv = sizeof(m_diffpos);
    memset(ttb, 0, sizeof(ttb));
    snprintf(ttb, sizeof(ttb) - 1, "%u", sv);

    return res;
}

bool TLogClass::TruncLog() {
    bool res = false;

    Lock();

    if (handle != nullptr) {
        fclose(handle);
        handle = nullptr;
    }
    tfilename = GetFilename();
    if (tfilename != "") {
        CreateFileIfNotExists(tfilename);
        handle = fopen(tfilename.c_str(), openfilemode.c_str());
        if (!fileshap.empty() && (handle != nullptr)) {
            fprintf(handle, "%s", fileshap.c_str());
            if (!disable_fflush)
                fflush(handle);
        }
        res = true;
    }

    UnLock();

    return res;
}

bool TLogClass::WriteMessage(const char* msg, ...) {
    bool res = false;

    Lock();

    if (enable_write) {
        if (filename_change()) {
            if (handle != nullptr) {
                fclose(handle);
                handle = nullptr;
            }
            tfilename = GetFilename();
            if (tfilename != "") {
                CreateFileIfNotExists(tfilename);
                handle = fopen(tfilename.c_str(), openfilemode.c_str());
                if (!fileshap.empty() && (handle != nullptr)) {
                    fprintf(handle, "%s", fileshap.c_str());
                    if (!disable_fflush)
                        fflush(handle);
                }
            }
        }
        if ((handle == nullptr) && (tfilename != "")) {
            CreateFileIfNotExists(tfilename);
            handle = fopen(tfilename.c_str(), openfilemode.c_str());
            if (!fileshap.empty() && (handle != nullptr)) {
                fprintf(handle, "%s", fileshap.c_str());
                if (!disable_fflush)
                    fflush(handle);
            }
        }
        if (handle != nullptr) {
            va_list args;

            va_start(args, msg);
            vfprintf(handle, msg, args);
            va_end(args);
            if (!disable_fflush)
                fflush(handle);
            res = true;
        }
    }

    UnLock();

    return res;
}

bool TLogClass::WriteMessageBUFF(const char* BUFF, ui32 BUFFSize) {
    bool res = false;

    Lock();

    if (enable_write) {
        if (filename_change()) {
            if (handle != nullptr) {
                fclose(handle);
                handle = nullptr;
            }
            tfilename = GetFilename();
            if (tfilename != "") {
                CreateFileIfNotExists(tfilename);
                handle = fopen(tfilename.c_str(), openfilemode.c_str());
                if (!fileshap.empty() && (handle != nullptr)) {
                    fprintf(handle, "%s", fileshap.c_str());
                    if (!disable_fflush)
                        fflush(handle);
                }
            }
        }
        if ((handle == nullptr) && (tfilename != "")) {
            CreateFileIfNotExists(tfilename);
            handle = fopen(tfilename.c_str(), openfilemode.c_str());
            if (!fileshap.empty() && (handle != nullptr)) {
                fprintf(handle, "%s", fileshap.c_str());
                if (!disable_fflush)
                    fflush(handle);
            }
        }
        if (handle != nullptr) {
            fwrite(BUFF, BUFFSize, 1, handle);
            if (!disable_fflush)
                fflush(handle);
            res = true;
        }
    }

    UnLock();

    return res;
}

bool TLogClass::WriteMessageAndData(const char* msg, ...) {
    bool res = false;

    Lock();

    if (enable_write) {
        if (filename_change()) {
            if (handle != nullptr) {
                fclose(handle);
                handle = nullptr;
            }
            tfilename = GetFilename();
            if (tfilename != "") {
                CreateFileIfNotExists(tfilename);
                handle = fopen(tfilename.c_str(), openfilemode.c_str());
                if (!fileshap.empty() && (handle != nullptr)) {
                    fprintf(handle, "%s", fileshap.c_str());
                    if (!disable_fflush)
                        fflush(handle);
                }
            }
        }
        if ((handle == nullptr) && (tfilename != "")) {
            CreateFileIfNotExists(tfilename);
            handle = fopen(tfilename.c_str(), openfilemode.c_str());
            if (!fileshap.empty() && (handle != nullptr)) {
                fprintf(handle, "%s", fileshap.c_str());
                if (!disable_fflush)
                    fflush(handle);
            }
        }
        if (handle != nullptr) {
            va_list args;
            char buf[2048];
            char tbuff[32];
            int n = 0;
            tm ttime;
            time_t tt = time(nullptr);

            memset(buf, 0, sizeof(buf));
            memset(tbuff, 0, sizeof(tbuff));

            ttime = *localtime(&tt);
            strftime(tbuff, sizeof(tbuff) - 1, "[%Y.%m.%d %H:%M:%S]", &ttime);
            n = n + snprintf(buf + n, sizeof(buf) - n - 1, "%s ", tbuff);

            fprintf(handle, "%s", buf);
            va_start(args, msg);
            //vsnprintf(buf + n, sizeof(buf) - n - 1, msg, args);
            vfprintf(handle, msg, args);
            va_end(args);
            fprintf(handle, "\n");

            //fprintf(handle, "%s\n", buf);
            if (!disable_fflush)
                fflush(handle);
            res = true;
        }
    }

    UnLock();

    return res;
}

bool TLogClass::WriteMessageAndDataBUFF(const char* BUFF, ui32 BUFFSize) {
    bool res = false;

    Lock();

    if (enable_write) {
        if (filename_change()) {
            if (handle != nullptr) {
                fclose(handle);
                handle = nullptr;
            }
            tfilename = GetFilename();
            if (tfilename != "") {
                CreateFileIfNotExists(tfilename);
                handle = fopen(tfilename.c_str(), openfilemode.c_str());
                if (!fileshap.empty() && (handle != nullptr)) {
                    fprintf(handle, "%s", fileshap.c_str());
                    if (!disable_fflush)
                        fflush(handle);
                }
            }
        }
        if ((handle == nullptr) && (tfilename != "")) {
            CreateFileIfNotExists(tfilename);
            handle = fopen(tfilename.c_str(), openfilemode.c_str());
            if (!fileshap.empty() && (handle != nullptr)) {
                fprintf(handle, "%s", fileshap.c_str());
                if (!disable_fflush)
                    fflush(handle);
            }
        }
        if (handle != nullptr) {
            char buf[2048];
            char tbuff[32];
            int n = 0;
            tm ttime;
            time_t tt = time(nullptr);
            //char    pidstr[MAX_STR_PID];

            memset(buf, 0, sizeof(buf));

            ttime = *localtime(&tt);
            strftime(tbuff, sizeof(tbuff) - 1, "[%Y.%m.%d %H:%M:%S]", &ttime);
            n = n + snprintf(buf + n, sizeof(buf) - n - 1, "%s ", tbuff);

            fprintf(handle, "%s", buf);
            fwrite(BUFF, BUFFSize, 1, handle);
            fprintf(handle, "\n");
            if (!disable_fflush)
                fflush(handle);
            res = true;
        }
    }

    UnLock();

    return res;
}

bool TLogClass::WriteMessageAndDataBUFFExt(const char* prefix, const char* postfix, const char* BUFF, ui32 BUFFSize) {
    bool res = false;

    Lock();

    if (enable_write) {
        if (filename_change()) {
            if (handle != nullptr) {
                fclose(handle);
                handle = nullptr;
            }
            tfilename = GetFilename();
            if (tfilename != "") {
                CreateFileIfNotExists(tfilename);
                handle = fopen(tfilename.c_str(), openfilemode.c_str());
                if (!fileshap.empty() && (handle != nullptr)) {
                    fprintf(handle, "%s", fileshap.c_str());
                    if (!disable_fflush)
                        fflush(handle);
                }
            }
        }
        if ((handle == nullptr) && (tfilename != "")) {
            CreateFileIfNotExists(tfilename);
            handle = fopen(tfilename.c_str(), openfilemode.c_str());
            if (!fileshap.empty() && (handle != nullptr)) {
                fprintf(handle, "%s", fileshap.c_str());
                if (!disable_fflush)
                    fflush(handle);
            }
        }
        if (handle != nullptr) {
            char buf[2048];
            char tbuff[32];
            int n = 0;
            tm ttime;
            time_t tt = time(nullptr);

            memset(buf, 0, sizeof(buf));

            ttime = *localtime(&tt);
            strftime(tbuff, sizeof(tbuff) - 1, "[%Y.%m.%d %H:%M:%S]", &ttime);
            n = n + snprintf(buf + n, sizeof(buf) - n - 1, "%s ", tbuff);

            fprintf(handle, "%s", buf);
            fprintf(handle, "%s", prefix);
            fwrite(BUFF, BUFFSize, 1, handle);
            fprintf(handle, "%s", postfix);
            fprintf(handle, "\n");
            if (!disable_fflush)
                fflush(handle);
            res = true;
        }
    }

    UnLock();

    return res;
}

bool TLogClass::WriteMessageAndDataStatus(TLogStatus status, const char* msg, ...) {
    bool res = false;

    Lock();

    if (enable_write) {
        if (filename_change()) {
            if (handle != nullptr) {
                fclose(handle);
                handle = nullptr;
            }
            tfilename = GetFilename();
            if (tfilename != "") {
                CreateFileIfNotExists(tfilename);
                handle = fopen(tfilename.c_str(), openfilemode.c_str());
                if (!fileshap.empty() && (handle != nullptr)) {
                    fprintf(handle, "%s", fileshap.c_str());
                    if (!disable_fflush)
                        fflush(handle);
                }
            }
        }
        if ((handle == nullptr) && (tfilename != "")) {
            CreateFileIfNotExists(tfilename);
            handle = fopen(tfilename.c_str(), openfilemode.c_str());
            if (!fileshap.empty() && (handle != nullptr)) {
                fprintf(handle, "%s", fileshap.c_str());
                if (!disable_fflush)
                    fflush(handle);
            }
        }
        if (handle != nullptr) {
            va_list args;
            char buf[2048];
            char tbuff[32];
            int n = 0;
            TString sstatus = "";
            tm ttime;
            time_t tt = time(nullptr);
            char pidstr[MAX_STR_PID];

            switch (status) {
                case KERROR:
                    sstatus = "  Err!  ";
                    break;
                case KMESSAGE:
                    sstatus = "  Mes!  ";
                    break;
                case KWARNING:
                    sstatus = "  Warn! ";
                    break;
                case KINFO:
                    sstatus = "  Inf!  ";
                    break;
            };

            memset(buf, 0, sizeof(buf));
            memset(tbuff, 0, sizeof(tbuff));

            ttime = *localtime(&tt);
            strftime(tbuff, sizeof(tbuff) - 1, "[%Y.%m.%d %H:%M:%S]", &ttime);
            n = n + snprintf(buf + n, sizeof(buf) - n - 1, "%s %s %8s ", tbuff, GetStrPid(pidstr), sstatus.c_str());

            fprintf(handle, "%s", buf);
            va_start(args, msg);
            //vsnprintf(buf + n, sizeof(buf) - n - 1, msg, args);
            vfprintf(handle, msg, args);
            va_end(args);
            fprintf(handle, "\n");

            //fprintf(handle, "%s\n", buf);
            if (!disable_fflush)
                fflush(handle);
            res = true;
        }
    }

    UnLock();

    return res;
}

bool TLogClass::WriteMessageAndDataStatusBUFF(TLogStatus status, const char* BUFF, ui32 BUFFSize) {
    bool res = false;

    Lock();

    if (enable_write) {
        if (filename_change()) {
            if (handle != nullptr) {
                fclose(handle);
                handle = nullptr;
            }
            tfilename = GetFilename();
            if (tfilename != "") {
                CreateFileIfNotExists(tfilename);
                handle = fopen(tfilename.c_str(), openfilemode.c_str());
                if (!fileshap.empty() && (handle != nullptr)) {
                    fprintf(handle, "%s", fileshap.c_str());
                    if (!disable_fflush)
                        fflush(handle);
                }
            }
        }
        if ((handle == nullptr) && (tfilename != "")) {
            CreateFileIfNotExists(tfilename);
            handle = fopen(tfilename.c_str(), openfilemode.c_str());
            if (!fileshap.empty() && (handle != nullptr)) {
                fprintf(handle, "%s", fileshap.c_str());
                if (!disable_fflush)
                    fflush(handle);
            }
        }
        if (handle != nullptr) {
            //va_list args;
            char buf[2048];
            char tbuff[32];
            int n = 0;
            TString sstatus = "";
            tm ttime;
            time_t tt = time(nullptr);
            char pidstr[MAX_STR_PID];

            switch (status) {
                case KERROR:
                    sstatus = "  Err!  ";
                    break;
                case KMESSAGE:
                    sstatus = "  Mes!  ";
                    break;
                case KWARNING:
                    sstatus = "  Warn! ";
                    break;
                case KINFO:
                    sstatus = "  Inf!  ";
                    break;
            };

            memset(buf, 0, sizeof(buf));

            ttime = *localtime(&tt);
            strftime(tbuff, sizeof(tbuff) - 1, "[%Y.%m.%d %H:%M:%S]", &ttime);
            n = n + snprintf(buf + n, sizeof(buf) - n - 1, "%s %s %8s ", tbuff, GetStrPid(pidstr), sstatus.c_str());

            fprintf(handle, "%s", buf);
            fwrite(BUFF, BUFFSize, 1, handle);
            fprintf(handle, "\n");
            if (!disable_fflush)
                fflush(handle);
            res = true;
        }
    }

    UnLock();

    return res;
}

TString TLogClass::GetTekFilename() {
    TString res = "";

    Lock();

    res = tfilename;

    UnLock();
    return res;
}

void TLogClass::SetArchivePath(TString ArchivePath) {
    if (!ArchivePath.empty()) {
        int pos = 0, pos1 = 0, pos2 = 0;
        int n = 0;
        TString onlyfilename = "";

        pos1 = filename.rfind('\\');
        pos2 = filename.rfind('/');

        if ((pos1 > 0) || (pos2 > 0)) {
            pos = (pos1 > pos2) ? pos1 : pos2;
            n = filename.size() - pos - 1;
            if (n > 0) {
                ArchivePath = KTrim(ArchivePath);
                if (ArchivePath.size() > 0) {
#ifdef _win_
                    if ((ArchivePath.back() != '\\') && (ArchivePath.back() != '/'))
                        ArchivePath = ArchivePath + "\\";
#else
                    if ((ArchivePath.back() != '\\') && (ArchivePath.back() != '/'))
                        ArchivePath = ArchivePath + "/";
#endif
                }
                onlyfilename = filename.substr(pos + 1, n);
                filenamearx = ArchivePath + onlyfilename;
            }
        }
    }
}

void TLogClass::SetDisableFFlush(bool disable) {
    Lock();

    disable_fflush = disable;

    UnLock();
}

TString TLogClass::FFlushStatus() {
    TString res = "";

    if (disable_fflush)
        res = "FFLUSH_DISABLED";
    else
        res = "FFLUSH_ENABLED";

    return res;
}

bool TLogClass::IsOpenFile() {
    bool res = false;

    if (handle != nullptr)
        res = true;
    else
        res = false;

    return res;
}

void TLogClass::FFlush() {
    if (handle != nullptr)
        fflush(handle);
}

void TLogClass::RotateLogs() {
    Lock();

    TString newname = "";

    newname = tfilename + ".0";
    remove(newname.c_str());

    if (handle != nullptr) {
        fclose(handle);
        handle = nullptr;
    }
    rename(tfilename.c_str(), newname.c_str());
    if (tfilename != "") {
        CreateFileIfNotExists(tfilename);
        handle = fopen(tfilename.c_str(), openfilemode.c_str());
        if (!fileshap.empty() && (handle != nullptr)) {
            fprintf(handle, "%s", fileshap.c_str());
            if (!disable_fflush)
                fflush(handle);
        }
    }

    UnLock();
}

void TLogClass::SetFileShap(TString& shapA) {
    Lock();

    fileshap = shapA;

    UnLock();
}

//*************************************************************************************
//                                TGroupLogClass
//*************************************************************************************

TGroupLogClass::TGroupLogClass(TKConfig *IniFileA, TString filenameA, bool AddDate) {
    filename = filenameA;
    fadddate = AddDate;
    disable_fflush = false;
    IniFile = IniFileA;
    DEFAULTIDENT = "UNKNOWN";
}

TGroupLogClass::~TGroupLogClass() {
    TGroupLogHashIt it;

    it = data.begin();
    while (it != data.end()) {
        if ((*it).second != nullptr) {
            delete (*it).second;
            (*it).second = nullptr;
        }
        ++it;
    }
    data.clear();
}

TString TGroupLogClass::AddIdentToFilename(const TString &ident, bool& enabled) {
    TString res = "";

    enabled = false;
    if (IniFile != nullptr) {
        res = IniFile->ReadStroka("***" + ident, filename, "");
        enabled = IniFile->ReadBool("***" + ident, filename + "_enable", true);
    }

    return res;
}

TLogClass* TGroupLogClass::GetLogClass(const TString &Ident) {
    TLogClass       *res   = nullptr;
    TGroupLogHashIt it;
    bool            enable = false;

    it = data.find(Ident);
    if (it != data.end())
    {
        res = (*it).second;

    } else
    {
        TString   filename = AddIdentToFilename(Ident, enable);
        TLogClass *lg      = nullptr;

        if (!filename.empty())
        {
            lg = new TLogClass(filename, fadddate);
            if (lg != nullptr)
            {
                lg->SetDisableFFlush(disable_fflush);
                if (enable)
                    lg->EnableWrite();
                else
                    lg->DisableWrite();
            }
            data[Ident] = lg;
            res = lg;
        }
    }

    return res;
}

const TLog& TGroupLogClass::GetLoggerClass(const TString &Ident) {

    if (TLog *log = MapFindPtr(loggers, Ident)) {
        return *log;
    }

    TLog logger;

    bool enable = false;

    const TString f = AddIdentToFilename(Ident, enable);

    if (filename) {
        logger.ResetBackend(CreateOwningThreadedLogBackend(f));
    }

    return loggers.emplace(Ident, std::move(logger)).first->second;
}

bool TGroupLogClass::WriteMessage(const char* msg, ...) {
    bool res = false;
    TLogClass* lc = nullptr;
    TString Ident = DEFAULTIDENT;

    if (enable_write) {
        Lock();

        lc = GetLogClass(Ident);
        if (lc != nullptr) {
            va_list args;

            va_start(args, msg);
            res = lc->WriteMessage(msg, args);
            va_end(args);
        }

        UnLock();
    }

    return res;
}

bool TGroupLogClass::WriteMessage(TString Ident, const char* msg, ...) {
    bool res = false;
    TLogClass* lc = nullptr;

    if (enable_write) {
        Lock();

        lc = GetLogClass(Ident);
        if (lc != nullptr) {
            va_list args;

            va_start(args, msg);
            res = lc->WriteMessage(msg, args);
            va_end(args);
        }

        UnLock();
    }

    return res;
}

bool TGroupLogClass::WriteMessageBUFF(const char* BUFF, ui32 BUFFSize) {
    bool res = false;
    TLogClass* lc = nullptr;
    TString Ident = DEFAULTIDENT;

    if (enable_write) {
        Lock();

        lc = GetLogClass(Ident);
        if (lc != nullptr)
            res = lc->WriteMessageBUFF(BUFF, BUFFSize);

        UnLock();
    }

    return res;
}

bool TGroupLogClass::WriteMessageAndData(const char* msg, ...) {
    bool res = false;
    TLogClass* lc = nullptr;
    TString Ident = DEFAULTIDENT;

    if (enable_write) {
        Lock();

        lc = GetLogClass(Ident);
        if (lc != nullptr) {
            va_list args;

            va_start(args, msg);
            res = lc->WriteMessageAndData(msg, args);
            va_end(args);
        }

        UnLock();
    }

    return res;
}

bool TGroupLogClass::WriteMessageAndData(TString Ident, const char* msg, ...) {
    bool res = false;
    TLogClass* lc = nullptr;

    if (enable_write) {
        Lock();

        lc = GetLogClass(Ident);
        if (lc != nullptr) {
            va_list args;

            va_start(args, msg);
            res = lc->WriteMessageAndData(msg, args);
            va_end(args);
        }

        UnLock();
    }

    return res;
}

bool TGroupLogClass::WriteMessageAndDataBUFF(const char* BUFF, ui32 BUFFSize) {
    bool res = false;
    TLogClass* lc = nullptr;
    TString Ident = DEFAULTIDENT;

    if (enable_write) {
        Lock();

        lc = GetLogClass(Ident);
        if (lc != nullptr)
            res = lc->WriteMessageAndData(BUFF, BUFFSize);

        UnLock();
    }

    return res;
}

bool TGroupLogClass::WriteMessageAndDataBUFFExt(const char* /*prefix*/, const char* /*postfix*/, const char* /*BUFF*/, ui32 /*BUFFSize*/) {
    return false;
}

bool TGroupLogClass::WriteMessageAndDataStatus(TLogStatus status, const char* msg, ...) {
    bool res = false;
    TLogClass* lc = nullptr;
    TString Ident = DEFAULTIDENT;

    if (enable_write) {
        Lock();

        lc = GetLogClass(Ident);
        if (lc != nullptr) {
            va_list args;

            va_start(args, msg);
            res = lc->WriteMessageAndDataStatus(status, msg, args);
            va_end(args);
        }

        UnLock();
    }

    return res;
}

bool TGroupLogClass::WriteMessageAndDataStatus(const TString &Ident, TLogStatus status, const char* msg, ...) {
    bool res = false;
    TLogClass* lc = nullptr;

    if (enable_write) {
        Lock();

        lc = GetLogClass(Ident);
        if (lc != nullptr) {
            va_list args;

            va_start(args, msg);
            res = lc->WriteMessageAndDataStatus(status, msg, args);
            va_end(args);
        }

        UnLock();
    }

    return res;
}

bool TGroupLogClass::WriteMessageAndDataStatusBUFF(TLogStatus status, const char* BUFF, ui32 BUFFSize) {
    bool res = false;
    TLogClass* lc = nullptr;
    TString Ident = DEFAULTIDENT;

    if (enable_write) {
        Lock();

        lc = GetLogClass(Ident);
        if (lc != nullptr)
            res = lc->WriteMessageAndDataStatus(status, BUFF, BUFFSize);

        UnLock();
    }

    return res;
}

void TGroupLogClass::SetDisableFFlush(bool disable) {
    Lock();

    TGroupLogHashIt it;

    disable_fflush = disable;

    it = data.begin();
    while (it != data.end()) {
        if ((*it).second != nullptr)
            ((*it).second)->SetDisableFFlush(disable_fflush);

        ++it;
    }

    UnLock();
}

TString TGroupLogClass::FFlushStatus() {
    TString res = "";

    if (disable_fflush)
        res = "disable";
    else
        res = "enabled";

    return res;
}

bool TGroupLogClass::TruncLog() {
    Lock();

    TGroupLogHashIt it;
    bool res = true;
    bool res_it = false;

    it = data.begin();
    while (it != data.end()) {
        if ((*it).second != nullptr) {
            res_it = ((*it).second)->TruncLog();
            if (!res_it)
                res = false;
        }

        ++it;
    }

    for(auto& [_, logger]: loggers) {
        logger.ReopenLog();
    }

    UnLock();

    return res;
}

TLogClass* TGroupLogClass::GetLog(const TString &Ident) {
    TLogClass* res = nullptr;

    Lock();

    res = GetLogClass(Ident);

    UnLock();

    return res;
}

const TLog& TGroupLogClass::GetLogger(const TString &Ident) {
    Lock();
    Y_DEFER{
        UnLock();
    };

    return GetLoggerClass(Ident);
}

//*************************************************************************************
